/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexingStamp;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;

class FileBasedIndexFileTypeListener
implements FileTypeListener {
    FileBasedIndexFileTypeListener() {
    }

    @Override
    public void fileTypesChanged(@NotNull FileTypeEvent event) {
        if (event == null) {
            FileBasedIndexFileTypeListener.$$$reportNull$$$0(0);
        }
        THashSet indexesToRebuild = new THashSet();
        for (FileBasedIndexExtension<?, ?> extension : FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList()) {
            if (!IndexingStamp.versionDiffers(extension.getName(), FileBasedIndexImpl.getIndexExtensionVersion(extension))) continue;
            indexesToRebuild.add((ID<?, ?>)extension.getName());
        }
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        String rebuiltIndexesLog = indexesToRebuild.isEmpty() ? "" : "; indexes " + indexesToRebuild + " will be rebuild completely due to version change";
        fileBasedIndex.scheduleFullIndexesRescan(indexesToRebuild, "File type change" + rebuiltIndexesLog);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/FileBasedIndexFileTypeListener", "fileTypesChanged"));
    }
}

