/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexScanRunnableCollector;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class FileBasedIndexProjectHandler
implements IndexableFileSet {
    private static final Logger LOG = Logger.getInstance(FileBasedIndexProjectHandler.class);
    private final FileBasedIndexScanRunnableCollector myCollector;
    private boolean isRemoved;
    @ApiStatus.Internal
    public static final int ourMinFilesToStartDumMode = Registry.intValue("ide.dumb.mode.minFilesToStart", 20);
    private static final int ourMinFilesSizeToStartDumMode = Registry.intValue("ide.dumb.mode.minFilesSizeToStart", 0x100000);

    private FileBasedIndexProjectHandler(@NotNull Project project2) {
        if (project2 == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(0);
        }
        this.myCollector = FileBasedIndexScanRunnableCollector.getInstance(project2);
    }

    @Override
    public boolean isInSet(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(1);
        }
        return this.myCollector.shouldCollect(file2);
    }

    @Override
    public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator2) {
        if (file2 == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(2);
        }
        if (iterator2 == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(3);
        }
        VfsUtilCore.visitChildrenRecursively(file2, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!FileBasedIndexProjectHandler.this.isInSet(file2)) {
                    return false;
                }
                iterator2.processFile(file2);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexProjectHandler$1", "visitFile"));
            }
        });
    }

    @Nullable
    public static DumbModeTask createChangedFilesIndexingTask(final @NotNull Project project2) {
        FileBasedIndex i;
        if (project2 == null) {
            FileBasedIndexProjectHandler.$$$reportNull$$$0(4);
        }
        if (!((i = FileBasedIndex.getInstance()) instanceof FileBasedIndexImpl) || !IndexInfrastructure.hasIndices()) {
            return null;
        }
        final FileBasedIndexImpl index = (FileBasedIndexImpl)i;
        if (!FileBasedIndexProjectHandler.mightHaveManyChangedFilesInProject(project2, index)) {
            return null;
        }
        return new DumbModeTask(project2.getService(FileBasedIndexProjectHandler.class)){

            @Override
            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                long start2 = System.currentTimeMillis();
                Collection<VirtualFile> files2 = index.getFilesToUpdate(project2);
                long calcDuration = System.currentTimeMillis() - start2;
                indicator.setIndeterminate(false);
                indicator.setText(IdeBundle.message("progress.indexing.updating", new Object[0]));
                LOG.info("Reindexing refreshed files: " + files2.size() + " to update, calculated in " + calcDuration + "ms");
                if (!files2.isEmpty()) {
                    PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                    FileBasedIndexProjectHandler.reindexRefreshedFiles(indicator, files2, project2);
                    snapshot.logResponsivenessSinceCreation("Reindexing refreshed files");
                }
            }

            public String toString() {
                final StringBuilder sampleOfChangedFilePathsToBeIndexed = new StringBuilder();
                index.processChangedFiles(project2, (Processor<? super VirtualFile>)new Processor<VirtualFile>(){
                    int filesInProjectToBeIndexed;
                    final String projectBasePath;
                    {
                        this.projectBasePath = project2.getBasePath();
                    }

                    @Override
                    public boolean process(VirtualFile file2) {
                        if (this.filesInProjectToBeIndexed != 0) {
                            sampleOfChangedFilePathsToBeIndexed.append(", ");
                        }
                        String filePath2 = file2.getPath();
                        String loggedPath = this.projectBasePath != null ? FileUtil.getRelativePath(this.projectBasePath, filePath2, '/') : null;
                        loggedPath = loggedPath == null ? filePath2 : "%project_path%/" + loggedPath;
                        sampleOfChangedFilePathsToBeIndexed.append(loggedPath);
                        return ++this.filesInProjectToBeIndexed < ourMinFilesToStartDumMode;
                    }
                });
                return super.toString() + " [" + project2 + ", " + sampleOfChangedFilePathsToBeIndexed + "]";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/indexing/FileBasedIndexProjectHandler$2", "performInDumbMode"));
            }
        };
    }

    private static boolean mightHaveManyChangedFilesInProject(Project project2, FileBasedIndexImpl index) {
        final long start2 = System.currentTimeMillis();
        return !index.processChangedFiles(project2, (Processor<? super VirtualFile>)new Processor<VirtualFile>(){
            int filesInProjectToBeIndexed;
            long sizeOfFilesToBeIndexed;

            @Override
            public boolean process(VirtualFile file2) {
                ++this.filesInProjectToBeIndexed;
                if (file2.isValid() && !file2.isDirectory()) {
                    this.sizeOfFilesToBeIndexed += file2.getLength();
                }
                return this.filesInProjectToBeIndexed < ourMinFilesToStartDumMode && this.sizeOfFilesToBeIndexed < (long)ourMinFilesSizeToStartDumMode && System.currentTimeMillis() < start2 + 100L;
            }
        });
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static void reindexRefreshedFiles(ProgressIndicator indicator, Collection<VirtualFile> files2, Project project2) {
        FileBasedIndexImpl index = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        CacheUpdateRunner.processFiles(indicator, files2, project2, content2 -> index.processRefreshedFile(project2, (FileContent)content2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexProjectHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSet";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateIndexableFilesIn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createChangedFilesIndexingTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class FileBasedIndexProjectHandlerStartupActivity
    implements StartupActivity {
        FileBasedIndexProjectHandlerStartupActivity() {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, new ProjectManagerListener(){

                @Override
                public void projectClosing(@NotNull Project project2) {
                    FileBasedIndexProjectHandler handler2;
                    if (project2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((handler2 = project2.getServiceIfCreated(FileBasedIndexProjectHandler.class)) != null && !handler2.isRemoved) {
                        handler2.isRemoved = true;
                        FileBasedIndex.getInstance().removeIndexableSet(handler2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileBasedIndexProjectHandler$FileBasedIndexProjectHandlerStartupActivity$1", "projectClosing"));
                }
            });
        }

        @Override
        public void runActivity(final @NotNull Project project2) {
            if (project2 == null) {
                FileBasedIndexProjectHandlerStartupActivity.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isInternal()) {
                project2.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

                    @Override
                    public void exitDumbMode() {
                        LOG.info("Has changed files: " + (FileBasedIndexProjectHandler.createChangedFilesIndexingTask(project2) != null) + "; project=" + project2);
                    }
                });
            }
            FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
            PushedFilePropertiesUpdater.getInstance(project2).initializeProperties();
            if (fileBasedIndex instanceof FileBasedIndexImpl) {
                DumbService.getInstance(project2).queueTask(new UnindexedFilesUpdater(project2, IndexInfrastructure.isIndexesInitializationSuspended()));
            }
            FileBasedIndexProjectHandler handler2 = project2.getService(FileBasedIndexProjectHandler.class);
            fileBasedIndex.registerIndexableSet(handler2, project2);
            Disposer.register(project2, () -> {
                handler2.isRemoved = true;
                fileBasedIndex.removeIndexableSet(handler2);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileBasedIndexProjectHandler$FileBasedIndexProjectHandlerStartupActivity", "runActivity"));
        }
    }
}

