/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexScanRunnableCollector;
import com.intellij.util.indexing.IndexableSetContributor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class FileBasedIndexScanRunnableCollectorImpl
extends FileBasedIndexScanRunnableCollector {
    private final Project myProject;
    private final ProjectFileIndex myProjectFileIndex;
    private final boolean myDisabled;

    FileBasedIndexScanRunnableCollectorImpl(@NotNull Project project2) {
        if (project2 == null) {
            FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myProjectFileIndex = ProjectFileIndex.getInstance(this.myProject);
        this.myDisabled = LightEdit.owns(this.myProject);
    }

    @Override
    public boolean shouldCollect(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(1);
        }
        if (this.myDisabled) {
            return false;
        }
        if (this.myProjectFileIndex.isInContent(file2) || this.myProjectFileIndex.isInLibrary(file2)) {
            return !FileTypeManager.getInstance().isFileIgnored(file2);
        }
        return false;
    }

    @Override
    public List<Runnable> collectScanRootRunnables(@NotNull ContentIterator processor2, ProgressIndicator indicator) {
        if (processor2 == null) {
            FileBasedIndexScanRunnableCollectorImpl.$$$reportNull$$$0(2);
        }
        if (this.myDisabled) {
            return Collections.emptyList();
        }
        return ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return Collections.emptyList();
            }
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            Set visitedRoots = ContainerUtil.newConcurrentSet();
            tasks.add(() -> this.myProjectFileIndex.iterateContent(processor2, file2 -> !file2.isDirectory() || visitedRoots.add(file2)));
            LinkedHashSet<VirtualFile> contributedRoots = new LinkedHashSet<VirtualFile>();
            for (IndexableSetContributor contributor : IndexableSetContributor.EP_NAME.getExtensionList()) {
                if (this.myProject.isDisposed()) {
                    return tasks;
                }
                contributedRoots.addAll(IndexableSetContributor.getRootsToIndex(contributor));
                contributedRoots.addAll(IndexableSetContributor.getProjectRootsToIndex(contributor, this.myProject));
            }
            for (VirtualFile root : contributedRoots) {
                if (this.myProjectFileIndex.isInContent(root) || !visitedRoots.add(root)) continue;
                tasks.add(() -> {
                    if (this.myProject.isDisposed() || !root.isValid()) {
                        return;
                    }
                    FileBasedIndex.iterateRecursively(root, processor2, indicator, visitedRoots, null);
                });
            }
            for (AdditionalLibraryRootsProvider provider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
                if (this.myProject.isDisposed()) {
                    return tasks;
                }
                for (SyntheticLibrary syntheticLibrary : provider.getAdditionalProjectLibraries(this.myProject)) {
                    for (VirtualFile root : syntheticLibrary.getAllRoots()) {
                        if (this.myProjectFileIndex.isInContent(root) || !visitedRoots.add(root)) continue;
                        tasks.add(() -> {
                            if (this.myProject.isDisposed() || !root.isValid()) {
                                return;
                            }
                            FileBasedIndex.iterateRecursively(root, processor2, indicator, visitedRoots, this.myProjectFileIndex);
                        });
                    }
                }
            }
            for (Iterator<Object> iterator2 : ModuleManager.getInstance(this.myProject).getModules()) {
                OrderEntry[] orderEntries;
                for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance(iterator2).getOrderEntries()) {
                    if (!(orderEntry instanceof LibraryOrSdkOrderEntry) || !orderEntry.isValid()) continue;
                    LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                    VirtualFile[] libSources = entry.getRootFiles(OrderRootType.SOURCES);
                    VirtualFile[] libClasses = entry.getRootFiles(OrderRootType.CLASSES);
                    VirtualFile[][] virtualFileArrayArray = new VirtualFile[][]{libSources, libClasses};
                    int n = virtualFileArrayArray.length;
                    for (int i = 0; i < n; ++i) {
                        VirtualFile[] roots;
                        for (VirtualFile root : roots = virtualFileArrayArray[i]) {
                            if (this.myProjectFileIndex.isInContent(root) || !visitedRoots.add(root)) continue;
                            tasks.add(() -> {
                                if (this.myProject.isDisposed() || module2.isDisposed() || !root.isValid()) {
                                    return;
                                }
                                FileBasedIndex.iterateRecursively(root, processor2, indicator, visitedRoots, this.myProjectFileIndex);
                            });
                        }
                    }
                }
            }
            return tasks;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexScanRunnableCollectorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldCollect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectScanRootRunnables";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

