/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import gnu.trove.THashMap;
import gnu.trove.TIntIntHashMap;
import java.util.Map;

public class IdDataConsumer {
    private final TIntIntHashMap myResult = new TIntIntHashMap();

    public Map<IdIndexEntry, Integer> getResult() {
        THashMap<IdIndexEntry, Integer> result2 = new THashMap<IdIndexEntry, Integer>(this.myResult.size());
        this.myResult.forEachEntry((key, value2) -> {
            result2.put(new IdIndexEntry(key), value2);
            return true;
        });
        return result2;
    }

    public void addOccurrence(CharSequence charSequence, int start2, int end, int occurrenceMask) {
        int hashCode = StringUtil.stringHashCode(charSequence, start2, end);
        this.addOccurrence(hashCode, occurrenceMask);
        int hashCodeNoCase = StringUtil.stringHashCodeInsensitive(charSequence, start2, end);
        if (hashCodeNoCase != hashCode) {
            this.addOccurrence(hashCodeNoCase, occurrenceMask);
        }
    }

    public void addOccurrence(char[] chars, int start2, int end, int occurrenceMask) {
        int hashCode = StringUtil.stringHashCode(chars, start2, end);
        this.addOccurrence(hashCode, occurrenceMask);
        int hashCodeNoCase = StringUtil.stringHashCodeInsensitive(chars, start2, end);
        if (hashCodeNoCase != hashCode) {
            this.addOccurrence(hashCodeNoCase, occurrenceMask);
        }
    }

    private void addOccurrence(int hashcode, int occurrenceMask) {
        int old;
        int v;
        if (occurrenceMask != 0 && (v = (old = this.myResult.get(hashcode)) | occurrenceMask) != old) {
            this.myResult.put(hashcode, v);
        }
    }
}

