/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdFilter {
    private static final Logger LOG = Logger.getInstance(IdFilter.class);
    private static final Key<CachedValue<IdFilter>> INSIDE_PROJECT = Key.create("INSIDE_PROJECT");
    private static final Key<CachedValue<IdFilter>> OUTSIDE_PROJECT = Key.create("OUTSIDE_PROJECT");

    @NotNull
    public static IdFilter getProjectIdFilter(@NotNull Project project2, boolean includeNonProjectItems) {
        if (project2 == null) {
            IdFilter.$$$reportNull$$$0(0);
        }
        Key key = includeNonProjectItems ? OUTSIDE_PROJECT : INSIDE_PROJECT;
        CachedValueProvider provider = () -> CachedValueProvider.Result.create(IdFilter.buildProjectIdFilter(project2, includeNonProjectItems), ProjectRootManager.getInstance(project2), VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
        IdFilter idFilter = (IdFilter)CachedValuesManager.getManager(project2).getCachedValue(project2, key, provider, false);
        if (idFilter == null) {
            IdFilter.$$$reportNull$$$0(1);
        }
        return idFilter;
    }

    @NotNull
    private static IdFilter buildProjectIdFilter(final Project project2, final boolean includeNonProjectItems) {
        long started = System.currentTimeMillis();
        final BitSet idSet = new BitSet();
        ContentIterator iterator2 = fileOrDir -> {
            idSet.set(((VirtualFileWithId)((Object)fileOrDir)).getId());
            ProgressManager.checkCanceled();
            return true;
        };
        if (!includeNonProjectItems) {
            ProjectRootManager.getInstance(project2).getFileIndex().iterateContent(iterator2);
        } else {
            FileBasedIndex.getInstance().iterateIndexableFiles(iterator2, project2, ProgressIndicatorProvider.getGlobalProgressIndicator());
        }
        if (LOG.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - started;
            LOG.debug("Done filter (includeNonProjectItems=" + includeNonProjectItems + ") in " + elapsed + "ms. Total files in set: " + idSet.cardinality());
        }
        return new IdFilter(){

            @Override
            public boolean containsFileId(int id2) {
                return id2 >= 0 && idSet.get(id2);
            }

            @Override
            @NotNull
            public GlobalSearchScope getEffectiveFilteringScope() {
                GlobalSearchScope globalSearchScope = includeNonProjectItems ? GlobalSearchScope.allScope(project2) : GlobalSearchScope.projectScope(project2);
                if (globalSearchScope == null) {
                    1.$$$reportNull$$$0(0);
                }
                return globalSearchScope;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/IdFilter$1", "getEffectiveFilteringScope"));
            }
        };
    }

    public abstract boolean containsFileId(int var1);

    @Nullable
    public GlobalSearchScope getEffectiveFilteringScope() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IdFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IdFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectIdFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectIdFilter";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

