/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public class IndexAccessValidator {
    private final ThreadLocal<ID<?, ?>> ourAlreadyProcessingIndices = new ThreadLocal();

    private void checkAccessingIndexDuringOtherIndexProcessing(@NotNull ID<?, ?> indexKey) {
        ID<?, ?> alreadyProcessingIndex;
        if (indexKey == null) {
            IndexAccessValidator.$$$reportNull$$$0(0);
        }
        if ((alreadyProcessingIndex = this.ourAlreadyProcessingIndices.get()) != null && alreadyProcessingIndex != indexKey) {
            String message = MessageFormat.format("Accessing ''{0}'' during processing ''{1}''. Nested different indices processing may cause deadlock", indexKey.getName(), alreadyProcessingIndex.getName());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(message);
            }
            Logger.getInstance(FileBasedIndexImpl.class).error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T validate(@NotNull ID<?, ?> indexKey, @NotNull ThrowableComputable<T, E> runnable2) throws E {
        if (indexKey == null) {
            IndexAccessValidator.$$$reportNull$$$0(1);
        }
        if (runnable2 == null) {
            IndexAccessValidator.$$$reportNull$$$0(2);
        }
        this.checkAccessingIndexDuringOtherIndexProcessing(indexKey);
        this.ourAlreadyProcessingIndices.set(indexKey);
        try {
            T t = runnable2.compute();
            return t;
        }
        finally {
            this.ourAlreadyProcessingIndices.set(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/IndexAccessValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAccessingIndexDuringOtherIndexProcessing";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

