/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.UpdatableIndex;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IndexConfiguration {
    private final Map<ID<?, ?>, Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter>> myIndices = new THashMap();
    private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap = new TObjectIntHashMap();
    private final List<ID<?, ?>> myIndicesWithoutFileTypeInfo = new ArrayList();
    private final Map<FileType, List<ID<?, ?>>> myFileType2IndicesWithFileTypeInfoMap = new THashMap();
    private volatile boolean myFreezed;

    IndexConfiguration() {
    }

    <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> indexId) {
        assert (this.myFreezed);
        Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter> pair = this.myIndices.get(indexId);
        return pair != null ? pair.getFirst() : null;
    }

    FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            IndexConfiguration.$$$reportNull$$$0(0);
        }
        assert (this.myFreezed);
        Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter> pair = this.myIndices.get(indexId);
        assert (pair != null) : "Index data is absent for index " + indexId;
        return pair.getSecond();
    }

    void freeze() {
        this.myFreezed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <K, V> void registerIndex(ID<K, V> name, @NotNull UpdatableIndex<K, V, FileContent> index, FileBasedIndex.InputFilter inputFilter, int version2, @Nullable Collection<? extends FileType> associatedFileTypes) {
        if (index == null) {
            IndexConfiguration.$$$reportNull$$$0(1);
        }
        assert (!this.myFreezed);
        Map<ID<?, ?>, Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter>> map2 = this.myIndices;
        synchronized (map2) {
            this.myIndexIdToVersionMap.put(name, version2);
            if (associatedFileTypes != null) {
                for (FileType fileType : associatedFileTypes) {
                    List ids = this.myFileType2IndicesWithFileTypeInfoMap.computeIfAbsent(fileType, __ -> new ArrayList(5));
                    ids.add(name);
                }
            } else {
                this.myIndicesWithoutFileTypeInfo.add(name);
            }
            Pair<UpdatableIndex<K, V, FileContent>, FileBasedIndex.InputFilter> old = this.myIndices.put(name, new Pair<UpdatableIndex<K, V, FileContent>, FileBasedIndex.InputFilter>(index, inputFilter));
            if (old != null) {
                throw new IllegalStateException("Index " + old.first + " already registered for the name '" + name + "'");
            }
        }
    }

    @NotNull
    List<ID<?, ?>> getFileTypesForIndex(@NotNull FileType fileType) {
        if (fileType == null) {
            IndexConfiguration.$$$reportNull$$$0(2);
        }
        assert (this.myFreezed);
        List<ID<?, ?>> ids = this.myFileType2IndicesWithFileTypeInfoMap.get(fileType);
        if (ids == null) {
            ids = this.myIndicesWithoutFileTypeInfo;
        }
        List<ID<?, ?>> list2 = ids;
        if (list2 == null) {
            IndexConfiguration.$$$reportNull$$$0(3);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeFileTypeMappingForIndices() {
        assert (!this.myFreezed);
        Map<ID<?, ?>, Pair<UpdatableIndex<?, ?, FileContent>, FileBasedIndex.InputFilter>> map2 = this.myIndices;
        synchronized (map2) {
            for (List<ID<?, ?>> value2 : this.myFileType2IndicesWithFileTypeInfoMap.values()) {
                value2.addAll(this.myIndicesWithoutFileTypeInfo);
            }
        }
    }

    Collection<ID<?, ?>> getIndexIDs() {
        assert (this.myFreezed);
        return this.myIndices.keySet();
    }

    boolean hasIndex(ID<?, ?> name) {
        assert (this.myFreezed);
        return this.myIndices.containsKey(name);
    }

    int getIndexVersion(ID<?, ?> id2) {
        assert (this.myFreezed);
        return this.myIndexIdToVersionMap.get(id2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesForIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInputFilter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerIndex";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypesForIndex";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

