/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TObjectLongHashMap;
import gnu.trove.TObjectLongProcedure;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexingStamp {
    private static final long INDEX_DATA_OUTDATED_STAMP = -2L;
    private static final int VERSION = 15 + (SharedIndicesData.ourFileSharedIndicesEnabled ? 15 : 0) + (SharedIndicesData.DO_CHECKS ? 15 : 0);
    private static final ConcurrentMap<ID<?, ?>, IndexVersion> ourIndexIdToCreationStamp = ContainerUtil.newConcurrentMap();
    private static final long ourVfsCreationStamp = FSRecords.getCreationTimestamp();
    static final int INVALID_FILE_ID = 0;
    private static final int MIN_FS_MODIFIED_TIMESTAMP_RESOLUTION = 2000;
    private static final int OUR_INDICES_TIMESTAMP_INCREMENT = SystemProperties.getIntProperty("idea.indices.timestamp.resolution", 1);
    private static final IndexVersion NON_EXISTING_INDEX_VERSION = new IndexVersion(0L, -1, -1L);
    private static final IntObjectMap<Timestamps> myTimestampsCache = ContainerUtil.createConcurrentIntObjectMap();
    private static final BlockingQueue<Integer> ourFinishedFiles = new ArrayBlockingQueue<Integer>(100);
    private static final ReadWriteLock[] ourLocks = new ReadWriteLock[16];

    private IndexingStamp() {
    }

    public static void initPersistentIndexStamp(DataInput in) throws IOException {
        IndexVersion.advanceIndexStamp(DataInputOutputUtil.readTIME(in));
    }

    public static void savePersistentIndexStamp(DataOutput out) throws IOException {
        DataInputOutputUtil.writeTIME(out, IndexVersion.ourLastStamp);
    }

    public static synchronized void rewriteVersion(@NotNull ID<?, ?> indexId, int version2) throws IOException {
        if (indexId == null) {
            IndexingStamp.$$$reportNull$$$0(0);
        }
        final File file2 = IndexInfrastructure.getVersionFile(indexId);
        if (FileBasedIndexImpl.LOG.isDebugEnabled()) {
            FileBasedIndexImpl.LOG.debug("Rewriting " + file2 + "," + version2);
        }
        SharedIndicesData.beforeSomeIndexVersionInvalidation();
        IndexVersion newIndexVersion = IndexingStamp.getIndexVersion(indexId).nextVersion(version2, FSRecords.getCreationTimestamp());
        if (file2.exists()) {
            FileUtil.deleteWithRenaming(file2);
        } else {
            file2.getParentFile().mkdirs();
        }
        try (DataOutputStream os = FileUtilRt.doIOOperation(new FileUtilRt.RepeatableIOOperation<DataOutputStream, FileNotFoundException>(){

            @Override
            @Nullable
            public DataOutputStream execute(boolean lastAttempt) throws FileNotFoundException {
                try {
                    return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
                }
                catch (FileNotFoundException ex) {
                    if (lastAttempt) {
                        throw ex;
                    }
                    return null;
                }
            }
        });){
            assert (os != null);
            newIndexVersion.write(os);
            ourIndexIdToCreationStamp.put(indexId, newIndexVersion);
        }
    }

    public static boolean versionDiffers(@NotNull ID<?, ?> indexId, int currentIndexVersion) {
        if (indexId == null) {
            IndexingStamp.$$$reportNull$$$0(1);
        }
        IndexVersion version2 = IndexingStamp.getIndexVersion(indexId);
        if (version2.myIndexVersion != currentIndexVersion) {
            FileBasedIndexImpl.LOG.info("index version changed for '" + indexId + "'; old = " + version2.myIndexVersion + ", new = " + currentIndexVersion);
            return true;
        }
        if (version2.myCommonIndicesVersion != VERSION) {
            FileBasedIndexImpl.LOG.info("common index version changed for '" + indexId + "'; old = " + version2.myIndexVersion + ", new = " + currentIndexVersion);
            return true;
        }
        if (version2.myVfsCreationStamp != ourVfsCreationStamp) {
            FileBasedIndexImpl.LOG.info("vfs creation stamp changed; old = " + version2.myIndexVersion + ", new = " + currentIndexVersion);
            return true;
        }
        return false;
    }

    public static long getIndexCreationStamp(@NotNull ID<?, ?> indexName) {
        if (indexName == null) {
            IndexingStamp.$$$reportNull$$$0(2);
        }
        IndexVersion version2 = IndexingStamp.getIndexVersion(indexName);
        return version2.myModificationCount;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static IndexVersion getIndexVersion(@NotNull ID<?, ?> indexName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isFileIndexedStateCurrent(int fileId, ID<?, ?> indexName) {
        try {
            return IndexingStamp.getIndexStamp(fileId, indexName) == IndexingStamp.getIndexCreationStamp(indexName);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof IOException)) {
                throw e;
            }
            return false;
        }
    }

    public static void setFileIndexedStateCurrent(int fileId, ID<?, ?> id2) {
        IndexingStamp.update(fileId, id2, IndexingStamp.getIndexCreationStamp(id2));
    }

    public static void setFileIndexedStateOutdated(int fileId, ID<?, ?> id2) {
        IndexingStamp.update(fileId, id2, -2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getIndexStamp(int fileId, ID<?, ?> indexName) {
        Lock readLock = IndexingStamp.getStripedLock(fileId).readLock();
        readLock.lock();
        try {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
            if (stamp != null) {
                long l = stamp.get(indexName);
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            readLock.unlock();
        }
    }

    public static void dropIndexingTimeStamps(int fileId) throws IOException {
        try (com.intellij.util.io.DataOutputStream out = FSRecords.writeAttribute(fileId, Timestamps.PERSISTENCE);){
            new Timestamps(null).writeToStream(out);
        }
    }

    private static Timestamps createOrGetTimeStamp(int id2) {
        Timestamps timestamps;
        boolean isValid;
        boolean bl = isValid = id2 > 0;
        if (!isValid) {
            id2 = -id2;
        }
        if ((timestamps = myTimestampsCache.get(id2)) == null) {
            try (DataInputStream stream = FSRecords.readAttributeWithLock(id2, Timestamps.PERSISTENCE);){
                timestamps = new Timestamps(stream);
            }
            catch (IOException e) {
                FSRecords.handleError(e);
                throw new RuntimeException(e);
            }
            if (isValid) {
                myTimestampsCache.put(id2, timestamps);
            }
        }
        return timestamps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(int fileId, @NotNull ID<?, ?> indexName, long indexCreationStamp) {
        if (indexName == null) {
            IndexingStamp.$$$reportNull$$$0(8);
        }
        if (fileId < 0 || fileId == 0) {
            return;
        }
        Lock writeLock = IndexingStamp.getStripedLock(fileId).writeLock();
        writeLock.lock();
        try {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
            if (stamp != null) {
                stamp.set(indexName, indexCreationStamp);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<ID<?, ?>> getNontrivialFileIndexedStates(int fileId) {
        block7: {
            if (fileId != 0) {
                SmartList smartList;
                Lock readLock = IndexingStamp.getStripedLock(fileId).readLock();
                readLock.lock();
                try {
                    Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
                    if (stamp == null || stamp.myIndexStamps == null || stamp.myIndexStamps.isEmpty()) break block7;
                    SmartList retained = new SmartList();
                    stamp.myIndexStamps.forEach(object -> {
                        retained.add((ID<?, ?>)object);
                        return true;
                    });
                    SmartList smartList2 = retained;
                    smartList = smartList2;
                }
                catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
                    break block7;
                }
                finally {
                    readLock.unlock();
                }
                if (smartList == null) {
                    IndexingStamp.$$$reportNull$$$0(9);
                }
                return smartList;
            }
        }
        List<ID<?, ?>> list2 = Collections.emptyList();
        if (list2 == null) {
            IndexingStamp.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public static void flushCaches() {
        IndexingStamp.flushCache(null);
    }

    public static void flushCache(@Nullable Integer finishedFile) {
        if (finishedFile != null && finishedFile == 0) {
            finishedFile = 0;
        }
        while (finishedFile == null || !ourFinishedFiles.offer(finishedFile)) {
            ArrayList files2 = new ArrayList(ourFinishedFiles.size());
            ourFinishedFiles.drainTo(files2);
            if (!files2.isEmpty()) {
                for (Integer file2 : files2) {
                    Lock writeLock = IndexingStamp.getStripedLock(file2).writeLock();
                    writeLock.lock();
                    try {
                        Timestamps timestamp = myTimestampsCache.remove(file2);
                        if (timestamp == null || !timestamp.isDirty()) continue;
                        com.intellij.util.io.DataOutputStream sink = FSRecords.writeAttribute(file2, Timestamps.PERSISTENCE);
                        Throwable throwable = null;
                        try {
                            timestamp.writeToStream(sink);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (sink == null) continue;
                            if (throwable != null) {
                                try {
                                    sink.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            sink.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
            }
            if (finishedFile != null) continue;
            break;
        }
    }

    private static ReadWriteLock getStripedLock(int fileId) {
        if (fileId < 0) {
            fileId = -fileId;
        }
        return ourLocks[(fileId & 0xFF) % ourLocks.length];
    }

    static {
        for (int i = 0; i < ourLocks.length; ++i) {
            IndexingStamp.ourLocks[i] = new ReentrantReadWriteLock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexingStamp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexingStamp";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexVersion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNontrivialFileIndexedStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "rewriteVersion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "versionDiffers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIndexCreationStamp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndexVersion";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Timestamps {
        private static final FileAttribute PERSISTENCE = new FileAttribute("__index_stamps__", 2, false);
        private TObjectLongHashMap<ID<?, ?>> myIndexStamps;
        private boolean myIsDirty = false;

        private Timestamps(@Nullable DataInputStream stream) throws IOException {
            if (stream != null) {
                int[] outdatedIndices = null;
                long dominatingIndexStamp = DataInputOutputUtil.readTIME(stream);
                long diff = dominatingIndexStamp - 1040688000000L;
                if (diff > 0L && diff < 32767L) {
                    int numberOfOutdatedIndices = (int)diff;
                    outdatedIndices = new int[numberOfOutdatedIndices];
                    while (numberOfOutdatedIndices > 0) {
                        outdatedIndices[--numberOfOutdatedIndices] = DataInputOutputUtil.readINT(stream);
                    }
                    dominatingIndexStamp = DataInputOutputUtil.readTIME(stream);
                }
                while (stream.available() > 0) {
                    long stamp;
                    ID<?, ?> id2 = ID.findById(DataInputOutputUtil.readINT(stream));
                    if (id2 == null || id2 instanceof StubIndexKey || (stamp = IndexingStamp.getIndexCreationStamp(id2)) == 0L) continue;
                    if (this.myIndexStamps == null) {
                        this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
                    }
                    if (stamp > dominatingIndexStamp) continue;
                    this.myIndexStamps.put(id2, stamp);
                }
                if (outdatedIndices != null) {
                    for (int outdatedIndexId : outdatedIndices) {
                        ID<?, ?> id3 = ID.findById(outdatedIndexId);
                        if (id3 == null || id3 instanceof StubIndexKey || IndexingStamp.getIndexCreationStamp(id3) == 0L) continue;
                        long stamp = -2L;
                        if (this.myIndexStamps == null) {
                            this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
                        }
                        if (stamp > dominatingIndexStamp) continue;
                        this.myIndexStamps.put(id3, stamp);
                    }
                }
            }
        }

        private void writeToStream(final DataOutputStream stream) throws IOException {
            if (this.myIndexStamps != null && !this.myIndexStamps.isEmpty()) {
                final long[] data2 = new long[2];
                boolean dominatingStampIndex = false;
                boolean numberOfOutdatedIndex = true;
                this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                    @Override
                    public boolean execute(ID<?, ?> a, long b) {
                        if (b == -2L) {
                            data2[1] = data2[1] + 1L;
                            b = IndexingStamp.getIndexCreationStamp(a);
                        }
                        data2[0] = Math.max(data2[0], b);
                        return true;
                    }
                });
                if (data2[1] > 0L) {
                    assert (data2[1] < 32767L);
                    DataInputOutputUtil.writeTIME(stream, 1040688000000L + data2[1]);
                    this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                        @Override
                        public boolean execute(ID<?, ?> id2, long timestamp) {
                            try {
                                if (timestamp == -2L) {
                                    DataInputOutputUtil.writeINT(stream, id2.getUniqueId());
                                }
                                return true;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                DataInputOutputUtil.writeTIME(stream, data2[0]);
                this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                    @Override
                    public boolean execute(ID<?, ?> id2, long timestamp) {
                        try {
                            if (timestamp == -2L) {
                                return true;
                            }
                            DataInputOutputUtil.writeINT(stream, id2.getUniqueId());
                            return true;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                DataInputOutputUtil.writeTIME(stream, 1040688000000L);
            }
        }

        private long get(ID<?, ?> id2) {
            return this.myIndexStamps != null ? this.myIndexStamps.get(id2) : 0L;
        }

        private void set(ID<?, ?> id2, long tmst) {
            if (this.myIndexStamps == null) {
                this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
            }
            if (tmst == -2L && !this.myIndexStamps.contains(id2)) {
                return;
            }
            long previous = this.myIndexStamps.put(id2, tmst);
            if (previous != tmst) {
                this.myIsDirty = true;
            }
        }

        public boolean isDirty() {
            return this.myIsDirty;
        }
    }

    static class IndexVersion {
        private static volatile long ourLastStamp;
        final long myModificationCount;
        final int myIndexVersion;
        final int myCommonIndicesVersion;
        final long myVfsCreationStamp;

        private IndexVersion(long modificationCount, int indexVersion, long vfsCreationStamp) {
            this.myModificationCount = modificationCount;
            IndexVersion.advanceIndexStamp(modificationCount);
            this.myIndexVersion = indexVersion;
            this.myCommonIndicesVersion = VERSION;
            this.myVfsCreationStamp = vfsCreationStamp;
        }

        private static void advanceIndexStamp(long modificationCount) {
            ourLastStamp = Math.max(modificationCount, ourLastStamp);
        }

        IndexVersion(DataInput in) throws IOException {
            this.myIndexVersion = DataInputOutputUtil.readINT(in);
            this.myCommonIndicesVersion = DataInputOutputUtil.readINT(in);
            this.myVfsCreationStamp = DataInputOutputUtil.readTIME(in);
            this.myModificationCount = DataInputOutputUtil.readTIME(in);
            IndexVersion.advanceIndexStamp(this.myModificationCount);
        }

        void write(DataOutput os) throws IOException {
            DataInputOutputUtil.writeINT(os, this.myIndexVersion);
            DataInputOutputUtil.writeINT(os, this.myCommonIndicesVersion);
            DataInputOutputUtil.writeTIME(os, this.myVfsCreationStamp);
            DataInputOutputUtil.writeTIME(os, this.myModificationCount);
        }

        IndexVersion nextVersion(int indexVersion, long vfsCreationStamp) {
            long modificationCount = IndexVersion.calcNextVersion(this == NON_EXISTING_INDEX_VERSION ? ourLastStamp : this.myModificationCount);
            return new IndexVersion(modificationCount, indexVersion, vfsCreationStamp);
        }

        private static long calcNextVersion(long modificationCount) {
            return Math.max(System.currentTimeMillis(), Math.max(modificationCount + 2000L, ourLastStamp + (long)OUR_INDICES_TIMESTAMP_INCREMENT));
        }
    }
}

