/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.SmartList;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class InputMapExternalizer<Key, Value>
implements DataExternalizer<Map<Key, Value>> {
    private final DataExternalizer<Value> myValueExternalizer;
    private final DataExternalizer<Collection<Key>> mySnapshotIndexExternalizer;

    public InputMapExternalizer(IndexExtension<Key, Value, ?> extension) {
        this.myValueExternalizer = extension.getValueExternalizer();
        this.mySnapshotIndexExternalizer = extension instanceof CustomInputsIndexFileBasedIndexExtension ? ((CustomInputsIndexFileBasedIndexExtension)((Object)extension)).createExternalizer() : new InputIndexDataExternalizer<Key>(extension.getKeyDescriptor(), extension.getName());
    }

    @NotNull
    public DataExternalizer<Value> getValueExternalizer() {
        DataExternalizer<Value> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            InputMapExternalizer.$$$reportNull$$$0(0);
        }
        return dataExternalizer;
    }

    @Override
    public void save(@NotNull DataOutput stream, Map<Key, Value> data2) throws IOException {
        if (stream == null) {
            InputMapExternalizer.$$$reportNull$$$0(1);
        }
        int size = data2.size();
        DataInputOutputUtil.writeINT(stream, size);
        if (size > 0) {
            THashMap values2 = new THashMap();
            SmartList<Key> keysForNullValue = null;
            for (Map.Entry<Key, Value> e : data2.entrySet()) {
                SmartList<Key> keys2;
                Value value2 = e.getValue();
                SmartList<Key> smartList = keys2 = value2 != null ? (SmartList<Key>)values2.get(value2) : keysForNullValue;
                if (keys2 == null) {
                    if (value2 != null) {
                        keys2 = new SmartList();
                        values2.put(value2, keys2);
                    } else {
                        keys2 = keysForNullValue = new SmartList<Key>();
                    }
                }
                keys2.add(e.getKey());
            }
            if (keysForNullValue != null) {
                this.myValueExternalizer.save(stream, null);
                this.mySnapshotIndexExternalizer.save(stream, keysForNullValue);
            }
            for (Map.Entry<Object, Object> value3 : values2.keySet()) {
                this.myValueExternalizer.save(stream, value3);
                this.mySnapshotIndexExternalizer.save(stream, (Collection<Key>)values2.get(value3));
            }
        }
    }

    @Override
    public Map<Key, Value> read(@NotNull DataInput in) throws IOException {
        int pairs;
        if (in == null) {
            InputMapExternalizer.$$$reportNull$$$0(2);
        }
        if ((pairs = DataInputOutputUtil.readINT(in)) == 0) {
            return Collections.emptyMap();
        }
        THashMap<Key, Value> result2 = new THashMap<Key, Value>(pairs);
        while (((InputStream)((Object)in)).available() > 0) {
            Value value2 = this.myValueExternalizer.read(in);
            Collection<Key> keys2 = this.mySnapshotIndexExternalizer.read(in);
            for (Key k : keys2) {
                result2.put(k, value2);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/InputMapExternalizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/InputMapExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

