/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedIntMapForwardIndex
implements IntForwardIndex {
    private static final Logger LOG = Logger.getInstance(SharedIntMapForwardIndex.class);
    private final ID<?, ?> myIndexId;
    private final File myVerificationIndexStorageFile;
    private final boolean myVerificationIndexHasChunks;
    private volatile PersistentHashMap<Integer, Integer> myPersistentMap;

    public SharedIntMapForwardIndex(@NotNull IndexExtension<?, ?, ?> extension, @Nullable File verificationIndexStorageFile, boolean verificationIndexHasChunks) throws IOException {
        if (extension == null) {
            SharedIntMapForwardIndex.$$$reportNull$$$0(0);
        }
        this.myIndexId = (ID)extension.getName();
        this.myVerificationIndexStorageFile = verificationIndexStorageFile;
        this.myVerificationIndexHasChunks = verificationIndexHasChunks;
        if (verificationIndexStorageFile != null && (!SharedIndicesData.ourFileSharedIndicesEnabled || SharedIndicesData.DO_CHECKS)) {
            this.createMap();
        }
    }

    private void createMap() throws IOException {
        Boolean old = PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.get();
        try {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(!this.myVerificationIndexHasChunks);
            this.myPersistentMap = new PersistentHashMap<Integer, Integer>(this.myVerificationIndexStorageFile.toPath(), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE){

                @Override
                protected boolean wantNonNegativeIntegralValues() {
                    return true;
                }
            };
        }
        catch (IOException e) {
            IOUtil.deleteAllFilesStartingWith(this.myVerificationIndexStorageFile);
            throw e;
        }
        finally {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(old);
        }
    }

    @Override
    public int getInt(@NotNull Integer key) throws IOException {
        Integer verificationValue;
        if (key == null) {
            SharedIntMapForwardIndex.$$$reportNull$$$0(1);
        }
        if (!SharedIndicesData.ourFileSharedIndicesEnabled) {
            assert (this.myPersistentMap != null);
            return this.myPersistentMap.get(key);
        }
        Integer data2 = SharedIndicesData.recallFileData(key, this.myIndexId, EnumeratorIntegerDescriptor.INSTANCE);
        if (this.myPersistentMap != null && !Comparing.equal(verificationValue = this.myPersistentMap.get(key), data2)) {
            if (verificationValue != null) {
                SharedIndicesData.associateFileData(key, this.myIndexId, verificationValue, EnumeratorIntegerDescriptor.INSTANCE);
                if (data2 != null) {
                    LOG.error("Unexpected indexing diff with hash id " + this.myIndexId + ", file:" + IndexInfrastructure.findFileById(PersistentFS.getInstance(), key) + "," + verificationValue + "," + data2);
                }
            }
            data2 = verificationValue;
        }
        return data2 == null ? 0 : data2;
    }

    @Override
    public void putInt(@NotNull Integer key, int value2) throws IOException {
        if (key == null) {
            SharedIntMapForwardIndex.$$$reportNull$$$0(2);
        }
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            SharedIndicesData.associateFileData(key, this.myIndexId, value2, EnumeratorIntegerDescriptor.INSTANCE);
        }
        if (this.myPersistentMap != null) {
            this.myPersistentMap.put(key, value2);
        }
    }

    @Override
    public void force() {
        if (this.myPersistentMap != null) {
            this.myPersistentMap.force();
        }
    }

    @Override
    public void clear() throws IOException {
        PersistentHashMap.deleteMap(this.myPersistentMap);
        this.createMap();
    }

    @Override
    public void close() throws IOException {
        if (this.myPersistentMap != null) {
            this.myPersistentMap.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/SharedIntMapForwardIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "putInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

