/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutedFileType
extends LanguageFileType {
    @NotNull
    private final FileType myOriginalFileType;
    @NotNull
    private final FileType myFileType;

    private SubstitutedFileType(@NotNull FileType originalFileType, @NotNull LanguageFileType substitutionFileType, @NotNull Language substitutedLanguage) {
        if (originalFileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(0);
        }
        if (substitutionFileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(1);
        }
        if (substitutedLanguage == null) {
            SubstitutedFileType.$$$reportNull$$$0(2);
        }
        super(substitutedLanguage);
        this.myOriginalFileType = originalFileType;
        this.myFileType = substitutionFileType;
    }

    @NotNull
    public static FileType substituteFileType(@NotNull VirtualFile file2, @NotNull FileType fileType, @Nullable Project project2) {
        if (file2 == null) {
            SubstitutedFileType.$$$reportNull$$$0(3);
        }
        if (fileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                SubstitutedFileType.$$$reportNull$$$0(5);
            }
            return fileType2;
        }
        if (fileType instanceof LanguageFileType) {
            LanguageFileType substFileType;
            Language language2 = ((LanguageFileType)fileType).getLanguage();
            Language substitutedLanguage = LanguageSubstitutors.getInstance().substituteLanguage(language2, file2, project2);
            if (!substitutedLanguage.equals(language2) && (substFileType = substitutedLanguage.getAssociatedFileType()) != null) {
                return new SubstitutedFileType(fileType, substFileType, substitutedLanguage);
            }
        }
        FileType fileType3 = fileType;
        if (fileType3 == null) {
            SubstitutedFileType.$$$reportNull$$$0(6);
        }
        return fileType3;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myFileType.getName();
        if (string == null) {
            SubstitutedFileType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myFileType.getDescription();
        if (string == null) {
            SubstitutedFileType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        String string = this.myFileType.getDefaultExtension();
        if (string == null) {
            SubstitutedFileType.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return this.myFileType.getIcon();
    }

    @Override
    public String getCharset(@NotNull VirtualFile file2, byte @NotNull [] content2) {
        if (file2 == null) {
            SubstitutedFileType.$$$reportNull$$$0(10);
        }
        if (content2 == null) {
            SubstitutedFileType.$$$reportNull$$$0(11);
        }
        return this.myFileType.getCharset(file2, content2);
    }

    @NotNull
    public FileType getOriginalFileType() {
        FileType fileType = this.myOriginalFileType;
        if (fileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(12);
        }
        return fileType;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            SubstitutedFileType.$$$reportNull$$$0(13);
        }
        return fileType;
    }

    public boolean isSameFileType() {
        return this.myFileType.equals(this.myOriginalFileType);
    }

    public String toString() {
        return "SubstitutedFileType: original=" + this.myOriginalFileType + "; substituted=" + this.myFileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutionFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutedLanguage";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/SubstitutedFileType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/SubstitutedFileType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteFileType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFileType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteFileType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

