/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CollectingContentIterator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.IndexedFileWrapper;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class UnindexedFilesFinder
implements CollectingContentIterator {
    private static final Logger LOG = Logger.getInstance(UnindexedFilesFinder.class);
    private final List<VirtualFile> myFiles;
    private final Project myProject;
    private final boolean myDoTraceForFilesToBeIndexed;
    private final FileBasedIndexImpl myFileBasedIndex;
    private final Collection<FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor> myStateProcessors;
    private UpdatableIndex<FileType, Void, FileContent> myFileTypeIndex;

    UnindexedFilesFinder(@NotNull Project project2) {
        if (project2 == null) {
            UnindexedFilesFinder.$$$reportNull$$$0(0);
        }
        this.myFiles = new ArrayList<VirtualFile>();
        this.myDoTraceForFilesToBeIndexed = FileBasedIndexImpl.LOG.isTraceEnabled();
        this.myProject = project2;
        this.myFileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        this.myStateProcessors = FileBasedIndexInfrastructureExtension.EP_NAME.extensions().map(ex -> ex.createFileIndexingStatusProcessor(project2)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<VirtualFile> getFiles() {
        List<VirtualFile> files2;
        List<VirtualFile> list2 = this.myFiles;
        synchronized (list2) {
            files2 = this.myFiles;
        }
        BitSet usedFileIds = new BitSet(files2.size());
        ArrayList<VirtualFile> localFileSystemFiles = new ArrayList<VirtualFile>(files2.size() / 2);
        ArrayList<VirtualFile> archiveFiles = new ArrayList<VirtualFile>(files2.size() / 2);
        for (VirtualFile file2 : files2) {
            int fileId = ((VirtualFileWithId)((Object)file2)).getId();
            if (usedFileIds.get(fileId)) continue;
            usedFileIds.set(fileId);
            if (file2.getFileSystem() instanceof LocalFileSystem) {
                localFileSystemFiles.add(file2);
                continue;
            }
            archiveFiles.add(file2);
        }
        localFileSystemFiles.addAll(archiveFiles);
        ArrayList<VirtualFile> arrayList = localFileSystemFiles;
        if (arrayList == null) {
            UnindexedFilesFinder.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public boolean processFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            UnindexedFilesFinder.$$$reportNull$$$0(2);
        }
        return ReadAction.compute(() -> {
            if (!file2.isValid()) {
                return true;
            }
            if (file2 instanceof VirtualFileSystemEntry && ((VirtualFileSystemEntry)file2).isFileIndexed()) {
                return true;
            }
            if (!(file2 instanceof VirtualFileWithId)) {
                return true;
            }
            FileBasedIndexImpl.getFileTypeManager().freezeFileTypeTemporarilyIn(file2, () -> {
                IndexedFileImpl fileContent = new IndexedFileImpl(file2, this.myProject);
                boolean isUptoDate = true;
                boolean isDirectory = file2.isDirectory();
                int inputId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
                if (!isDirectory && !this.myFileBasedIndex.isTooLarge(file2)) {
                    if (!this.isIndexedFileTypeUpToDate(fileContent, inputId)) {
                        for (ID<?, ?> state : IndexingStamp.getNontrivialFileIndexedStates(inputId)) {
                            this.myFileBasedIndex.getIndex(state).resetIndexedStateForFile(inputId);
                        }
                        List<VirtualFile> list2 = this.myFiles;
                        synchronized (list2) {
                            this.myFiles.add(file2);
                        }
                        isUptoDate = false;
                    }
                    if (isUptoDate) {
                        List<ID<?, ?>> affectedIndexCandidates = this.myFileBasedIndex.getAffectedIndexCandidates(file2);
                        int size = affectedIndexCandidates.size();
                        for (int i = 0; i < size; ++i) {
                            ID<?, ?> indexId = affectedIndexCandidates.get(i);
                            try {
                                if (!this.myFileBasedIndex.needsFileContentLoading(indexId)) continue;
                                FileBasedIndexImpl.FileIndexingState fileIndexingState = this.myFileBasedIndex.shouldIndexFile(fileContent, indexId);
                                if (fileIndexingState == FileBasedIndexImpl.FileIndexingState.UP_TO_DATE) {
                                    this.myStateProcessors.forEach(p -> p.processUpToDateFile(file2, inputId, indexId));
                                    continue;
                                }
                                if (fileIndexingState != FileBasedIndexImpl.FileIndexingState.SHOULD_INDEX) continue;
                                if (this.myDoTraceForFilesToBeIndexed) {
                                    LOG.trace("Scheduling indexing of " + file2 + " by request of index " + indexId);
                                }
                                List<VirtualFile> list3 = this.myFiles;
                                synchronized (list3) {
                                    this.myFiles.add(file2);
                                }
                                isUptoDate = false;
                                break;
                            }
                            catch (RuntimeException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof IOException || cause instanceof StorageException) {
                                    LOG.info(e);
                                    this.myFileBasedIndex.requestRebuild(indexId);
                                    continue;
                                }
                                throw e;
                            }
                        }
                    }
                }
                for (ID<?, ?> indexId : this.myFileBasedIndex.getContentLessIndexes(isDirectory)) {
                    if (this.myFileBasedIndex.shouldIndexFile(fileContent, indexId) != FileBasedIndexImpl.FileIndexingState.SHOULD_INDEX) continue;
                    this.myFileBasedIndex.updateSingleIndex(indexId, file2, inputId, new IndexedFileWrapper(fileContent));
                }
                IndexingStamp.flushCache(inputId);
                if (isUptoDate && file2 instanceof VirtualFileSystemEntry) {
                    ((VirtualFileSystemEntry)file2).setFileIndexed(true);
                }
            });
            ProgressManager.checkCanceled();
            return true;
        });
    }

    private boolean isIndexedFileTypeUpToDate(@NotNull IndexedFile file2, int inputId) {
        if (file2 == null) {
            UnindexedFilesFinder.$$$reportNull$$$0(3);
        }
        if (this.myFileTypeIndex == null) {
            this.myFileTypeIndex = this.myFileBasedIndex.getIndex(FileTypeIndex.NAME);
            if (this.myFileTypeIndex == null) {
                throw new IllegalStateException();
            }
        }
        return this.myFileTypeIndex.isIndexedStateForFile(inputId, file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/UnindexedFilesFinder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/UnindexedFilesFinder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIndexedFileTypeUpToDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

