/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.io.AppendableStorageBackedByResizableMappedFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.TIntHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VfsAwareMapIndexStorage<Key, Value>
extends MapIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private static final Logger LOG = Logger.getInstance(MapIndexStorage.class);
    private static final boolean ENABLE_CACHED_HASH_IDS = SystemProperties.getBooleanProperty("idea.index.no.cashed.hashids", true);
    private final boolean myBuildKeyHashToVirtualFileMapping;
    private AppendableStorageBackedByResizableMappedFile myKeyHashToVirtualFileMapping;
    private volatile int myLastScannedId;
    private static final ConcurrentIntObjectMap<Boolean> ourInvalidatedSessionIds = ContainerUtil.createConcurrentIntObjectMap();
    private static volatile File mySessionDirectory;

    public VfsAwareMapIndexStorage(@NotNull Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean readOnly) throws IOException {
        if (storageFile == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(0);
        }
        if (keyDescriptor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(1);
        }
        if (valueExternalizer == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(2);
        }
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, false, true, readOnly, null);
        this.myBuildKeyHashToVirtualFileMapping = false;
    }

    public VfsAwareMapIndexStorage(@NotNull File storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile, boolean buildKeyHashToVirtualFileMapping) throws IOException {
        if (storageFile == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(3);
        }
        if (keyDescriptor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(4);
        }
        if (valueExternalizer == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(5);
        }
        super(storageFile.toPath(), keyDescriptor, valueExternalizer, cacheSize, keyIsUniqueForIndexedFile, false, false, null);
        this.myBuildKeyHashToVirtualFileMapping = buildKeyHashToVirtualFileMapping;
        this.initMapAndCache();
    }

    public VfsAwareMapIndexStorage(@NotNull Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile, boolean buildKeyHashToVirtualFileMapping) throws IOException {
        if (storageFile == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(6);
        }
        if (keyDescriptor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(7);
        }
        if (valueExternalizer == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(8);
        }
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, keyIsUniqueForIndexedFile, false, false, null);
        this.myBuildKeyHashToVirtualFileMapping = buildKeyHashToVirtualFileMapping;
        this.initMapAndCache();
    }

    @Override
    protected void initMapAndCache() throws IOException {
        super.initMapAndCache();
        if (this.myBuildKeyHashToVirtualFileMapping) {
            assert (this.getProjectFile().getFileSystem() == FileSystems.getDefault());
            this.myKeyHashToVirtualFileMapping = new AppendableStorageBackedByResizableMappedFile(this.getProjectFile(), 4096, null, 0x100000, true);
        } else {
            this.myKeyHashToVirtualFileMapping = null;
        }
    }

    @Override
    protected void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    @NotNull
    private Path getProjectFile() {
        Path path2 = this.myBaseStorageFile.resolveSibling(this.myBaseStorageFile.getFileName() + ".project");
        if (path2 == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(9);
        }
        return path2;
    }

    private <T extends Throwable> void withLock(ThrowableRunnable<T> r) throws T {
        this.myKeyHashToVirtualFileMapping.getPagedFileStorage().lock();
        try {
            r.run();
        }
        finally {
            this.myKeyHashToVirtualFileMapping.getPagedFileStorage().unlock();
        }
    }

    @Override
    public void flush() {
        this.l.lock();
        try {
            super.flush();
            if (this.myKeyHashToVirtualFileMapping != null && this.myKeyHashToVirtualFileMapping.isDirty()) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.force());
            }
        }
        finally {
            this.l.unlock();
        }
    }

    @Override
    public void close() throws StorageException {
        super.close();
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.close());
            }
        }
        catch (RuntimeException e) {
            VfsAwareMapIndexStorage.unwrapCauseAndRethrow(e);
        }
    }

    @Override
    public void clear() throws StorageException {
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.close());
            }
        }
        catch (RuntimeException e) {
            LOG.info(e);
        }
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                IOUtil.deleteAllFilesStartingWith(this.getProjectFile().toFile());
            }
        }
        catch (RuntimeException e) {
            VfsAwareMapIndexStorage.unwrapCauseAndRethrow(e);
        }
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processKeys(@NotNull Processor<? super Key> processor2, GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(10);
        }
        this.l.lock();
        try {
            this.myCache.clear();
            if (this.myBuildKeyHashToVirtualFileMapping && idFilter != null) {
                TIntHashSet finalHashMaskSet;
                TIntHashSet hashMaskSet = null;
                long l = System.currentTimeMillis();
                GlobalSearchScope filterScope = idFilter.getEffectiveFilteringScope();
                GlobalSearchScope effectiveFilteringScope = filterScope != null ? filterScope : scope;
                File fileWithCaches = this.getSavedProjectFileValueIds(this.myLastScannedId, effectiveFilteringScope);
                boolean useCachedHashIds = ENABLE_CACHED_HASH_IDS && (effectiveFilteringScope instanceof ProjectScopeImpl || effectiveFilteringScope instanceof ProjectAndLibrariesScope) && fileWithCaches != null;
                int id2 = this.myKeyHashToVirtualFileMapping.getCurrentLength();
                if (useCachedHashIds && id2 == this.myLastScannedId && ourInvalidatedSessionIds.remove(id2) == null) {
                    try {
                        hashMaskSet = VfsAwareMapIndexStorage.loadHashedIds(fileWithCaches);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (hashMaskSet == null) {
                    if (useCachedHashIds && this.myLastScannedId != 0) {
                        FileUtil.asyncDelete(fileWithCaches);
                    }
                    finalHashMaskSet = hashMaskSet = new TIntHashSet(1000);
                    this.withLock(() -> {
                        this.myKeyHashToVirtualFileMapping.force();
                        ProgressManager.checkCanceled();
                        this.myKeyHashToVirtualFileMapping.processAll(key -> {
                            ProgressManager.checkCanceled();
                            if (!idFilter.containsFileId(key[1])) {
                                return true;
                            }
                            finalHashMaskSet.add(key[0]);
                            return true;
                        }, IntPairInArrayKeyDescriptor.INSTANCE);
                    });
                    if (useCachedHashIds) {
                        this.saveHashedIds(hashMaskSet, id2, effectiveFilteringScope);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanned keyHashToVirtualFileMapping of " + this.myBaseStorageFile + " for " + (System.currentTimeMillis() - l));
                }
                finalHashMaskSet = hashMaskSet;
                boolean bl = this.doProcessKeys(key -> {
                    if (!finalHashMaskSet.contains(this.myKeyDescriptor.getHashCode(key))) {
                        return true;
                    }
                    return processor2.process((Key)key);
                });
                return bl;
            }
            boolean hashMaskSet = this.doProcessKeys(processor2);
            return hashMaskSet;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            boolean bl = (Boolean)VfsAwareMapIndexStorage.unwrapCauseAndRethrow(e);
            return bl;
        }
        finally {
            this.l.unlock();
        }
    }

    @NotNull
    private static TIntHashSet loadHashedIds(@NotNull File fileWithCaches) throws IOException {
        TIntHashSet tIntHashSet;
        if (fileWithCaches == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(11);
        }
        try (DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(fileWithCaches)));){
            int capacity;
            TIntHashSet hashMaskSet = new TIntHashSet(capacity);
            for (capacity = DataInputOutputUtil.readINT(inputStream); capacity > 0; --capacity) {
                hashMaskSet.add(DataInputOutputUtil.readINT(inputStream));
            }
            TIntHashSet tIntHashSet2 = hashMaskSet;
            tIntHashSet = tIntHashSet2;
        }
        if (tIntHashSet == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(12);
        }
        return tIntHashSet;
    }

    private void saveHashedIds(@NotNull TIntHashSet hashMaskSet, int largestId, @NotNull GlobalSearchScope scope) {
        boolean savedSuccessfully;
        if (hashMaskSet == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(14);
        }
        File newFileWithCaches = this.getSavedProjectFileValueIds(largestId, scope);
        assert (newFileWithCaches != null);
        try (DataOutputStream stream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newFileWithCaches)));){
            DataInputOutputUtil.writeINT(stream, hashMaskSet.size());
            savedSuccessfully = hashMaskSet.forEach(value2 -> {
                try {
                    DataInputOutputUtil.writeINT(stream, value2);
                    return true;
                }
                catch (IOException ex) {
                    return false;
                }
            });
        }
        catch (IOException ignored) {
            savedSuccessfully = false;
        }
        if (savedSuccessfully) {
            this.myLastScannedId = largestId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getSessionDir() {
        File sessionDirectory = mySessionDirectory;
        if (sessionDirectory != null) return sessionDirectory;
        Class<VfsAwareMapIndexStorage> clazz = VfsAwareMapIndexStorage.class;
        synchronized (VfsAwareMapIndexStorage.class) {
            sessionDirectory = mySessionDirectory;
            if (sessionDirectory != null) return sessionDirectory;
            try {
                mySessionDirectory = sessionDirectory = FileUtil.createTempDirectory(new File(PathManager.getTempPath()), Long.toString(System.currentTimeMillis()), "", true);
            }
            catch (IOException ex) {
                throw new RuntimeException("Can not create temp directory", ex);
            }
            return sessionDirectory;
        }
    }

    @Nullable
    private File getSavedProjectFileValueIds(int id2, @NotNull GlobalSearchScope scope) {
        Project project2;
        if (scope == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(15);
        }
        if ((project2 = scope.getProject()) == null) {
            return null;
        }
        return new File(VfsAwareMapIndexStorage.getSessionDir(), this.getProjectFile().toFile().getName() + "." + project2.hashCode() + "." + id2 + "." + scope.isSearchInLibraries());
    }

    @Override
    public void addValue(Key key, int inputId, Value value2) throws StorageException {
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.append(new int[]{this.myKeyDescriptor.getHashCode(key), inputId}, IntPairInArrayKeyDescriptor.INSTANCE));
                int lastScannedId = this.myLastScannedId;
                if (lastScannedId != 0) {
                    ourInvalidatedSessionIds.cacheOrGet(lastScannedId, Boolean.TRUE);
                    this.myLastScannedId = 0;
                }
            }
            super.addValue(key, inputId, value2);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFile";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/VfsAwareMapIndexStorage";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWithCaches";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashMaskSet";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/VfsAwareMapIndexStorage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadHashedIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadHashedIds";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveHashedIds";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSavedProjectFileValueIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IntPairInArrayKeyDescriptor
    implements KeyDescriptor<int[]>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private static final IntPairInArrayKeyDescriptor INSTANCE = new IntPairInArrayKeyDescriptor();

        private IntPairInArrayKeyDescriptor() {
        }

        @Override
        public void save(@NotNull DataOutput out, int[] value2) throws IOException {
            if (out == null) {
                IntPairInArrayKeyDescriptor.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT(out, value2[0]);
            DataInputOutputUtil.writeINT(out, value2[1]);
        }

        @Override
        public int[] read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                IntPairInArrayKeyDescriptor.$$$reportNull$$$0(1);
            }
            return new int[]{DataInputOutputUtil.readINT(in), DataInputOutputUtil.readINT(in)};
        }

        @Override
        public int getHashCode(int[] value2) {
            return value2[0] * 31 + value2[1];
        }

        @Override
        public boolean isEqual(int[] val1, int[] val2) {
            return val1[0] == val2[0] && val1[1] == val2[1];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/indexing/VfsAwareMapIndexStorage$IntPairInArrayKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

