/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class InputIndexDataExternalizer<K>
implements DataExternalizer<Collection<K>> {
    private final KeyDescriptor<K> myKeyDescriptor;
    private final IndexId<K, ?> myIndexId;

    public InputIndexDataExternalizer(KeyDescriptor<K> keyDescriptor, IndexId<K, ?> indexId) {
        this.myKeyDescriptor = keyDescriptor;
        this.myIndexId = indexId;
    }

    @Override
    public void save(@NotNull DataOutput out, @NotNull Collection<K> value2) throws IOException {
        if (out == null) {
            InputIndexDataExternalizer.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            InputIndexDataExternalizer.$$$reportNull$$$0(1);
        }
        try {
            DataInputOutputUtil.writeINT(out, value2.size());
            for (K key : value2) {
                this.myKeyDescriptor.save(out, key);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Error saving data for index " + this.myIndexId, e);
        }
    }

    @Override
    @NotNull
    public Collection<K> read(@NotNull DataInput in) throws IOException {
        ArrayList arrayList;
        if (in == null) {
            InputIndexDataExternalizer.$$$reportNull$$$0(2);
        }
        try {
            int size = DataInputOutputUtil.readINT(in);
            ArrayList list2 = new ArrayList(size);
            for (int idx = 0; idx < size; ++idx) {
                list2.add(this.myKeyDescriptor.read(in));
            }
            arrayList = list2;
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Error reading data for index " + this.myIndexId, e);
        }
        if (arrayList == null) {
            InputIndexDataExternalizer.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/InputIndexDataExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/InputIndexDataExternalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

