/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.CollectionInputDataDiffBuilder;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapInputDataDiffBuilder<Key, Value>
extends DirectInputDataDiffBuilder<Key, Value> {
    private static final boolean ourDiffUpdateEnabled = SystemProperties.getBooleanProperty("idea.disable.diff.index.update", true);
    @NotNull
    private final Map<Key, Value> myMap;
    private static final AtomicInteger requests = new AtomicInteger();
    private static final AtomicInteger totalRemovals = new AtomicInteger();
    private static final AtomicInteger totalAdditions = new AtomicInteger();
    private static final AtomicInteger incrementalRemovals = new AtomicInteger();
    private static final AtomicInteger incrementalAdditions = new AtomicInteger();
    private static final AtomicInteger noopModifications = new AtomicInteger();

    public MapInputDataDiffBuilder(int inputId, @Nullable Map<Key, Value> map2) {
        super(inputId);
        this.myMap = map2 == null ? Collections.emptyMap() : map2;
    }

    @Override
    public boolean differentiate(@NotNull Map<Key, Value> newData, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> addProcessor, @NotNull KeyValueUpdateProcessor<? super Key, ? super Value> updateProcessor, @NotNull RemovedKeyProcessor<? super Key> removeProcessor) throws StorageException {
        if (newData == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(0);
        }
        if (addProcessor == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(1);
        }
        if (updateProcessor == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(2);
        }
        if (removeProcessor == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(3);
        }
        if (ourDiffUpdateEnabled) {
            if (this.myMap.isEmpty()) {
                EmptyInputDataDiffBuilder.processKeys(newData, addProcessor, this.myInputId);
            } else if (newData.isEmpty()) {
                this.processAllKeysAsDeleted(removeProcessor);
            } else {
                Key key;
                int added = 0;
                int removed = 0;
                for (Map.Entry<Key, Value> e : this.myMap.entrySet()) {
                    key = e.getKey();
                    Value newValue = newData.get(key);
                    if (Comparing.equal(e.getValue(), newValue) && (newValue != null || newData.containsKey(key))) continue;
                    if (!newData.containsKey(key)) {
                        removeProcessor.process(key, this.myInputId);
                        ++removed;
                        continue;
                    }
                    updateProcessor.process(key, newValue, this.myInputId);
                    ++added;
                    ++removed;
                }
                for (Map.Entry<Key, Value> e : newData.entrySet()) {
                    key = e.getKey();
                    if (this.myMap.containsKey(key)) continue;
                    addProcessor.process(key, e.getValue(), this.myInputId);
                    ++added;
                }
                incrementalAdditions.addAndGet(added);
                incrementalRemovals.addAndGet(removed);
                int totalRequests = requests.incrementAndGet();
                totalRemovals.addAndGet(this.myMap.size());
                totalAdditions.addAndGet(newData.size());
                if ((totalRequests & 0xFFFF) == 0 && DebugAssertions.DEBUG) {
                    Logger.getInstance(this.getClass()).info("Incremental index diff update:" + requests + ", removals:" + totalRemovals + "->" + incrementalRemovals + ", additions:" + totalAdditions + "->" + incrementalAdditions + ", no op changes:" + noopModifications);
                }
                if (added == 0 && removed == 0) {
                    noopModifications.incrementAndGet();
                    return false;
                }
            }
        } else {
            CollectionInputDataDiffBuilder.differentiateWithKeySeq(this.myMap.keySet(), newData, this.myInputId, addProcessor, removeProcessor);
        }
        return true;
    }

    private void processAllKeysAsDeleted(final RemovedKeyProcessor<? super Key> removeProcessor) throws StorageException {
        if (this.myMap instanceof THashMap) {
            final StorageException[] exception = new StorageException[]{null};
            ((THashMap)this.myMap).forEachEntry(new TObjectObjectProcedure<Key, Value>(){

                @Override
                public boolean execute(Key k, Value v) {
                    try {
                        removeProcessor.process(k, MapInputDataDiffBuilder.this.myInputId);
                    }
                    catch (StorageException e) {
                        exception[0] = e;
                        return false;
                    }
                    return true;
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        } else {
            for (Key key : this.myMap.keySet()) {
                removeProcessor.process(key, this.myInputId);
            }
        }
    }

    @Override
    @NotNull
    public Collection<Key> getKeys() {
        Set<Key> set = this.myMap.keySet();
        if (set == null) {
            MapInputDataDiffBuilder.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/MapInputDataDiffBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/MapInputDataDiffBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "differentiate";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

