/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.perFileVersion;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.CachingEnumerator;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentSubIndexerVersionEnumerator<SubIndexerVersion>
implements Closeable {
    private static final Logger LOG = Logger.getInstance(PersistentSubIndexerVersionEnumerator.class);
    private static volatile int STORAGE_SIZE_LIMIT = 0x100000;
    @NotNull
    private final CachingEnumerator<SubIndexerVersion> myEnumerator;
    @NotNull
    private final File myFile;
    @NotNull
    private final KeyDescriptor<SubIndexerVersion> mySubIndexerTypeDescriptor;
    private volatile PersistentHashMap<SubIndexerVersion, Integer> myMap;
    private volatile int myNextVersion;

    public PersistentSubIndexerVersionEnumerator(@NotNull File file2, @NotNull KeyDescriptor<SubIndexerVersion> subIndexerTypeDescriptor) throws IOException {
        if (file2 == null) {
            PersistentSubIndexerVersionEnumerator.$$$reportNull$$$0(0);
        }
        if (subIndexerTypeDescriptor == null) {
            PersistentSubIndexerVersionEnumerator.$$$reportNull$$$0(1);
        }
        this.myFile = file2;
        this.mySubIndexerTypeDescriptor = subIndexerTypeDescriptor;
        this.myEnumerator = new CachingEnumerator<SubIndexerVersion>(new MyEnumerator(), subIndexerTypeDescriptor);
        this.init();
        if (this.myNextVersion >= STORAGE_SIZE_LIMIT) {
            throw new IOException("Rebuild index due to attribute version enumerator overflow");
        }
    }

    public int enumerate(SubIndexerVersion version2) throws IOException {
        return this.myEnumerator.enumerate(version2);
    }

    public SubIndexerVersion valueOf(int idx) throws IOException {
        for (SubIndexerVersion version2 : this.myMap.getAllKeysWithExistingMapping()) {
            Integer versionIdx = this.myMap.get(version2);
            if (!Comparing.equal(idx, versionIdx)) continue;
            return version2;
        }
        return null;
    }

    private void init() throws IOException {
        this.myMap = new PersistentHashMap<SubIndexerVersion, Integer>(this.myFile, this.mySubIndexerTypeDescriptor, EnumeratorIntegerDescriptor.INSTANCE){};
        File nextVersionFile = PersistentSubIndexerVersionEnumerator.getNextVersionFile(this.myFile);
        String intValue = nextVersionFile.exists() ? FileUtil.loadFile(nextVersionFile, StandardCharsets.UTF_8) : String.valueOf(1);
        try {
            this.myNextVersion = Integer.parseInt(intValue);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid next version format " + intValue);
        }
    }

    public void clear() throws IOException {
        PersistentHashMap.deleteMap(this.myMap);
        this.init();
    }

    public void flush() throws IOException {
        this.myMap.force();
        FileUtil.writeToFile(PersistentSubIndexerVersionEnumerator.getNextVersionFile(this.myFile), String.valueOf(this.myNextVersion));
    }

    @Override
    public void close() throws IOException {
        if (!this.myMap.isClosed()) {
            this.myMap.close();
        }
        FileUtil.writeToFile(PersistentSubIndexerVersionEnumerator.getNextVersionFile(this.myFile), String.valueOf(this.myNextVersion));
    }

    @NotNull
    private static File getNextVersionFile(File baseFile) {
        return new File(baseFile.getAbsolutePath() + ".next");
    }

    public static void setStorageSizeLimit(int storageSizeLimit) {
        STORAGE_SIZE_LIMIT = storageSizeLimit;
    }

    public static int getStorageSizeLimit() {
        return STORAGE_SIZE_LIMIT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "subIndexerTypeDescriptor";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/indexing/impl/perFileVersion/PersistentSubIndexerVersionEnumerator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyEnumerator
    implements DataEnumerator<SubIndexerVersion> {
        private MyEnumerator() {
        }

        @Override
        public synchronized int enumerate(@Nullable SubIndexerVersion value2) throws IOException {
            Integer val = (Integer)PersistentSubIndexerVersionEnumerator.this.myMap.get(value2);
            if (val != null) {
                return val;
            }
            PersistentSubIndexerVersionEnumerator.this.myMap.put(value2, ++PersistentSubIndexerVersionEnumerator.this.myNextVersion);
            if (PersistentSubIndexerVersionEnumerator.this.myNextVersion == Integer.MAX_VALUE) {
                throw new IOException("Request index rebuild");
            }
            return PersistentSubIndexerVersionEnumerator.this.myNextVersion;
        }

        @Override
        @Nullable
        public SubIndexerVersion valueOf(int idx) {
            throw new UnsupportedOperationException();
        }
    }
}

