/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ReadOnlyMappedBufferWrapper;
import com.intellij.util.io.ReadWriteDirectBufferWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;

public abstract class ByteBufferWrapper {
    protected final Path myFile;
    protected final long myPosition;
    protected final long myLength;
    protected volatile boolean myDirty;

    protected ByteBufferWrapper(Path file2, long offset, long length) {
        this.myFile = file2;
        this.myPosition = offset;
        this.myLength = length;
    }

    @Nullable
    public abstract ByteBuffer getCachedBuffer();

    public final void markDirty() {
        if (!this.myDirty) {
            this.myDirty = true;
        }
    }

    public final boolean isDirty() {
        return this.myDirty;
    }

    public abstract ByteBuffer getBuffer() throws IOException;

    public abstract void unmap();

    public abstract void flush();

    public void dispose() {
        this.unmap();
    }

    public static ByteBufferWrapper readWriteDirect(Path file2, long offset, int length) {
        return new ReadWriteDirectBufferWrapper(file2, offset, length);
    }

    public static ByteBufferWrapper readOnly(Path file2, int offset) throws IOException {
        return new ReadOnlyMappedBufferWrapper(file2, offset);
    }

    public String toString() {
        return "Buffer for " + this.myFile + ", offset:" + this.myPosition + ", size: " + this.myLength;
    }

    public int allocationSize() {
        return (int)this.myLength;
    }
}

