/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Decompressor {
    @Nullable
    private Condition<? super String> myFilter = null;
    @Nullable
    private List<String> myPathsPrefix = null;
    private boolean myOverwrite = true;
    @Nullable
    private Consumer<? super File> myConsumer;

    public Decompressor filter(@Nullable Condition<? super String> filter2) {
        this.myFilter = filter2;
        return this;
    }

    public Decompressor overwrite(boolean overwrite) {
        this.myOverwrite = overwrite;
        return this;
    }

    public Decompressor postprocessor(@Nullable Consumer<? super File> consumer) {
        this.myConsumer = consumer;
        return this;
    }

    @NotNull
    public Decompressor removePrefixPath(@Nullable String prefix) throws IOException {
        this.myPathsPrefix = prefix != null ? Decompressor.normalizePathAndSplit(prefix) : null;
        Decompressor decompressor = this;
        if (decompressor == null) {
            Decompressor.$$$reportNull$$$0(0);
        }
        return decompressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(@NotNull File outputDir) throws IOException {
        if (outputDir == null) {
            Decompressor.$$$reportNull$$$0(1);
        }
        this.openStream();
        try {
            Entry entry;
            while ((entry = this.nextEntry()) != null) {
                String entryName;
                if (this.myFilter != null && !this.myFilter.value(entryName = entry.type == Type.DIR && !StringUtil.endsWithChar(entry.name, '/') ? entry.name + '/' : entry.name) || this.myPathsPrefix != null && (entry = entry.mapPathPrefix(this.myPathsPrefix)) == null) continue;
                File outputFile = Decompressor.entryFile(outputDir, entry.name);
                switch (entry.type) {
                    case DIR: {
                        FileUtil.createDirectory(outputFile);
                        break;
                    }
                    case FILE: {
                        if (outputFile.exists() && !this.myOverwrite) break;
                        InputStream inputStream = this.openEntryStream(entry);
                        try {
                            FileUtil.createParentDirs(outputFile);
                            try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                                FileUtil.copy(inputStream, outputStream);
                            }
                            if (!entry.isWritable && !outputFile.setWritable(false, false)) {
                                throw new IOException("Can't make file read-only: " + outputFile);
                            }
                            if (entry.isExecutable && SystemInfo.isUnix && !outputFile.setExecutable(true, true)) {
                                throw new IOException("Can't make file executable: " + outputFile);
                            }
                            break;
                        }
                        finally {
                            this.closeEntryStream(inputStream);
                        }
                    }
                    case SYMLINK: {
                        if (StringUtil.isEmpty(entry.linkTarget) || !FileUtil.isAncestor(outputDir, new File(FileUtil.toCanonicalPath(outputFile.getParent() + '/' + entry.linkTarget)), true)) {
                            throw new IOException("Invalid symlink entry: " + entry.name + " -> " + entry.linkTarget);
                        }
                        FileUtil.createParentDirs(outputFile);
                        Files.createSymbolicLink(outputFile.toPath(), Paths.get(entry.linkTarget, new String[0]), new FileAttribute[0]);
                    }
                }
                if (this.myConsumer == null) continue;
                this.myConsumer.consume(outputFile);
            }
        }
        finally {
            this.closeStream();
        }
    }

    protected Decompressor() {
    }

    protected abstract void openStream() throws IOException;

    protected abstract Entry nextEntry() throws IOException;

    protected abstract InputStream openEntryStream(Entry var1) throws IOException;

    protected abstract void closeEntryStream(InputStream var1) throws IOException;

    protected abstract void closeStream() throws IOException;

    private static List<String> normalizePathAndSplit(@NotNull String path2) throws IOException {
        if (path2 == null) {
            Decompressor.$$$reportNull$$$0(2);
        }
        Decompressor.ensureValidPath(path2);
        String canonicalPath = FileUtil.toCanonicalPath(path2, '/');
        return FileUtil.splitPath(StringUtil.trimLeading(canonicalPath, '/'), '/');
    }

    private static void ensureValidPath(@NotNull String entryName) throws IOException {
        if (entryName == null) {
            Decompressor.$$$reportNull$$$0(3);
        }
        if (entryName.contains("..") && ArrayUtil.contains("..", entryName.split("[/\\\\]"))) {
            throw new IOException("Invalid entry name: " + entryName);
        }
    }

    @NotNull
    public static File entryFile(@NotNull File outputDir, @NotNull String entryName) throws IOException {
        if (outputDir == null) {
            Decompressor.$$$reportNull$$$0(4);
        }
        if (entryName == null) {
            Decompressor.$$$reportNull$$$0(5);
        }
        Decompressor.ensureValidPath(entryName);
        return new File(outputDir, entryName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/Decompressor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "removePrefixPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/Decompressor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "normalizePathAndSplit";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "entryFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class Entry {
        final String name;
        final Type type;
        final boolean isWritable;
        final boolean isExecutable;
        final String linkTarget;

        protected Entry(String name, boolean isDirectory) {
            this(name, isDirectory ? Type.DIR : Type.FILE, true, false, null);
        }

        protected Entry(String name, Type type, boolean isWritable, boolean isExecutable, String linkTarget) {
            this.name = name;
            this.type = type;
            this.isWritable = isWritable;
            this.isExecutable = isExecutable;
            this.linkTarget = linkTarget;
        }

        @Nullable
        protected Entry mapPathPrefix(@NotNull List<String> prefix) throws IOException {
            if (prefix == null) {
                Entry.$$$reportNull$$$0(0);
            }
            List ourPathSplit = Decompressor.normalizePathAndSplit(this.name);
            if (prefix.size() >= ourPathSplit.size()) {
                return null;
            }
            if (!ourPathSplit.subList(0, prefix.size()).equals(prefix)) {
                return null;
            }
            String newName = StringUtil.join(ourPathSplit.subList(prefix.size(), ourPathSplit.size()), "/");
            return new Entry(newName, this.type, this.isWritable, this.isExecutable, this.linkTarget);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/util/io/Decompressor$Entry", "mapPathPrefix"));
        }
    }

    private static enum Type {
        FILE,
        DIR,
        SYMLINK;

    }

    private static class CommonsZip
    extends Decompressor {
        private final File mySource;
        private ZipFile myZip;
        private Enumeration<? extends ZipArchiveEntry> myEntries;
        private ZipArchiveEntry myEntry;

        CommonsZip(@NotNull File file2) {
            if (file2 == null) {
                CommonsZip.$$$reportNull$$$0(0);
            }
            this.mySource = file2;
        }

        @Override
        protected void openStream() throws IOException {
            this.myZip = new ZipFile(this.mySource);
            this.myEntries = this.myZip.getEntries();
        }

        @Override
        protected Entry nextEntry() throws IOException {
            if (!this.myEntries.hasMoreElements()) {
                this.myEntry = null;
                return null;
            }
            this.myEntry = this.myEntries.nextElement();
            if (this.myEntry == null) {
                return null;
            }
            String linkTarget = this.myEntry.isUnixSymlink() ? this.myZip.getUnixSymlink(this.myEntry) : null;
            return new Entry(this.myEntry.getName(), CommonsZip.type(this.myEntry), BitUtil.isSet(this.myEntry.getUnixMode(), 128), BitUtil.isSet(this.myEntry.getUnixMode(), 64), linkTarget);
        }

        private static Type type(ZipArchiveEntry te) {
            return te.isUnixSymlink() ? Type.SYMLINK : (te.isDirectory() ? Type.DIR : Type.FILE);
        }

        @Override
        protected InputStream openEntryStream(Entry entry) throws IOException {
            return this.myZip.getInputStream(this.myEntry);
        }

        @Override
        protected void closeEntryStream(InputStream stream) throws IOException {
            stream.close();
        }

        @Override
        protected void closeStream() throws IOException {
            this.myZip.close();
            this.myZip = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/Decompressor$CommonsZip", "<init>"));
        }
    }

    public static class Zip
    extends Decompressor {
        private final File mySource;
        private java.util.zip.ZipFile myZip;
        private Enumeration<? extends ZipEntry> myEntries;
        private ZipEntry myEntry;

        public Zip(@NotNull File file2) {
            if (file2 == null) {
                Zip.$$$reportNull$$$0(0);
            }
            this.mySource = file2;
        }

        @NotNull
        public Decompressor withUnixPermissionsAndSymlinks() {
            return new CommonsZip(this.mySource);
        }

        @Override
        protected void openStream() throws IOException {
            this.myZip = new java.util.zip.ZipFile(this.mySource);
            this.myEntries = this.myZip.entries();
        }

        @Override
        protected Entry nextEntry() {
            this.myEntry = this.myEntries.hasMoreElements() ? this.myEntries.nextElement() : null;
            return this.myEntry == null ? null : new Entry(this.myEntry.getName(), this.myEntry.isDirectory());
        }

        @Override
        protected InputStream openEntryStream(Entry entry) throws IOException {
            return this.myZip.getInputStream(this.myEntry);
        }

        @Override
        protected void closeEntryStream(InputStream stream) throws IOException {
            stream.close();
        }

        @Override
        protected void closeStream() throws IOException {
            if (this.myZip != null) {
                this.myZip.close();
                this.myZip = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/Decompressor$Zip", "<init>"));
        }
    }

    public static class Tar
    extends Decompressor {
        private final Object mySource;
        private TarArchiveInputStream myStream;
        private boolean symlinks;

        public Tar(@NotNull File file2) {
            if (file2 == null) {
                Tar.$$$reportNull$$$0(0);
            }
            this.mySource = file2;
        }

        public Tar(@NotNull InputStream stream) {
            if (stream == null) {
                Tar.$$$reportNull$$$0(1);
            }
            this.mySource = stream;
        }

        public Tar withSymlinks() {
            this.symlinks = true;
            return this;
        }

        @Override
        protected void openStream() throws IOException {
            BufferedInputStream input;
            block2: {
                input = new BufferedInputStream(this.mySource instanceof File ? new FileInputStream((File)this.mySource) : (InputStream)this.mySource);
                try {
                    input = new CompressorStreamFactory().createCompressorInputStream((InputStream)input);
                }
                catch (CompressorException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof IOException)) break block2;
                    throw (IOException)cause;
                }
            }
            this.myStream = new TarArchiveInputStream((InputStream)input);
        }

        @Override
        protected Entry nextEntry() throws IOException {
            TarArchiveEntry te;
            while (!((te = this.myStream.getNextTarEntry()) == null || te.isFile() || te.isDirectory() || te.isSymbolicLink() && this.symlinks)) {
            }
            return te == null ? null : new Entry(te.getName(), Tar.type(te), BitUtil.isSet(te.getMode(), 128), BitUtil.isSet(te.getMode(), 64), te.getLinkName());
        }

        private static Type type(TarArchiveEntry te) {
            return te.isSymbolicLink() ? Type.SYMLINK : (te.isDirectory() ? Type.DIR : Type.FILE);
        }

        @Override
        protected InputStream openEntryStream(Entry entry) {
            return this.myStream;
        }

        @Override
        protected void closeEntryStream(InputStream stream) {
        }

        @Override
        protected void closeStream() throws IOException {
            if (this.mySource instanceof File) {
                this.myStream.close();
                this.myStream = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/Decompressor$Tar";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

