/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.FileChannelUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

class RandomAccessFileWithLengthAndSizeTracking {
    private static final Logger LOG = Logger.getInstance(RandomAccessFileWithLengthAndSizeTracking.class.getName());
    private static final boolean doAssertions = SystemProperties.getBooleanProperty("idea.do.random.access.wrapper.assertions", false);
    private final Path myPath;
    private final FileChannel myChannel;
    private volatile long mySize;
    private volatile long myPointer;

    RandomAccessFileWithLengthAndSizeTracking(Path path2) throws IOException {
        Path parent = path2.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        this.myChannel = FileChannelUtil.unInterruptible(FileChannel.open(path2, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
        this.mySize = this.myChannel.size();
        this.myPath = path2;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Inst:" + this + "," + Thread.currentThread() + "," + this.getClass().getClassLoader());
        }
    }

    void seek(long pos) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Seek:" + this + "," + Thread.currentThread() + "," + pos + "," + this.myPointer + "," + this.mySize);
        }
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        if (this.myPointer == pos) {
            return;
        }
        this.myChannel.position(pos);
        this.myPointer = pos;
    }

    long length() throws IOException {
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        return this.mySize;
    }

    private void checkSizeAndPointerAssertions() throws IOException {
        assert (this.myPointer == this.myChannel.position());
        assert (this.mySize == this.myChannel.size());
    }

    void write(byte[] b, int off, int len) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("write:" + this + "," + Thread.currentThread() + "," + len + "," + this.myPointer + "," + this.mySize);
        }
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        long pointer = this.myPointer;
        this.myChannel.write(ByteBuffer.wrap(b, off, len));
        pointer = pointer == 0L ? this.myChannel.position() : (pointer += (long)len);
        this.myPointer = pointer;
        this.mySize = Math.max(pointer, this.mySize);
        if (LOG.isTraceEnabled()) {
            LOG.trace("after write:" + this + "," + Thread.currentThread() + "," + this.myPointer + "," + this.mySize);
        }
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
    }

    int read(byte[] b, int off, int len) throws IOException {
        int read2;
        if (LOG.isTraceEnabled()) {
            LOG.trace("read:" + this + "," + Thread.currentThread() + "," + len + "," + this.myPointer);
        }
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        if ((read2 = this.myChannel.read(ByteBuffer.wrap(b, off, len))) != -1) {
            this.myPointer += (long)read2;
        }
        if (doAssertions) {
            this.checkSizeAndPointerAssertions();
        }
        return read2;
    }

    void close() throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Closed:" + this + "," + Thread.currentThread());
        }
        this.force();
        this.myChannel.close();
    }

    public String toString() {
        return this.myPath + "@" + Integer.toHexString(this.hashCode());
    }

    private void force() throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Forcing:" + this + "," + Thread.currentThread());
        }
        this.myChannel.force(true);
    }
}

