/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.FileChannelUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.Nullable;

public class ReadWriteDirectBufferWrapper
extends DirectBufferWrapper {
    private static final Logger LOG = Logger.getInstance(ReadWriteDirectBufferWrapper.class);

    protected ReadWriteDirectBufferWrapper(Path file2, long offset, long length) {
        super(file2, offset, length);
        assert (length <= Integer.MAX_VALUE) : length;
    }

    @Override
    protected ByteBuffer create() throws IOException {
        try (FileContext context = new FileContext(this.myFile);){
            FileChannel channel = context.file;
            assert (channel != null);
            channel.position(this.myPosition);
            ByteBuffer buffer = ByteBuffer.allocateDirect((int)this.myLength);
            channel.read(buffer);
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }

    FileContext flushWithContext(@Nullable FileContext fileContext) {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer != null && this.isDirty()) {
            try {
                if (fileContext == null) {
                    fileContext = new FileContext(this.myFile);
                }
                this.doFlush(fileContext, buffer);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
        return fileContext;
    }

    private void doFlush(FileContext fileContext, ByteBuffer buffer) throws IOException {
        FileChannel channel = fileContext.file;
        assert (channel != null);
        channel.position(this.myPosition);
        buffer.rewind();
        channel.write(buffer);
        this.myDirty = false;
    }

    @Override
    public void flush() {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer != null && this.isDirty()) {
            try (FileContext context = new FileContext(this.myFile);){
                this.doFlush(context, buffer);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    static class FileContext
    implements AutoCloseable {
        final FileChannel file;

        FileContext(final Path path2) throws IOException {
            this.file = FileUtilRt.doIOOperation(new FileUtilRt.RepeatableIOOperation<FileChannel, IOException>(){
                boolean parentWasCreated;

                @Override
                @Nullable
                public FileChannel execute(boolean finalAttempt) throws IOException {
                    try {
                        return FileChannelUtil.unInterruptible(FileChannel.open(path2, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
                    }
                    catch (NoSuchFileException ex) {
                        Path parentFile = path2.getParent();
                        if (!Files.exists(parentFile, new LinkOption[0])) {
                            if (!this.parentWasCreated) {
                                FileUtil.createDirectory(parentFile.toFile());
                                this.parentWasCreated = true;
                            } else {
                                throw new IOException("Parent directory still doesn't exist: " + path2);
                            }
                        }
                        if (!finalAttempt) {
                            return null;
                        }
                        throw ex;
                    }
                }
            });
        }

        @Override
        public void close() {
            try {
                if (this.file != null) {
                    this.file.close();
                }
            }
            catch (IOException ex) {
                LOG.error(ex);
            }
        }
    }
}

