/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PagedFileStorage;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResizeableMappedFile
implements Forceable {
    private static final Logger LOG = Logger.getInstance(ResizeableMappedFile.class);
    private static final boolean truncateOnClose = SystemProperties.getBooleanProperty("idea.resizeable.file.truncate.on.close", false);
    private long myLogicalSize;
    private long myLastWrittenLogicalSize;
    private final PagedFileStorage myStorage;
    private final int myInitialSize;
    static final int DEFAULT_ALLOCATION_ROUND_FACTOR = 4096;
    private int myRoundFactor;

    public ResizeableMappedFile(@NotNull Path file2, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        if (file2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(0);
        }
        this(file2, initialSize, lockContext, pageSize, valuesAreBufferAligned, false);
    }

    public ResizeableMappedFile(@NotNull Path file2, int initialSize, @Nullable PagedFileStorage.StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, boolean nativeBytesOrder) throws IOException {
        if (file2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(1);
        }
        this.myRoundFactor = 4096;
        this.myStorage = new PagedFileStorage(file2, lockContext, pageSize, valuesAreBufferAligned, nativeBytesOrder);
        this.myInitialSize = initialSize;
        this.myLastWrittenLogicalSize = this.myLogicalSize = this.readLength();
    }

    public ResizeableMappedFile(Path file2, int initialSize, PagedFileStorage.StorageLock lock, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        this(file2, initialSize, lock.myDefaultStorageLockContext, pageSize, valuesAreBufferAligned);
    }

    public ResizeableMappedFile(Path file2, int initialSize, PagedFileStorage.StorageLock lock) throws IOException {
        this(file2, initialSize, lock, -1, false);
    }

    public long length() {
        return this.myLogicalSize;
    }

    private long realSize() {
        return this.myStorage.length();
    }

    void ensureSize(long pos) {
        this.myLogicalSize = Math.max(pos, this.myLogicalSize);
        this.expand(pos);
    }

    public void setRoundFactor(int roundFactor) {
        this.myRoundFactor = roundFactor;
    }

    private void expand(long max) {
        long suggestedSize;
        long realSize = this.realSize();
        if (max <= realSize) {
            return;
        }
        if (realSize == 0L) {
            suggestedSize = this.doRoundToFactor(Math.max((long)this.myInitialSize, max));
        } else {
            suggestedSize = Math.max(realSize + 1L, 2L);
            while (max > suggestedSize) {
                long newSuggestedSize = suggestedSize * 13L >> 3;
                if (newSuggestedSize >= Integer.MAX_VALUE) {
                    suggestedSize += suggestedSize / 5L;
                    continue;
                }
                suggestedSize = newSuggestedSize;
            }
            suggestedSize = this.doRoundToFactor(suggestedSize);
        }
        try {
            this.myStorage.resize(suggestedSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long doRoundToFactor(long suggestedSize) {
        int roundFactor = this.myRoundFactor;
        if (suggestedSize % (long)roundFactor != 0L) {
            suggestedSize = (suggestedSize / (long)roundFactor + 1L) * (long)roundFactor;
        }
        return suggestedSize;
    }

    private Path getLengthFile() {
        Path file2 = this.myStorage.getFile();
        return file2.resolveSibling(file2.getFileName() + ".len");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLength(long len) {
        final Path lengthFile = this.getLengthFile();
        FilterOutputStream stream = null;
        try {
            stream = FileUtilRt.doIOOperation(new FileUtilRt.RepeatableIOOperation<DataOutputStream, IOException>(){
                boolean parentWasCreated;

                @Override
                @Nullable
                public DataOutputStream execute(boolean lastAttempt) throws IOException {
                    try {
                        return new DataOutputStream(Files.newOutputStream(lengthFile, new OpenOption[0]));
                    }
                    catch (NoSuchFileException ex) {
                        Path parent = lengthFile.getParent();
                        if (!Files.exists(parent, new LinkOption[0])) {
                            if (!this.parentWasCreated) {
                                Files.createDirectories(parent, new FileAttribute[0]);
                                this.parentWasCreated = true;
                            } else {
                                throw new IOException("Parent file still doesn't exist:" + lengthFile);
                            }
                        }
                        if (!lastAttempt) {
                            return null;
                        }
                        throw ex;
                    }
                }
            });
            if (stream != null) {
                ((java.io.DataOutputStream)stream).writeLong(len);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.myStorage.isDirty();
    }

    @Override
    public void force() {
        if (this.isDirty() && this.myLastWrittenLogicalSize != this.myLogicalSize) {
            this.writeLength(this.myLogicalSize);
            this.myLastWrittenLogicalSize = this.myLogicalSize;
        }
        this.myStorage.force();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readLength() {
        Path lengthFile = this.getLengthFile();
        FilterInputStream stream = null;
        if (!Files.exists(lengthFile, new LinkOption[0])) {
            return 0L;
        }
        try {
            stream = new DataInputStream(Files.newInputStream(lengthFile, StandardOpenOption.READ));
            long l = ((DataInputStream)stream).readLong();
            return l;
        }
        catch (IOException e) {
            long realSize = this.realSize();
            this.writeLength(realSize);
            long l = realSize;
            return l;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
    }

    public int getInt(long index) {
        return this.myStorage.getInt(index);
    }

    public void putInt(long index, int value2) {
        this.ensureSize(index + 4L);
        this.myStorage.putInt(index, value2);
    }

    public short getShort(long index) {
        return this.myStorage.getShort(index);
    }

    public void putShort(long index, short value2) {
        this.ensureSize(index + 2L);
        this.myStorage.putShort(index, value2);
    }

    public long getLong(long index) {
        return this.myStorage.getLong(index);
    }

    public void putLong(long index, long value2) {
        this.ensureSize(index + 8L);
        this.myStorage.putLong(index, value2);
    }

    public byte get(long index) {
        return this.myStorage.get(index);
    }

    public void put(long index, byte value2) {
        this.ensureSize(index + 1L);
        this.myStorage.put(index, value2);
    }

    public void get(long index, byte[] dst, int offset, int length) {
        this.myStorage.get(index, dst, offset, length);
    }

    public void put(long index, byte[] src, int offset, int length) {
        this.ensureSize(index + (long)length);
        this.myStorage.put(index, src, offset, length);
    }

    public void close() {
        try {
            this.force();
            if (truncateOnClose && this.myLogicalSize < this.myStorage.length()) {
                this.myStorage.resize(this.myLogicalSize);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.myStorage.close();
        }
    }

    @NotNull
    public PagedFileStorage getPagedFileStorage() {
        PagedFileStorage pagedFileStorage = this.myStorage;
        if (pagedFileStorage == null) {
            ResizeableMappedFile.$$$reportNull$$$0(2);
        }
        return pagedFileStorage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/ResizeableMappedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/ResizeableMappedFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPagedFileStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

