/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class URLUtil {
    public static final String SCHEME_SEPARATOR = "://";
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JRT_PROTOCOL = "jrt";
    public static final String JAR_SEPARATOR = "!/";
    public static final Pattern DATA_URI_PATTERN = Pattern.compile("data:([^,;]+/[^,;]+)(;charset(?:=|:)[^,;]+)?(;base64)?,(.+)");
    public static final Pattern URL_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    public static final Pattern URL_WITH_PARENS_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;()]*[-A-Za-z0-9+$&@#/%=~_|()]");
    public static final Pattern FILE_URL_PATTERN = Pattern.compile("\\b(file:///)[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    public static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");

    private URLUtil() {
    }

    public static boolean canContainUrl(@NotNull String line) {
        if (line == null) {
            URLUtil.$$$reportNull$$$0(0);
        }
        return line.contains("mailto:") || line.contains(SCHEME_SEPARATOR) || line.contains("www.");
    }

    @NotNull
    public static InputStream openStream(@NotNull URL url) throws IOException {
        String protocol;
        if (url == null) {
            URLUtil.$$$reportNull$$$0(1);
        }
        InputStream inputStream = (protocol = url.getProtocol()).equals(JAR_PROTOCOL) ? URLUtil.openJarStream(url) : url.openStream();
        if (inputStream == null) {
            URLUtil.$$$reportNull$$$0(2);
        }
        return inputStream;
    }

    @NotNull
    public static InputStream openResourceStream(@NotNull URL url) throws IOException {
        if (url == null) {
            URLUtil.$$$reportNull$$$0(3);
        }
        try {
            return URLUtil.openStream(url);
        }
        catch (FileNotFoundException ex) {
            InputStream resourceStream;
            int pos;
            String protocol = url.getProtocol();
            String file2 = null;
            if (protocol.equals(FILE_PROTOCOL)) {
                file2 = url.getFile();
            } else if (protocol.equals(JAR_PROTOCOL) && (pos = url.getFile().indexOf("!")) >= 0) {
                file2 = url.getFile().substring(pos + 1);
            }
            if (file2 != null && file2.startsWith("/") && (resourceStream = URLUtil.class.getResourceAsStream(file2)) != null) {
                InputStream inputStream = resourceStream;
                if (inputStream == null) {
                    URLUtil.$$$reportNull$$$0(4);
                }
                return inputStream;
            }
            throw ex;
        }
    }

    @NotNull
    private static InputStream openJarStream(@NotNull URL url) throws IOException {
        Pair<String, String> paths;
        if (url == null) {
            URLUtil.$$$reportNull$$$0(5);
        }
        if ((paths = URLUtil.splitJarUrl(url.getFile())) == null) {
            throw new MalformedURLException(url.getFile());
        }
        final ZipFile zipFile = new ZipFile((String)paths.first);
        ZipEntry zipEntry = zipFile.getEntry((String)paths.second);
        if (zipEntry == null) {
            zipFile.close();
            throw new FileNotFoundException("Entry " + (String)paths.second + " not found in " + (String)paths.first);
        }
        return new FilterInputStream(zipFile.getInputStream(zipEntry)){

            @Override
            public void close() throws IOException {
                super.close();
                zipFile.close();
            }
        };
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static ThreeState resourceExists(@NotNull URL url) {
        block26: {
            ThreeState threeState;
            Throwable throwable;
            ZipFile file2;
            block24: {
                block25: {
                    if (url == null) {
                        URLUtil.$$$reportNull$$$0(6);
                    }
                    if (url.getProtocol().equals(FILE_PROTOCOL)) {
                        ThreeState threeState2 = ThreeState.fromBoolean(URLUtil.urlToFile(url).exists());
                        if (threeState2 == null) {
                            URLUtil.$$$reportNull$$$0(7);
                        }
                        return threeState2;
                    }
                    if (!url.getProtocol().equals(JAR_PROTOCOL)) break block26;
                    Pair<String, String> paths = URLUtil.splitJarUrl(url.getFile());
                    if (paths == null) {
                        ThreeState threeState3 = ThreeState.NO;
                        if (threeState3 == null) {
                            URLUtil.$$$reportNull$$$0(8);
                        }
                        return threeState3;
                    }
                    if (!new File((String)paths.first).isFile()) {
                        ThreeState threeState4 = ThreeState.NO;
                        if (threeState4 == null) {
                            URLUtil.$$$reportNull$$$0(9);
                        }
                        return threeState4;
                    }
                    file2 = new ZipFile((String)paths.first);
                    throwable = null;
                    threeState = ThreeState.fromBoolean(file2.getEntry((String)paths.second) != null);
                    if (file2 == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        file2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block24;
                }
                file2.close();
            }
            ThreeState threeState5 = threeState;
            if (threeState5 == null) {
                URLUtil.$$$reportNull$$$0(10);
            }
            return threeState5;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (file2 != null) {
                                if (throwable != null) {
                                    try {
                                        file2.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    file2.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        ThreeState threeState6 = ThreeState.NO;
                        if (threeState6 == null) {
                            URLUtil.$$$reportNull$$$0(11);
                        }
                        return threeState6;
                    }
                }
            }
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            URLUtil.$$$reportNull$$$0(12);
        }
        return threeState;
    }

    @Nullable
    public static Pair<String, String> splitJarUrl(@NotNull String url) {
        String jarPath;
        String resourcePath;
        block7: {
            int pivot;
            if (url == null) {
                URLUtil.$$$reportNull$$$0(13);
            }
            if ((pivot = url.indexOf(JAR_SEPARATOR)) < 0) {
                return null;
            }
            resourcePath = url.substring(pivot + 2);
            jarPath = url.substring(0, pivot);
            if (StringUtil.startsWithConcatenation(jarPath, JAR_PROTOCOL, ":")) {
                jarPath = jarPath.substring(JAR_PROTOCOL.length() + 1);
            }
            if (jarPath.startsWith(FILE_PROTOCOL)) {
                try {
                    jarPath = URLUtil.urlToFile(new URL(jarPath)).getPath().replace('\\', '/');
                }
                catch (Exception e) {
                    jarPath = jarPath.substring(FILE_PROTOCOL.length());
                    if (jarPath.startsWith(SCHEME_SEPARATOR)) {
                        jarPath = jarPath.substring(SCHEME_SEPARATOR.length());
                    }
                    if (!StringUtil.startsWithChar(jarPath, ':')) break block7;
                    jarPath = jarPath.substring(1);
                }
            }
        }
        return Pair.create(jarPath, resourcePath);
    }

    @NotNull
    public static File urlToFile(@NotNull URL url) {
        if (url == null) {
            URLUtil.$$$reportNull$$$0(14);
        }
        try {
            return new File(url.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL='" + url.toString() + "'", e);
        }
    }

    @NotNull
    public static String unescapePercentSequences(@NotNull String s) {
        if (s == null) {
            URLUtil.$$$reportNull$$$0(15);
        }
        String string = URLUtil.unescapePercentSequences(s, 0, s.length()).toString();
        if (string == null) {
            URLUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static CharSequence unescapePercentSequences(@NotNull CharSequence s, int from, int end) {
        int i;
        if (s == null) {
            URLUtil.$$$reportNull$$$0(17);
        }
        if ((i = StringUtil.indexOf(s, '%', from, end)) == -1) {
            CharSequence charSequence = s.subSequence(from, end);
            if (charSequence == null) {
                URLUtil.$$$reportNull$$$0(18);
            }
            return charSequence;
        }
        StringBuilder decoded = new StringBuilder();
        decoded.append(s, from, i);
        TIntArrayList bytes = null;
        while (i < end) {
            char c = s.charAt(i);
            if (c == '%') {
                if (bytes == null) {
                    bytes = new TIntArrayList();
                } else {
                    bytes.clear();
                }
                while (i + 2 < end && s.charAt(i) == '%') {
                    int d1 = URLUtil.decode(s.charAt(i + 1));
                    int d2 = URLUtil.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    bytes.add((d1 & 0xF) << 4 | d2 & 0xF);
                    i += 3;
                }
                if (!bytes.isEmpty()) {
                    byte[] bytesArray = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        bytesArray[j] = (byte)bytes.getQuick(j);
                    }
                    decoded.append(new String(bytesArray, StandardCharsets.UTF_8));
                    continue;
                }
            }
            decoded.append(c);
            ++i;
        }
        StringBuilder stringBuilder = decoded;
        if (stringBuilder == null) {
            URLUtil.$$$reportNull$$$0(19);
        }
        return stringBuilder;
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public static boolean containsScheme(@NotNull String url) {
        if (url == null) {
            URLUtil.$$$reportNull$$$0(20);
        }
        return url.contains(SCHEME_SEPARATOR);
    }

    public static boolean isDataUri(@NotNull String value2) {
        if (value2 == null) {
            URLUtil.$$$reportNull$$$0(21);
        }
        return !value2.isEmpty() && value2.startsWith("data:", value2.charAt(0) == '\"' || value2.charAt(0) == '\'' ? 1 : 0);
    }

    public static byte @Nullable [] getBytesFromDataUri(@NotNull String dataUrl) {
        Matcher matcher;
        if (dataUrl == null) {
            URLUtil.$$$reportNull$$$0(22);
        }
        if ((matcher = DATA_URI_PATTERN.matcher(StringUtil.unquoteString(dataUrl))).matches()) {
            try {
                String content2 = matcher.group(4);
                return ";base64".equalsIgnoreCase(matcher.group(3)) ? Base64.getDecoder().decode(content2) : URLUtil.decode(content2).getBytes(StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    @NotNull
    public static String decode(@NotNull String string) {
        String string2;
        if (string == null) {
            URLUtil.$$$reportNull$$$0(23);
        }
        try {
            string2 = URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ignore) {
            String string3 = URLDecoder.decode(string);
            if (string3 == null) {
                URLUtil.$$$reportNull$$$0(25);
            }
            return string3;
        }
        if (string2 == null) {
            URLUtil.$$$reportNull$$$0(24);
        }
        return string2;
    }

    @NotNull
    public static String parseHostFromSshUrl(@NotNull String sshUrl) {
        String host;
        int at;
        if (sshUrl == null) {
            URLUtil.$$$reportNull$$$0(26);
        }
        if ((at = (host = sshUrl).lastIndexOf(64)) > 0) {
            host = host.substring(at + 1);
        } else {
            int firstColon = host.indexOf(58);
            if (firstColon > 0) {
                host = host.substring(firstColon + 3);
            }
        }
        int colon = host.indexOf(58);
        if (colon > 0) {
            host = host.substring(0, colon);
        } else {
            int slash = host.indexOf(47);
            if (slash > 0) {
                host = host.substring(0, slash);
            }
        }
        String string = host;
        if (string == null) {
            URLUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static URL getJarEntryURL(@NotNull File file2, @NotNull String pathInJar) throws MalformedURLException {
        if (file2 == null) {
            URLUtil.$$$reportNull$$$0(28);
        }
        if (pathInJar == null) {
            URLUtil.$$$reportNull$$$0(29);
        }
        return URLUtil.getJarEntryURL(file2.toURI(), pathInJar);
    }

    @NotNull
    public static URL getJarEntryURL(@NotNull URI file2, @NotNull String pathInJar) throws MalformedURLException {
        if (file2 == null) {
            URLUtil.$$$reportNull$$$0(30);
        }
        if (pathInJar == null) {
            URLUtil.$$$reportNull$$$0(31);
        }
        String fileURL = StringUtil.replace(file2.toASCIIString(), "!", "%21");
        return new URL("jar:" + fileURL + JAR_SEPARATOR + StringUtil.trimLeading(pathInJar, '/'));
    }

    @NotNull
    public static URI getJarEntryUri(@NotNull URI file2, @NotNull String pathInJar) throws URISyntaxException {
        if (file2 == null) {
            URLUtil.$$$reportNull$$$0(32);
        }
        if (pathInJar == null) {
            URLUtil.$$$reportNull$$$0(33);
        }
        String fileURL = StringUtil.replace(file2.toASCIIString(), "!", "%21");
        return new URI("jar:" + fileURL + JAR_SEPARATOR + StringUtil.trimLeading(pathInJar, '/'));
    }

    @NotNull
    public static String encodeURIComponent(@NotNull String s) {
        String string;
        if (s == null) {
            URLUtil.$$$reportNull$$$0(34);
        }
        try {
            string = URLEncoder.encode(s, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            String string2 = s;
            if (string2 == null) {
                URLUtil.$$$reportNull$$$0(36);
            }
            return string2;
        }
        if (string == null) {
            URLUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @Nullable
    public static TextRange findUrl(@NotNull CharSequence text2, int startOffset, int endOffset) {
        if (text2 == null) {
            URLUtil.$$$reportNull$$$0(37);
        }
        Matcher m = URL_WITH_PARENS_PATTERN.matcher(text2);
        m.region(startOffset, endOffset);
        if (!m.find()) {
            return null;
        }
        int start2 = m.start();
        int end = m.end();
        int unmatchedPos = 0;
        int unmatchedCount = 0;
        for (int i = m.end(1); i < end; ++i) {
            char c = text2.charAt(i);
            if (c == '(') {
                if (unmatchedCount++ != 0) continue;
                unmatchedPos = i;
                continue;
            }
            if (c != ')' || unmatchedCount-- != 0) continue;
            return new TextRange(start2, i);
        }
        if (unmatchedCount > 0) {
            return new TextRange(start2, unmatchedPos);
        }
        return new TextRange(start2, end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/URLUtil";
                break;
            }
            case 15: 
            case 17: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataUrl";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshUrl";
                break;
            }
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_PROTOCOL;
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/URLUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "openStream";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "openResourceStream";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resourceExists";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapePercentSequences";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHostFromSshUrl";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeURIComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canContainUrl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openStream";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 35: 
            case 36: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openResourceStream";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openJarStream";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resourceExists";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "splitJarUrl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "urlToFile";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unescapePercentSequences";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDataUri";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getBytesFromDataUri";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseHostFromSshUrl";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getJarEntryURL";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getJarEntryUri";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "encodeURIComponent";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

