/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipUtil {
    private static final Logger LOG = Logger.getInstance(ZipUtil.class);

    private ZipUtil() {
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file2, @NotNull String relativeName, @Nullable Set<? super String> writtenItemRelativePaths, @Nullable FileFilter fileFilter) throws IOException {
        if (zos == null) {
            ZipUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(1);
        }
        if (relativeName == null) {
            ZipUtil.$$$reportNull$$$0(2);
        }
        return ZipUtil.addFileToZip(zos, file2, relativeName, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD, file2.isDirectory());
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file2, @NotNull String relativeName, @Nullable Set<? super String> writtenItemRelativePaths, @Nullable FileFilter fileFilter, @NotNull FileContentProcessor contentProcessor, boolean isDir) throws IOException {
        if (zos == null) {
            ZipUtil.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(4);
        }
        if (relativeName == null) {
            ZipUtil.$$$reportNull$$$0(5);
        }
        if (contentProcessor == null) {
            ZipUtil.$$$reportNull$$$0(6);
        }
        while (!relativeName.isEmpty() && relativeName.charAt(0) == '/') {
            relativeName = relativeName.substring(1);
        }
        if (isDir && !StringUtil.endsWithChar(relativeName, '/')) {
            relativeName = relativeName + "/";
        }
        if (fileFilter != null && !FileUtil.isFilePathAcceptable(file2, fileFilter)) {
            return false;
        }
        if (writtenItemRelativePaths != null && !writtenItemRelativePaths.add(relativeName)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add " + file2 + " as " + relativeName);
        }
        long size = isDir ? 0L : file2.length();
        ZipEntry e = new ZipEntry(relativeName);
        e.setTime(file2.lastModified());
        if (size == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        zos.putNextEntry(e);
        if (!isDir) {
            try (InputStream is = contentProcessor.getContent(file2);){
                FileUtilRt.copy(is, zos);
            }
        }
        zos.closeEntry();
        return true;
    }

    public static boolean addFileOrDirRecursively(@NotNull ZipOutputStream jarOutputStream, @Nullable File jarFile, @NotNull File file2, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        if (jarOutputStream == null) {
            ZipUtil.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(8);
        }
        if (relativePath == null) {
            ZipUtil.$$$reportNull$$$0(9);
        }
        if (file2.isDirectory()) {
            return ZipUtil.addDirToZipRecursively(jarOutputStream, jarFile, file2, relativePath, fileFilter, writtenItemRelativePaths);
        }
        return ZipUtil.addFileToZip(jarOutputStream, file2, relativePath, writtenItemRelativePaths, fileFilter);
    }

    public static boolean addDirToZipRecursively(@NotNull ZipOutputStream outputStream, @Nullable File jarFile, @NotNull File dir, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        File[] children2;
        if (outputStream == null) {
            ZipUtil.$$$reportNull$$$0(10);
        }
        if (dir == null) {
            ZipUtil.$$$reportNull$$$0(11);
        }
        if (relativePath == null) {
            ZipUtil.$$$reportNull$$$0(12);
        }
        if (jarFile != null && FileUtil.isAncestor(dir, jarFile, false)) {
            return false;
        }
        if (!relativePath.isEmpty()) {
            ZipUtil.addFileToZip(outputStream, dir, relativePath, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD, true);
        }
        if ((children2 = dir.listFiles()) != null) {
            for (File child2 : children2) {
                String childRelativePath = (relativePath.isEmpty() ? "" : relativePath + "/") + child2.getName();
                ZipUtil.addFileOrDirRecursively(outputStream, jarFile, child2, childRelativePath, fileFilter, writtenItemRelativePaths);
            }
        }
        return true;
    }

    public static void extract(@NotNull File file2, @NotNull File outputDir, @Nullable FilenameFilter filter2) throws IOException {
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(13);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(14);
        }
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir, filter2)).extract(outputDir);
    }

    public static void extract(@NotNull File file2, @NotNull File outputDir, @Nullable FilenameFilter filter2, boolean overwrite) throws IOException {
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(15);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(16);
        }
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir, filter2)).overwrite(overwrite).extract(outputDir);
    }

    public static boolean isZipContainsFolder(File zip) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                if (zipEntry.getName().indexOf(47) < 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void compressFile(@NotNull File srcFile, @NotNull File zipFile) throws IOException {
        if (srcFile == null) {
            ZipUtil.$$$reportNull$$$0(17);
        }
        if (zipFile == null) {
            ZipUtil.$$$reportNull$$$0(18);
        }
        try (FileInputStream is = new FileInputStream(srcFile);
             ZipOutputStream os = new ZipOutputStream(new FileOutputStream(zipFile));){
            os.putNextEntry(new ZipEntry(srcFile.getName()));
            FileUtilRt.copy(is, os);
            os.closeEntry();
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static void extract(@NotNull ZipFile zip, @NotNull File outputDir, @Nullable FilenameFilter filter2) throws IOException {
        if (zip == null) {
            ZipUtil.$$$reportNull$$$0(19);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(20);
        }
        new Decompressor.Zip(new File(zip.getName())).filter(FileFilterAdapter.wrap(outputDir, filter2)).extract(outputDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static void extractEntry(@NotNull ZipEntry entry, @NotNull InputStream inputStream, @NotNull File outputDir, boolean overwrite) throws IOException {
        block19: {
            if (entry == null) {
                ZipUtil.$$$reportNull$$$0(21);
            }
            if (inputStream == null) {
                ZipUtil.$$$reportNull$$$0(22);
            }
            if (outputDir == null) {
                ZipUtil.$$$reportNull$$$0(23);
            }
            File outputFile = Decompressor.entryFile(outputDir, entry.getName());
            try {
                if (entry.isDirectory()) {
                    FileUtil.createDirectory(outputFile);
                    break block19;
                }
                if (outputFile.exists() && !overwrite) break block19;
                FileUtil.createParentDirs(outputFile);
                try (FileOutputStream os = new FileOutputStream(outputFile);){
                    FileUtilRt.copy(inputStream, os);
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zos";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarOutputStream";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/ZipUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileToZip";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileOrDirRecursively";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addDirToZipRecursively";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "extract";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "compressFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "extractEntry";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FileFilterAdapter
    implements Condition<String> {
        private final File myOutputDir;
        private final FilenameFilter myFilter;

        private static FileFilterAdapter wrap(File outputDir, @Nullable FilenameFilter filter2) {
            return filter2 == null ? null : new FileFilterAdapter(outputDir, filter2);
        }

        private FileFilterAdapter(File outputDir, FilenameFilter filter2) {
            this.myOutputDir = outputDir;
            this.myFilter = filter2;
        }

        @Override
        public boolean value(String entryName) {
            File outputFile = new File(this.myOutputDir, entryName);
            return this.myFilter.accept(outputFile.getParentFile(), outputFile.getName());
        }
    }

    public static interface FileContentProcessor {
        public static final FileContentProcessor STANDARD = new FileContentProcessor(){

            @Override
            public InputStream getContent(@NotNull File file2) throws IOException {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new FileInputStream(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/ZipUtil$FileContentProcessor$1", "getContent"));
            }
        };

        public InputStream getContent(@NotNull File var1) throws IOException;
    }
}

