/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.RandomAccessDataFile;
import com.intellij.util.io.storage.RecordIdIterator;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public abstract class AbstractRecordsTable
implements Disposable,
Forceable {
    private static final Logger LOG = Logger.getInstance(AbstractRecordsTable.class);
    private static final int HEADER_MAGIC_OFFSET = 0;
    private static final int HEADER_VERSION_OFFSET = 4;
    protected static final int DEFAULT_HEADER_SIZE = 8;
    private static final int VERSION = 5;
    private static final int DIRTY_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190100;
    private static final int ADDRESS_OFFSET = 0;
    private static final int SIZE_OFFSET = 8;
    private static final int CAPACITY_OFFSET = 12;
    protected static final int DEFAULT_RECORD_SIZE = 16;
    protected final RandomAccessDataFile myStorage;
    private TIntArrayList myFreeRecordsList = null;
    private boolean myIsDirty = false;
    protected static final int SPECIAL_NEGATIVE_SIZE_FOR_REMOVED_RECORD = -1;

    public AbstractRecordsTable(File storageFilePath, PagePool pool) throws IOException {
        this.myStorage = new RandomAccessDataFile(storageFilePath, pool);
        if (this.myStorage.length() == 0L) {
            this.myStorage.put(0L, new byte[this.getHeaderSize()], 0, this.getHeaderSize());
            this.markDirty();
        } else if (this.myStorage.getInt(0L) != this.getSafelyClosedMagic()) {
            this.myStorage.dispose();
            throw new IOException("Records table for '" + storageFilePath + "' haven't been closed correctly. Rebuild required.");
        }
    }

    private int getSafelyClosedMagic() {
        return 523190100 + this.getImplVersion();
    }

    protected int getHeaderSize() {
        return 8;
    }

    protected abstract int getImplVersion();

    protected abstract int getRecordSize();

    protected abstract byte[] getZeros();

    public int createNewRecord() throws IOException {
        this.markDirty();
        this.ensureFreeRecordsScanned();
        if (this.myFreeRecordsList.isEmpty()) {
            int result2 = this.getRecordsCount() + 1;
            this.doCleanRecord(result2);
            if (this.getRecordsCount() != result2) {
                LOG.error("Failed to correctly allocate new record in: " + this.myStorage.getFile());
            }
            return result2;
        }
        int result3 = this.myFreeRecordsList.remove(this.myFreeRecordsList.size() - 1);
        assert (AbstractRecordsTable.isSizeOfRemovedRecord(this.getSize(result3)));
        this.setSize(result3, 0);
        return result3;
    }

    public int getRecordsCount() throws IOException {
        int recordsLength = (int)this.myStorage.length() - this.getHeaderSize();
        if (recordsLength % this.getRecordSize() != 0) {
            throw new IOException(MessageFormat.format("Corrupted records: storageLength={0} recordsLength={1} recordSize={2}", this.myStorage.length(), recordsLength, this.getRecordSize()));
        }
        return recordsLength / this.getRecordSize();
    }

    public RecordIdIterator createRecordIdIterator() throws IOException {
        return new RecordIdIterator(){
            private final int count;
            private int recordId;
            {
                this.count = AbstractRecordsTable.this.getRecordsCount();
                this.recordId = 1;
            }

            @Override
            public boolean hasNextId() {
                return this.recordId <= this.count;
            }

            @Override
            public int nextId() {
                assert (this.hasNextId());
                return this.recordId++;
            }

            @Override
            public boolean validId() {
                assert (this.hasNextId());
                return AbstractRecordsTable.isSizeOfLiveRecord(AbstractRecordsTable.this.getSize(this.recordId));
            }
        };
    }

    public int getLiveRecordsCount() throws IOException {
        this.ensureFreeRecordsScanned();
        return this.getRecordsCount() - this.myFreeRecordsList.size();
    }

    private void ensureFreeRecordsScanned() throws IOException {
        if (this.myFreeRecordsList == null) {
            this.myFreeRecordsList = this.scanForFreeRecords();
        }
    }

    private TIntArrayList scanForFreeRecords() throws IOException {
        TIntArrayList result2 = new TIntArrayList();
        for (int i = 1; i <= this.getRecordsCount(); ++i) {
            if (!AbstractRecordsTable.isSizeOfRemovedRecord(this.getSize(i))) continue;
            result2.add(i);
        }
        return result2;
    }

    private void doCleanRecord(int record) {
        this.myStorage.put(this.getOffset(record, 0), this.getZeros(), 0, this.getRecordSize());
    }

    public long getAddress(int record) {
        return this.myStorage.getLong(this.getOffset(record, 0));
    }

    public void setAddress(int record, long address) {
        this.markDirty();
        this.myStorage.putLong(this.getOffset(record, 0), address);
    }

    public int getSize(int record) {
        return this.myStorage.getInt(this.getOffset(record, 8));
    }

    public void setSize(int record, int size) {
        this.markDirty();
        this.myStorage.putInt(this.getOffset(record, 8), size);
    }

    public int getCapacity(int record) {
        return this.myStorage.getInt(this.getOffset(record, 12));
    }

    public void setCapacity(int record, int capacity) {
        this.markDirty();
        this.myStorage.putInt(this.getOffset(record, 12), capacity);
    }

    protected int getOffset(int record, int section) {
        assert (record > 0);
        return this.getHeaderSize() + (record - 1) * this.getRecordSize() + section;
    }

    public void deleteRecord(int record) throws IOException {
        this.markDirty();
        this.ensureFreeRecordsScanned();
        this.doCleanRecord(record);
        this.setSize(record, -1);
        this.myFreeRecordsList.add(record);
    }

    public int getVersion() {
        return this.myStorage.getInt(4L);
    }

    public void setVersion(int expectedVersion) {
        this.markDirty();
        this.myStorage.putInt(4L, expectedVersion);
    }

    @Override
    public void dispose() {
        if (!this.myStorage.isDisposed()) {
            this.markClean();
            this.myStorage.dispose();
        }
    }

    @Override
    public void force() {
        this.markClean();
        this.myStorage.force();
    }

    public boolean flushSome(int maxPages) {
        this.myStorage.flushSomePages(maxPages);
        if (!this.myStorage.isDirty()) {
            this.force();
            return true;
        }
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.myIsDirty || this.myStorage.isDirty();
    }

    public void markDirty() {
        if (!this.myIsDirty) {
            this.myIsDirty = true;
            this.myStorage.putInt(0L, 313341156);
        }
    }

    private void markClean() {
        if (this.myIsDirty) {
            this.myIsDirty = false;
            this.myStorage.putInt(0L, this.getSafelyClosedMagic());
        }
    }

    protected static boolean isSizeOfRemovedRecord(int length) {
        return length == -1;
    }

    protected static boolean isSizeOfLiveRecord(int length) {
        return length != -1;
    }
}

