/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.zip.DosTime;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipOutputStream;
import com.intellij.util.io.zip.ZipLong;
import com.intellij.util.io.zip.ZipShort;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.jetbrains.annotations.NotNull;

public class JBZipFile
implements Closeable {
    static final int SHORT = 2;
    static final int WORD = 4;
    private static final int HASH_SIZE = 509;
    private static final int NIBLET_MASK = 15;
    private static final int BYTE_SHIFT = 8;
    private final List<JBZipEntry> entries;
    private final Map<String, JBZipEntry> nameMap;
    private final Charset encoding;
    final RandomAccessFile archive;
    private JBZipOutputStream myOutputStream;
    private long currentCfdOffset;
    private static final int CFH_LEN = 42;
    private static final int MIN_EOCD_SIZE = 22;
    private static final int CFD_LOCATOR_OFFSET = 16;
    static final long LFH_OFFSET_FOR_CRC = 14L;
    static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;

    public JBZipFile(File f) throws IOException {
        this(f, StandardCharsets.UTF_8);
    }

    public JBZipFile(String name) throws IOException {
        this(new File(name), StandardCharsets.UTF_8);
    }

    public JBZipFile(String name, @NotNull String encoding) throws IOException {
        if (encoding == null) {
            JBZipFile.$$$reportNull$$$0(0);
        }
        this(new File(name), encoding);
    }

    public JBZipFile(File f, @NotNull String encoding) throws IOException {
        if (encoding == null) {
            JBZipFile.$$$reportNull$$$0(1);
        }
        this(f, Charset.forName(encoding));
    }

    public JBZipFile(File f, @NotNull Charset encoding) throws IOException {
        if (encoding == null) {
            JBZipFile.$$$reportNull$$$0(2);
        }
        this.entries = new ArrayList<JBZipEntry>(509);
        this.nameMap = new HashMap<String, JBZipEntry>(509);
        this.encoding = encoding;
        this.archive = new RandomAccessFile(f, "rw");
        try {
            if (this.archive.length() > 0L) {
                this.populateFromCentralDirectory();
            } else {
                this.getOutputStream();
            }
        }
        catch (IOException e) {
            try {
                this.archive.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public void close() throws IOException {
        if (this.myOutputStream != null) {
            if (this.entries.isEmpty()) {
                JBZipEntry empty = this.getOrCreateEntry("/empty.file.marker");
                this.myOutputStream.putNextEntryBytes(empty, "empty".getBytes(CharsetToolkit.US_ASCII_CHARSET));
            }
            this.myOutputStream.finish();
            this.archive.setLength(this.myOutputStream.getWritten());
        }
        this.archive.close();
    }

    public List<JBZipEntry> getEntries() {
        return this.entries;
    }

    public JBZipEntry getEntry(String name) {
        return this.nameMap.get(name);
    }

    public JBZipEntry getOrCreateEntry(String name) {
        JBZipEntry entry = this.nameMap.get(name);
        if (entry != null) {
            return entry;
        }
        entry = new JBZipEntry(name, this);
        this.nameMap.put(name, entry);
        this.entries.add(entry);
        return entry;
    }

    private void populateFromCentralDirectory() throws IOException {
        this.positionAtCentralDirectory();
        byte[] cfh = new byte[42];
        byte[] signatureBytes = new byte[4];
        this.archive.readFully(signatureBytes);
        long sig = ZipLong.getValue(signatureBytes);
        long cfhSig = ZipLong.getValue(JBZipOutputStream.CFH_SIG);
        while (sig == cfhSig) {
            this.archive.readFully(cfh);
            int off = 0;
            int versionMadeBy = ZipShort.getValue(cfh, off);
            off += 2;
            int platform = versionMadeBy >> 8 & 0xF;
            int method2 = ZipShort.getValue(cfh, off += 4);
            long time = DosTime.dosToJavaTime(ZipLong.getValue(cfh, off += 2));
            long crc = ZipLong.getValue(cfh, off += 4);
            long compressedSize = ZipLong.getValue(cfh, off += 4);
            long uncompressedSize = ZipLong.getValue(cfh, off += 4);
            int fileNameLen = ZipShort.getValue(cfh, off += 4);
            int extraLen = ZipShort.getValue(cfh, off += 2);
            int commentLen = ZipShort.getValue(cfh, off += 2);
            off += 2;
            int internalAttributes = ZipShort.getValue(cfh, off += 2);
            long externalAttributes = ZipLong.getValue(cfh, off += 2);
            long localHeaderOffset = ZipLong.getValue(cfh, off += 4);
            String name = this.getString(this.readBytes(fileNameLen));
            byte[] extra = this.readBytes(extraLen);
            String comment = this.getString(this.readBytes(commentLen));
            JBZipEntry ze = new JBZipEntry(this);
            ze.setName(name);
            ze.setHeaderOffset(localHeaderOffset);
            ze.setPlatform(platform);
            ze.setMethod(method2);
            ze.setTime(time);
            ze.setCrc(crc);
            ze.setCompressedSize(compressedSize);
            ze.setSize(uncompressedSize);
            ze.setInternalAttributes(internalAttributes);
            ze.setExternalAttributes(externalAttributes);
            ze.setExtra(extra);
            try {
                ze.setComment(comment);
            }
            catch (IllegalArgumentException e) {
                ze.setComment(comment.substring(0, 21845));
            }
            this.nameMap.put(ze.getName(), ze);
            this.entries.add(ze);
            this.archive.readFully(signatureBytes);
            sig = ZipLong.getValue(signatureBytes);
        }
    }

    private byte[] readBytes(int count) throws IOException {
        if (count > 0) {
            byte[] bytes = new byte[count];
            this.archive.readFully(bytes);
            return bytes;
        }
        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
    }

    private void positionAtCentralDirectory() throws IOException {
        boolean found2 = false;
        long off = this.archive.length() - 22L;
        if (off >= 0L) {
            this.archive.seek(off);
            byte[] sig = JBZipOutputStream.EOCD_SIG;
            int curr = this.archive.read();
            while (curr != -1) {
                if (curr == sig[0] && (curr = this.archive.read()) == sig[1] && (curr = this.archive.read()) == sig[2] && (curr = this.archive.read()) == sig[3]) {
                    found2 = true;
                    break;
                }
                this.archive.seek(--off);
                curr = this.archive.read();
            }
        }
        if (!found2) {
            throw new ZipException("archive is not a ZIP archive");
        }
        this.archive.seek(off + 16L);
        byte[] cfdOffset = new byte[4];
        this.archive.readFully(cfdOffset);
        this.currentCfdOffset = ZipLong.getValue(cfdOffset);
        this.archive.seek(this.currentCfdOffset);
    }

    private String getString(byte[] bytes) {
        if (this.encoding == null) {
            return new String(bytes, Charset.defaultCharset());
        }
        return new String(bytes, this.encoding);
    }

    public void eraseEntry(JBZipEntry entry) throws IOException {
        this.getOutputStream();
        this.entries.remove(entry);
        this.nameMap.remove(entry.getName());
    }

    public void gc() throws IOException {
        if (this.myOutputStream != null) {
            this.myOutputStream = null;
            LinkedHashMap<JBZipEntry, byte[]> existingEntries = new LinkedHashMap<JBZipEntry, byte[]>();
            for (JBZipEntry jBZipEntry : this.entries) {
                existingEntries.put(jBZipEntry, jBZipEntry.getData());
            }
            this.currentCfdOffset = 0L;
            this.nameMap.clear();
            this.entries.clear();
            for (Map.Entry entry : existingEntries.entrySet()) {
                JBZipEntry zipEntry = this.getOrCreateEntry(((JBZipEntry)entry.getKey()).getName());
                zipEntry.setComment(((JBZipEntry)entry.getKey()).getComment());
                zipEntry.setExtra(((JBZipEntry)entry.getKey()).getExtra());
                zipEntry.setMethod(((JBZipEntry)entry.getKey()).getMethod());
                zipEntry.setTime(((JBZipEntry)entry.getKey()).getTime());
                zipEntry.setData((byte[])entry.getValue());
            }
        }
    }

    JBZipOutputStream getOutputStream() throws IOException {
        if (this.myOutputStream == null) {
            this.myOutputStream = new JBZipOutputStream(this, this.currentCfdOffset);
        }
        return this.myOutputStream;
    }

    void ensureFlushed(long end) throws IOException {
        if (this.myOutputStream != null) {
            this.myOutputStream.ensureFlushed(end);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "com/intellij/util/io/zip/JBZipFile", "<init>"));
    }
}

