/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import com.intellij.util.keyFMap.ArrayBackedFMap;
import com.intellij.util.keyFMap.KeyFMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class MapBackedFMap
extends TIntObjectHashMap<Object>
implements KeyFMap {
    private MapBackedFMap(@NotNull MapBackedFMap oldMap, final int exclude) {
        if (oldMap == null) {
            MapBackedFMap.$$$reportNull$$$0(0);
        }
        super(oldMap.size());
        oldMap.forEachEntry(new TIntObjectProcedure<Object>(){

            @Override
            public boolean execute(int key, Object val) {
                if (key != exclude) {
                    MapBackedFMap.this.put(key, val);
                }
                assert (key >= 0) : key;
                return true;
            }
        });
        assert (this.size() > 8);
    }

    MapBackedFMap(int @NotNull [] keys2, int newKey, Object @NotNull [] values2, @NotNull Object newValue) {
        if (newValue == null) {
            MapBackedFMap.$$$reportNull$$$0(1);
        }
        if (keys2 == null) {
            MapBackedFMap.$$$reportNull$$$0(2);
        }
        if (values2 == null) {
            MapBackedFMap.$$$reportNull$$$0(3);
        }
        super(keys2.length + 1);
        for (int i = 0; i < keys2.length; ++i) {
            int key = keys2[i];
            Object value2 = values2[i];
            this.put(key, value2);
            assert (key >= 0) : key;
        }
        this.put(newKey, newValue);
        assert (newKey >= 0) : newKey;
        assert (this.size() > 8);
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value2) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(4);
        }
        if (value2 == null) {
            MapBackedFMap.$$$reportNull$$$0(5);
        }
        int keyCode = key.hashCode();
        assert (keyCode >= 0) : key;
        Object oldValue = this.get(keyCode);
        if (value2 == oldValue) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                MapBackedFMap.$$$reportNull$$$0(6);
            }
            return mapBackedFMap;
        }
        MapBackedFMap newMap = new MapBackedFMap(this, -1);
        newMap.put(keyCode, value2);
        MapBackedFMap mapBackedFMap = newMap;
        if (mapBackedFMap == null) {
            MapBackedFMap.$$$reportNull$$$0(7);
        }
        return mapBackedFMap;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(8);
        }
        int oldSize = this.size();
        int keyCode = key.hashCode();
        if (!this.containsKey(keyCode)) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                MapBackedFMap.$$$reportNull$$$0(9);
            }
            return mapBackedFMap;
        }
        if (oldSize == 9) {
            int[] keys2 = this.keys();
            keys2 = ArrayUtil.remove(keys2, ArrayUtil.indexOf(keys2, keyCode));
            Arrays.sort(keys2);
            Object[] values2 = new Object[keys2.length];
            for (int i = 0; i < keys2.length; ++i) {
                values2[i] = this.get(keys2[i]);
            }
            return new ArrayBackedFMap(keys2, values2);
        }
        return new MapBackedFMap(this, keyCode);
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            MapBackedFMap.$$$reportNull$$$0(10);
        }
        return this.get(key.hashCode());
    }

    @Override
    public Key @NotNull [] getKeys() {
        Key[] keyArray = ArrayBackedFMap.getKeysByIndices(this.keys());
        if (keyArray == null) {
            MapBackedFMap.$$$reportNull$$$0(11);
        }
        return keyArray;
    }

    @Override
    public int getValueIdentityHashCode() {
        final int[] hash2 = new int[]{0};
        this.forEachEntry(new TIntObjectProcedure<Object>(){

            @Override
            public boolean execute(int key, Object value2) {
                hash2[0] = (hash2[0] * 31 + key) * 31 + System.identityHashCode(value2);
                return true;
            }
        });
        return hash2[0];
    }

    @Override
    public boolean equalsByReference(KeyFMap other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MapBackedFMap) || other.size() != this.size()) {
            return false;
        }
        final MapBackedFMap map2 = (MapBackedFMap)other;
        return this.forEachEntry(new TIntObjectProcedure<Object>(){

            @Override
            public boolean execute(int key, Object value2) {
                return map2.get(key) == value2;
            }
        });
    }

    @Override
    public String toString() {
        final StringBuilder s = new StringBuilder();
        this.forEachEntry(new TIntObjectProcedure<Object>(){

            @Override
            public boolean execute(int key, Object value2) {
                s.append(s.length() == 0 ? "" : ", ").append(Key.getKeyByIndex(key)).append(" -> ").append(value2);
                return true;
            }
        });
        return "[" + s.toString() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/keyFMap/MapBackedFMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/keyFMap/MapBackedFMap";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "plus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

