/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageBusImpl
implements MessageBus {
    private static final Logger LOG = Logger.getInstance(MessageBusImpl.class);
    private static final Comparator<MessageBusImpl> MESSAGE_BUS_COMPARATOR = (bus1, bus2) -> ArrayUtil.lexicographicCompare(bus1.myOrder, bus2.myOrder);
    private final ThreadLocal<Queue<DeliveryJob>> myMessageQueue;
    private final int[] myOrder;
    private final ConcurrentMap<Topic<?>, Object> myPublishers;
    private final ConcurrentMap<Topic<?>, List<MessageBusConnectionImpl>> mySubscribers;
    private final Map<Topic<?>, List<MessageBusConnectionImpl>> mySubscriberCache;
    private final List<MessageBusImpl> myChildBuses;
    @NotNull
    private volatile Map<String, List<ListenerDescriptor>> myTopicClassToListenerClass;
    private static final Object NA = new Object();
    private final MessageBusImpl myParentBus;
    private final RootBus myRootBus;
    private final MessageBusOwner myOwner;
    private boolean myDisposed;
    private Disposable myConnectionDisposable;
    private MessageDeliveryListener myMessageDeliveryListener;
    private final Map<PluginDescriptor, MessageBusConnectionImpl> myLazyConnections;
    private boolean myIgnoreParentLazyListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBusImpl(@NotNull MessageBusOwner owner, @NotNull MessageBusImpl parentBus) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(0);
        }
        if (parentBus == null) {
            MessageBusImpl.$$$reportNull$$$0(1);
        }
        this.myMessageQueue = MessageBusImpl.createThreadLocalQueue();
        this.myPublishers = ContainerUtil.newConcurrentMap();
        this.mySubscribers = ContainerUtil.newConcurrentMap();
        this.mySubscriberCache = ContainerUtil.newConcurrentMap();
        this.myChildBuses = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTopicClassToListenerClass = Collections.emptyMap();
        this.myOwner = owner;
        this.myConnectionDisposable = MessageBusImpl.createConnectionDisposable(owner);
        this.myParentBus = parentBus;
        this.myRootBus = parentBus.myRootBus;
        List<MessageBusImpl> list2 = parentBus.myChildBuses;
        synchronized (list2) {
            this.myOrder = parentBus.nextOrder();
            parentBus.myChildBuses.add(this);
        }
        LOG.assertTrue(parentBus.myChildBuses.contains(this));
        this.myRootBus.clearSubscriberCache();
        this.myLazyConnections = parentBus.myParentBus == null ? ConcurrentFactoryMap.createMap(key -> this.connect()) : null;
    }

    @NotNull
    private static Disposable createConnectionDisposable(@NotNull MessageBusOwner owner) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(2);
        }
        Disposable disposable2 = Disposer.newDisposable(owner.toString());
        if (disposable2 == null) {
            MessageBusImpl.$$$reportNull$$$0(3);
        }
        return disposable2;
    }

    private MessageBusImpl(@NotNull MessageBusOwner owner) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(4);
        }
        this.myMessageQueue = MessageBusImpl.createThreadLocalQueue();
        this.myPublishers = ContainerUtil.newConcurrentMap();
        this.mySubscribers = ContainerUtil.newConcurrentMap();
        this.mySubscriberCache = ContainerUtil.newConcurrentMap();
        this.myChildBuses = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTopicClassToListenerClass = Collections.emptyMap();
        this.myOwner = owner;
        this.myConnectionDisposable = MessageBusImpl.createConnectionDisposable(owner);
        this.myOrder = ArrayUtil.EMPTY_INT_ARRAY;
        this.myRootBus = (RootBus)this;
        this.myLazyConnections = ConcurrentFactoryMap.createMap(key -> this.connect());
        this.myParentBus = null;
    }

    public void setIgnoreParentLazyListeners(boolean ignoreParentLazyListeners) {
        this.myIgnoreParentLazyListeners = ignoreParentLazyListeners;
    }

    @ApiStatus.Internal
    public void setLazyListeners(@NotNull ConcurrentMap<String, List<ListenerDescriptor>> map2) {
        if (map2 == null) {
            MessageBusImpl.$$$reportNull$$$0(5);
        }
        if (this.myTopicClassToListenerClass != Collections.emptyMap()) {
            this.myTopicClassToListenerClass.putAll(map2);
            this.clearSubscriberCache();
        } else {
            this.myTopicClassToListenerClass = map2;
        }
    }

    @Override
    public MessageBus getParent() {
        return this.myParentBus;
    }

    public String toString() {
        return super.toString() + "; owner=" + this.myOwner + (this.isDisposed() ? "; disposed" : "");
    }

    private int @NotNull [] nextOrder() {
        int lastChildIndex;
        MessageBusImpl lastChild = ContainerUtil.getLastItem(this.myChildBuses);
        int n = lastChildIndex = lastChild == null ? 0 : ArrayUtil.getLastElement(lastChild.myOrder, 0);
        if (lastChildIndex == Integer.MAX_VALUE) {
            LOG.error("Too many child buses");
        }
        int[] nArray = ArrayUtil.append(this.myOrder, lastChildIndex + 1);
        if (nArray == null) {
            MessageBusImpl.$$$reportNull$$$0(6);
        }
        return nArray;
    }

    private void onChildBusDisposed(@NotNull MessageBusImpl childBus) {
        if (childBus == null) {
            MessageBusImpl.$$$reportNull$$$0(7);
        }
        boolean removed = this.myChildBuses.remove(childBus);
        Map map2 = (Map)this.myRootBus.myWaitingBuses.get();
        if (map2 != null) {
            map2.remove(childBus);
        }
        this.myRootBus.clearSubscriberCache();
        LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public MessageBusConnectionImpl connect() {
        MessageBusConnectionImpl messageBusConnectionImpl = this.connect(this.myConnectionDisposable);
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(8);
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public MessageBusConnectionImpl connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MessageBusImpl.$$$reportNull$$$0(9);
        }
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        Disposer.register(parentDisposable, connection);
        MessageBusConnectionImpl messageBusConnectionImpl = connection;
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(10);
        }
        return messageBusConnectionImpl;
    }

    @Override
    @NotNull
    public <L> L syncPublisher(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(11);
        }
        this.checkNotDisposed();
        Object publisher = this.myPublishers.get(topic);
        if (publisher != null) {
            Object v = publisher;
            if (v == null) {
                MessageBusImpl.$$$reportNull$$$0(12);
            }
            return (L)v;
        }
        Class<L> listenerClass = topic.getListenerClass();
        Object newInstance = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, this.createTopicHandler(topic));
        Object prev = this.myPublishers.putIfAbsent(topic, newInstance);
        Object object = prev == null ? newInstance : prev;
        if (object == null) {
            MessageBusImpl.$$$reportNull$$$0(13);
        }
        return (L)object;
    }

    private <L> void subscribeLazyListeners(@NotNull Topic<L> topic) {
        List<ListenerDescriptor> listenerDescriptors;
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(14);
        }
        if ((listenerDescriptors = this.myTopicClassToListenerClass.remove(topic.getListenerClass().getName())) != null) {
            MultiMap<PluginDescriptor, Object> listenerMap = new MultiMap<PluginDescriptor, Object>();
            for (ListenerDescriptor listenerDescriptor : listenerDescriptors) {
                try {
                    listenerMap.putValue(listenerDescriptor.pluginDescriptor, this.myOwner.createListener(listenerDescriptor));
                }
                catch (ExtensionNotApplicableException extensionNotApplicableException) {
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Cannot create listener", e);
                }
            }
            if (!listenerMap.isEmpty()) {
                for (Map.Entry entry : listenerMap.entrySet()) {
                    this.myLazyConnections.get(entry.getKey()).subscribe(topic, (Collection)entry.getValue());
                }
            }
        }
    }

    @ApiStatus.Internal
    public void unsubscribePluginListeners(PluginDescriptor pluginDescriptor) {
        MessageBusConnectionImpl connection = this.myLazyConnections.remove(pluginDescriptor);
        if (connection != null) {
            Disposer.dispose(connection);
        }
    }

    @NotNull
    private <L> InvocationHandler createTopicHandler(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(15);
        }
        InvocationHandler invocationHandler = (proxy, method2, args) -> {
            if (method2.getDeclaringClass().getName().equals("java.lang.Object")) {
                return EventDispatcher.handleObjectMethod(proxy, args, method2.getName());
            }
            this.sendMessage(new Message(topic, method2, args));
            return NA;
        };
        if (invocationHandler == null) {
            MessageBusImpl.$$$reportNull$$$0(16);
        }
        return invocationHandler;
    }

    public final void disposeConnectionChildren() {
        Disposer.disposeChildren(this.myConnectionDisposable);
    }

    public final void disposeConnection() {
        Disposer.dispose(this.myConnectionDisposable);
        this.myConnectionDisposable = null;
    }

    @Override
    public final void dispose() {
        Queue<DeliveryJob> jobs;
        if (this.myDisposed) {
            LOG.error("Already disposed: " + this);
        }
        this.myDisposed = true;
        for (MessageBusImpl childBus : this.myChildBuses) {
            Disposer.dispose(childBus);
        }
        if (this.myConnectionDisposable != null) {
            Disposer.dispose(this.myConnectionDisposable);
        }
        if (!(jobs = this.myMessageQueue.get()).isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        this.myMessageQueue.remove();
        if (this.myParentBus != null) {
            this.myParentBus.onChildBusDisposed(this);
        } else {
            this.myRootBus.myWaitingBuses.remove();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed || this.myOwner.isDisposed();
    }

    @Override
    public boolean hasUndeliveredEvents(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(17);
        }
        if (this.isDisposed() || !this.isDispatchingAnything()) {
            return false;
        }
        for (MessageBusConnectionImpl connection : this.getTopicSubscribers(topic)) {
            if (!connection.containsMessage(topic)) continue;
            return true;
        }
        return false;
    }

    private boolean isDispatchingAnything() {
        Map waitingBuses = (Map)this.myRootBus.myWaitingBuses.get();
        return waitingBuses != null && !waitingBuses.isEmpty();
    }

    private void checkNotDisposed() {
        if (this.isDisposed()) {
            LOG.error("Already disposed: " + this);
        }
    }

    @NotNull
    String getOwner() {
        String string = this.myOwner.toString();
        if (string == null) {
            MessageBusImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    private void calcSubscribers(@NotNull Topic<?> topic, @NotNull List<? super MessageBusConnectionImpl> result2, boolean subscribeLazyListeners) {
        Topic.BroadcastDirection direction;
        List topicSubscribers;
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(19);
        }
        if (result2 == null) {
            MessageBusImpl.$$$reportNull$$$0(20);
        }
        if (subscribeLazyListeners) {
            this.subscribeLazyListeners(topic);
        }
        if ((topicSubscribers = (List)this.mySubscribers.get(topic)) != null) {
            result2.addAll(topicSubscribers);
        }
        if ((direction = topic.getBroadcastDirection()) == Topic.BroadcastDirection.TO_CHILDREN) {
            for (MessageBusImpl childBus : this.myChildBuses) {
                if (childBus.isDisposed()) continue;
                childBus.calcSubscribers(topic, result2, !childBus.myIgnoreParentLazyListeners);
            }
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT && this.myParentBus != null) {
            this.myParentBus.calcSubscribers(topic, result2, true);
        }
    }

    private void postMessage(@NotNull Message message) {
        if (message == null) {
            MessageBusImpl.$$$reportNull$$$0(21);
        }
        this.checkNotDisposed();
        List<MessageBusConnectionImpl> topicSubscribers = this.getTopicSubscribers(message.getTopic());
        if (topicSubscribers.isEmpty()) {
            return;
        }
        for (MessageBusConnectionImpl subscriber : topicSubscribers) {
            MessageBusImpl bus = subscriber.getBus();
            if (bus.isDisposed()) continue;
            bus.myMessageQueue.get().offer(new DeliveryJob(subscriber, message));
            bus.notifyPendingJobChange(1);
            subscriber.scheduleMessageDelivery(message);
        }
    }

    @NotNull
    private List<MessageBusConnectionImpl> getTopicSubscribers(@NotNull Topic<?> topic) {
        List<MessageBusConnectionImpl> topicSubscribers;
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(22);
        }
        if ((topicSubscribers = this.mySubscriberCache.get(topic)) == null) {
            topicSubscribers = new ArrayList<MessageBusConnectionImpl>();
            this.calcSubscribers(topic, topicSubscribers, true);
            this.mySubscriberCache.put(topic, topicSubscribers);
            this.myRootBus.myClearedSubscribersCache = false;
        }
        List<MessageBusConnectionImpl> list2 = topicSubscribers;
        if (list2 == null) {
            MessageBusImpl.$$$reportNull$$$0(23);
        }
        return list2;
    }

    private void notifyPendingJobChange(int delta) {
        Integer countObject;
        int count;
        int newCount;
        ThreadLocal ref = this.myRootBus.myWaitingBuses;
        TreeMap<MessageBusImpl, Integer> map2 = (TreeMap<MessageBusImpl, Integer>)ref.get();
        if (map2 == null) {
            map2 = new TreeMap<MessageBusImpl, Integer>(MESSAGE_BUS_COMPARATOR);
            ref.set(map2);
        }
        if ((newCount = (count = (countObject = (Integer)map2.get(this)) == null ? 0 : countObject) + delta) > 0) {
            this.checkNotDisposed();
            map2.put(this, newCount);
        } else if (newCount == 0) {
            map2.remove(this);
        } else {
            LOG.error("Negative job count: " + this);
        }
    }

    private void sendMessage(@NotNull Message message) {
        if (message == null) {
            MessageBusImpl.$$$reportNull$$$0(24);
        }
        this.pumpMessages();
        this.postMessage(message);
        this.pumpMessages();
    }

    private void pumpMessages() {
        this.checkNotDisposed();
        Map map2 = (Map)this.myRootBus.myWaitingBuses.get();
        if (map2 == null || map2.isEmpty()) {
            return;
        }
        ArrayList<MessageBusImpl> liveBuses = new ArrayList<MessageBusImpl>(map2.size());
        for (MessageBusImpl bus : map2.keySet()) {
            if (!MessageBusImpl.ensureAlive(map2, bus)) continue;
            liveBuses.add(bus);
        }
        if (!liveBuses.isEmpty()) {
            MessageBusImpl.pumpWaitingBuses(liveBuses);
        }
    }

    private static void pumpWaitingBuses(@NotNull List<? extends MessageBusImpl> buses) {
        if (buses == null) {
            MessageBusImpl.$$$reportNull$$$0(25);
        }
        List<Throwable> exceptions = null;
        for (MessageBusImpl messageBusImpl : buses) {
            if (messageBusImpl.isDisposed()) continue;
            exceptions = MessageBusImpl.appendExceptions(exceptions, messageBusImpl.doPumpMessages());
        }
        MessageBusImpl.rethrowExceptions(exceptions);
    }

    private static List<Throwable> appendExceptions(@Nullable List<Throwable> exceptions, @NotNull List<? extends Throwable> busExceptions) {
        if (busExceptions == null) {
            MessageBusImpl.$$$reportNull$$$0(26);
        }
        if (!busExceptions.isEmpty()) {
            if (exceptions == null) {
                exceptions = new ArrayList<Throwable>(busExceptions.size());
            }
            exceptions.addAll(busExceptions);
        }
        return exceptions;
    }

    private static void rethrowExceptions(@Nullable List<? extends Throwable> exceptions) {
        if (exceptions == null) {
            return;
        }
        ProcessCanceledException pce = ContainerUtil.findInstance(exceptions, ProcessCanceledException.class);
        if (pce != null) {
            throw pce;
        }
        CompoundRuntimeException.throwIfNotEmpty(exceptions);
    }

    private static boolean ensureAlive(@NotNull Map<MessageBusImpl, Integer> map2, @NotNull MessageBusImpl bus) {
        if (map2 == null) {
            MessageBusImpl.$$$reportNull$$$0(27);
        }
        if (bus == null) {
            MessageBusImpl.$$$reportNull$$$0(28);
        }
        if (bus.isDisposed()) {
            map2.remove(bus);
            LOG.error("Accessing disposed message bus " + bus);
            return false;
        }
        return true;
    }

    @NotNull
    private List<Throwable> doPumpMessages() {
        DeliveryJob job2;
        Queue<DeliveryJob> queue = this.myMessageQueue.get();
        List<Throwable> exceptions = Collections.emptyList();
        while ((job2 = queue.poll()) != null) {
            this.notifyPendingJobChange(-1);
            try {
                job2.connection.deliverMessage(job2.message);
            }
            catch (Throwable e) {
                if (exceptions == Collections.emptyList()) {
                    exceptions = new ArrayList<Throwable>();
                }
                exceptions.add(e);
            }
        }
        List<Throwable> list2 = exceptions;
        if (list2 == null) {
            MessageBusImpl.$$$reportNull$$$0(29);
        }
        return list2;
    }

    void notifyOnSubscription(@NotNull MessageBusConnectionImpl connection, @NotNull Topic<?> topic) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(30);
        }
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(31);
        }
        this.checkNotDisposed();
        List topicSubscribers = (List)this.mySubscribers.get(topic);
        if (topicSubscribers == null) {
            topicSubscribers = ContainerUtil.createLockFreeCopyOnWriteList();
            topicSubscribers = ConcurrencyUtil.cacheOrGet(this.mySubscribers, topic, topicSubscribers);
        }
        topicSubscribers.add(connection);
        this.myRootBus.clearSubscriberCache();
    }

    void clearSubscriberCache() {
        this.mySubscriberCache.clear();
        for (MessageBusImpl bus : this.myChildBuses) {
            bus.clearSubscriberCache();
        }
    }

    void notifyConnectionTerminated(@NotNull MessageBusConnectionImpl connection) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(32);
        }
        for (List topicSubscribers : this.mySubscribers.values()) {
            topicSubscribers.remove(connection);
        }
        if (this.isDisposed()) {
            return;
        }
        this.myRootBus.clearSubscriberCache();
        Iterator i = this.myMessageQueue.get().iterator();
        while (i.hasNext()) {
            DeliveryJob job2 = (DeliveryJob)i.next();
            if (job2.connection != connection) continue;
            i.remove();
            this.notifyPendingJobChange(-1);
        }
    }

    void deliverSingleMessage() {
        this.checkNotDisposed();
        DeliveryJob job2 = this.myMessageQueue.get().poll();
        if (job2 == null) {
            return;
        }
        this.notifyPendingJobChange(-1);
        job2.connection.deliverMessage(job2.message);
    }

    @NotNull
    static <T> ThreadLocal<Queue<T>> createThreadLocalQueue() {
        ThreadLocal<Queue<T>> threadLocal = ThreadLocal.withInitial(ArrayDeque::new);
        if (threadLocal == null) {
            MessageBusImpl.$$$reportNull$$$0(33);
        }
        return threadLocal;
    }

    @ApiStatus.Internal
    public void setMessageDeliveryListener(@Nullable MessageDeliveryListener listener2) {
        if (this.myMessageDeliveryListener != null && listener2 != null) {
            throw new IllegalStateException("Already set: " + this.myMessageDeliveryListener);
        }
        this.myMessageDeliveryListener = listener2;
    }

    void invokeListener(@NotNull Message message, Object handler2) throws IllegalAccessException, InvocationTargetException {
        if (message == null) {
            MessageBusImpl.$$$reportNull$$$0(34);
        }
        Method method2 = message.getListenerMethod();
        MessageDeliveryListener listener2 = this.myMessageDeliveryListener;
        if (listener2 == null) {
            method2.invoke(handler2, message.getArgs());
            return;
        }
        long startTime = System.nanoTime();
        method2.invoke(handler2, message.getArgs());
        listener2.messageDelivered(message.getTopic(), method2.getName(), handler2, System.nanoTime() - startTime);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 23: 
            case 29: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 23: 
            case 29: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 23: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 5: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childBus";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 21: 
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buses";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "busExceptions";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConnectionDisposable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "nextOrder";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopicHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopicSubscribers";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doPumpMessages";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createThreadLocalQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createConnectionDisposable";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 23: 
            case 29: 
            case 33: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setLazyListeners";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onChildBusDisposed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "subscribeLazyListeners";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTopicHandler";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasUndeliveredEvents";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calcSubscribers";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "postMessage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTopicSubscribers";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sendMessage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "pumpWaitingBuses";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "appendExceptions";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ensureAlive";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscription";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "notifyConnectionTerminated";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "invokeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 23: 
            case 29: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RootBus
    extends MessageBusImpl {
        private final ThreadLocal<SortedMap<MessageBusImpl, Integer>> myWaitingBuses;
        private volatile boolean myClearedSubscribersCache;

        @Override
        void clearSubscriberCache() {
            if (this.myClearedSubscribersCache) {
                return;
            }
            super.clearSubscriberCache();
            this.myClearedSubscribersCache = true;
        }

        RootBus(@NotNull MessageBusOwner owner) {
            if (owner == null) {
                RootBus.$$$reportNull$$$0(0);
            }
            super(owner);
            this.myWaitingBuses = new ThreadLocal();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/messages/impl/MessageBusImpl$RootBus", "<init>"));
        }
    }

    private static final class DeliveryJob {
        public final MessageBusConnectionImpl connection;
        public final Message message;

        DeliveryJob(@NotNull MessageBusConnectionImpl connection, @NotNull Message message) {
            if (connection == null) {
                DeliveryJob.$$$reportNull$$$0(0);
            }
            if (message == null) {
                DeliveryJob.$$$reportNull$$$0(1);
            }
            this.connection = connection;
            this.message = message;
        }

        @NonNls
        public String toString() {
            return "{ DJob connection:" + this.connection + "; message: " + this.message + " }";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/messages/impl/MessageBusImpl$DeliveryJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

