/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.modules;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Chunk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CircularModuleDependenciesDetector {
    @NotNull
    private static <T extends ModuleRootModel> Graph<T> createGraphGenerator(final @NotNull Map<Module, T> models) {
        if (models == null) {
            CircularModuleDependenciesDetector.$$$reportNull$$$0(0);
        }
        Graph graph2 = GraphGenerator.generate(CachingSemiGraph.cache(new InboundSemiGraph<T>(){

            @Override
            @NotNull
            public Collection<T> getNodes() {
                Collection collection = models.values();
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            @Override
            @NotNull
            public Iterator<T> getIn(ModuleRootModel model) {
                ArrayList dependencies = new ArrayList();
                model.orderEntries().compileOnly().forEachModule(module2 -> {
                    ModuleRootModel depModel = (ModuleRootModel)models.get(module2);
                    if (depModel != null) {
                        dependencies.add(depModel);
                    }
                    return true;
                });
                Iterator iterator2 = dependencies.iterator();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/modules/CircularModuleDependenciesDetector$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
        if (graph2 == null) {
            CircularModuleDependenciesDetector.$$$reportNull$$$0(1);
        }
        return graph2;
    }

    @NotNull
    private static <T extends ModuleRootModel> Collection<Chunk<T>> buildChunks(@NotNull Map<Module, T> models) {
        if (models == null) {
            CircularModuleDependenciesDetector.$$$reportNull$$$0(2);
        }
        Collection<Chunk<T>> collection = GraphAlgorithms.getInstance().computeSCCGraph(CircularModuleDependenciesDetector.createGraphGenerator(models)).getNodes();
        if (collection == null) {
            CircularModuleDependenciesDetector.$$$reportNull$$$0(3);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Couple<Module> addingDependencyFormsCircularity(@NotNull Module currentModule, @NotNull Module toDependOn) {
        if (currentModule == null) {
            CircularModuleDependenciesDetector.$$$reportNull$$$0(4);
        }
        if (toDependOn == null) {
            CircularModuleDependenciesDetector.$$$reportNull$$$0(5);
        }
        assert (currentModule != toDependOn);
        LinkedHashMap<Module, ModifiableRootModel> models = new LinkedHashMap<Module, ModifiableRootModel>();
        Project project2 = currentModule.getProject();
        for (Module module2 : ModuleManager.getInstance(project2).getModules()) {
            ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance(module2).getModifiableModel();
            models.put(module2, modifiableRootModel);
        }
        ModifiableRootModel currentModel = (ModifiableRootModel)models.get(currentModule);
        ModifiableRootModel toDependOnModel = (ModifiableRootModel)models.get(toDependOn);
        Collection nodesBefore = CircularModuleDependenciesDetector.buildChunks(models);
        for (Chunk chunk : nodesBefore) {
            if (!chunk.containsNode(toDependOnModel) || !chunk.containsNode(currentModel)) continue;
            return null;
        }
        try {
            currentModel.addModuleOrderEntry(toDependOn);
            Collection nodesAfter = CircularModuleDependenciesDetector.buildChunks(models);
            for (Chunk chunk : nodesAfter) {
                if (!chunk.containsNode(toDependOnModel) || !chunk.containsNode(currentModel)) continue;
                List nodes = ContainerUtil.collect(chunk.getNodes().iterator());
                nodes.sort(Comparator.comparing(m -> m.getModule().getName()));
                Couple<Module> couple = Couple.of(((ModifiableRootModel)nodes.get(0)).getModule(), ((ModifiableRootModel)nodes.get(1)).getModule());
                return couple;
            }
        }
        finally {
            for (ModifiableRootModel model : models.values()) {
                model.dispose();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/modules/CircularModuleDependenciesDetector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentModule";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDependOn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/modules/CircularModuleDependenciesDetector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createGraphGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createGraphGenerator";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildChunks";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addingDependencyFormsCircularity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

