/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import com.intellij.DynamicBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PortField;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.proxy.CommonProxy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HttpProxySettingsUi
implements ConfigurableUi<HttpConfigurable> {
    private JPanel myMainPanel;
    private JTextField myProxyLoginTextField;
    private JPasswordField myProxyPasswordTextField;
    private JCheckBox myProxyAuthCheckBox;
    private PortField myProxyPortTextField;
    private JTextField myProxyHostTextField;
    private JCheckBox myRememberProxyPasswordCheckBox;
    private JLabel myProxyLoginLabel;
    private JLabel myProxyPasswordLabel;
    private JLabel myHostNameLabel;
    private JLabel myPortNumberLabel;
    private JBRadioButton myAutoDetectProxyRb;
    private JBRadioButton myUseHTTPProxyRb;
    private JLabel mySystemProxyDefined;
    private JBRadioButton myNoProxyRb;
    private JBRadioButton myHTTP;
    private JBRadioButton mySocks;
    private JButton myClearPasswordsButton;
    private JLabel myErrorLabel;
    private JButton myCheckButton;
    private JLabel myOtherWarning;
    private JLabel myProxyExceptionsLabel;
    private RawCommandLineEditor myProxyExceptions;
    private JLabel myNoProxyForLabel;
    private JCheckBox myPacUrlCheckBox;
    private JTextField myPacUrlTextField;

    @Override
    public boolean isModified(@NotNull HttpConfigurable settings) {
        if (settings == null) {
            HttpProxySettingsUi.$$$reportNull$$$0(0);
        }
        return !Comparing.strEqual(this.myProxyExceptions.getText().trim(), settings.PROXY_EXCEPTIONS) || settings.USE_PROXY_PAC != this.myAutoDetectProxyRb.isSelected() || settings.USE_PAC_URL != this.myPacUrlCheckBox.isSelected() || !Comparing.strEqual(settings.PAC_URL, this.myPacUrlTextField.getText()) || settings.USE_HTTP_PROXY != this.myUseHTTPProxyRb.isSelected() || settings.PROXY_AUTHENTICATION != this.myProxyAuthCheckBox.isSelected() || settings.KEEP_PROXY_PASSWORD != this.myRememberProxyPasswordCheckBox.isSelected() || settings.PROXY_TYPE_IS_SOCKS != this.mySocks.isSelected() || !Comparing.strEqual(settings.getProxyLogin(), this.myProxyLoginTextField.getText()) || !Comparing.strEqual(settings.getPlainProxyPassword(), new String(this.myProxyPasswordTextField.getPassword())) || settings.PROXY_PORT != this.myProxyPortTextField.getNumber() || !Comparing.strEqual(settings.PROXY_HOST, this.myProxyHostTextField.getText());
    }

    HttpProxySettingsUi(@NotNull HttpConfigurable settings) {
        if (settings == null) {
            HttpProxySettingsUi.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        ButtonGroup group = new ButtonGroup();
        group.add(this.myUseHTTPProxyRb);
        group.add(this.myAutoDetectProxyRb);
        group.add(this.myNoProxyRb);
        this.myNoProxyRb.setSelected(true);
        ButtonGroup proxyTypeGroup = new ButtonGroup();
        proxyTypeGroup.add(this.myHTTP);
        proxyTypeGroup.add(this.mySocks);
        this.myHTTP.setSelected(true);
        Boolean property = Boolean.getBoolean("java.net.useSystemProxies");
        this.mySystemProxyDefined.setVisible(Boolean.TRUE.equals(property));
        if (Boolean.TRUE.equals(property)) {
            this.mySystemProxyDefined.setIcon(Messages.getWarningIcon());
            RelativeFont.BOLD.install(this.mySystemProxyDefined);
        }
        this.myProxyAuthCheckBox.addActionListener(e -> this.enableProxyAuthentication(this.myProxyAuthCheckBox.isSelected()));
        this.myPacUrlCheckBox.addActionListener(e -> this.myPacUrlTextField.setEnabled(this.myPacUrlCheckBox.isSelected()));
        ActionListener listener2 = e -> this.enableProxy(this.myUseHTTPProxyRb.isSelected());
        this.myUseHTTPProxyRb.addActionListener(listener2);
        this.myAutoDetectProxyRb.addActionListener(listener2);
        this.myNoProxyRb.addActionListener(listener2);
        this.myClearPasswordsButton.addActionListener(e -> {
            settings.clearGenericPasswords();
            Messages.showMessageDialog(this.myMainPanel, IdeBundle.message("message.text.proxy.passwords.were.cleared", new Object[0]), IdeBundle.message("dialog.title.auto.detected.proxy", new Object[0]), Messages.getInformationIcon());
        });
        this.configureCheckButton();
    }

    private void configureCheckButton() {
        if (HttpConfigurable.getInstance() == null) {
            this.myCheckButton.setVisible(false);
            return;
        }
        this.myCheckButton.addActionListener(event -> {
            String error = this.isValid();
            if (error != null) {
                Messages.showErrorDialog(this.myMainPanel, error);
                return;
            }
            String title = IdeBundle.message("dialog.title.check.proxy.settings", new Object[0]);
            String answer = Messages.showInputDialog(this.myMainPanel, IdeBundle.message("message.text.enter.url.to.check.connection", new Object[0]), title, Messages.getQuestionIcon(), "http://", null);
            if (StringUtil.isEmptyOrSpaces(answer)) {
                return;
            }
            HttpConfigurable settings = HttpConfigurable.getInstance();
            try {
                this.apply(settings);
            }
            catch (ConfigurationException e) {
                return;
            }
            AtomicReference exceptionReference = new AtomicReference();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    HttpRequests.request(answer).readTimeout(3000).tryConnect();
                }
                catch (IOException e) {
                    exceptionReference.set(e);
                }
            }, IdeBundle.message("progress.title.check.connection", new Object[0]), true, null);
            this.reset(settings);
            IOException exception = (IOException)exceptionReference.get();
            if (exception == null) {
                Messages.showMessageDialog(this.myMainPanel, IdeBundle.message("message.connection.successful", new Object[0]), title, Messages.getInformationIcon());
            } else {
                String message = exception.getMessage();
                if (settings.USE_HTTP_PROXY) {
                    settings.LAST_ERROR = message;
                }
                Messages.showErrorDialog(this.myMainPanel, HttpProxySettingsUi.errorText(message));
            }
        });
    }

    @Override
    public void reset(@NotNull HttpConfigurable settings) {
        if (settings == null) {
            HttpProxySettingsUi.$$$reportNull$$$0(2);
        }
        this.myNoProxyRb.setSelected(true);
        this.myAutoDetectProxyRb.setSelected(settings.USE_PROXY_PAC);
        this.myPacUrlCheckBox.setSelected(settings.USE_PAC_URL);
        this.myPacUrlTextField.setText(settings.PAC_URL);
        this.myUseHTTPProxyRb.setSelected(settings.USE_HTTP_PROXY);
        this.myProxyAuthCheckBox.setSelected(settings.PROXY_AUTHENTICATION);
        this.enableProxy(settings.USE_HTTP_PROXY);
        this.myProxyLoginTextField.setText(settings.getProxyLogin());
        this.myProxyPasswordTextField.setText(settings.getPlainProxyPassword());
        this.myProxyPortTextField.setNumber(settings.PROXY_PORT);
        this.myProxyHostTextField.setText(settings.PROXY_HOST);
        this.myProxyExceptions.setText(StringUtil.notNullize(settings.PROXY_EXCEPTIONS));
        this.myRememberProxyPasswordCheckBox.setSelected(settings.KEEP_PROXY_PASSWORD);
        this.mySocks.setSelected(settings.PROXY_TYPE_IS_SOCKS);
        this.myHTTP.setSelected(!settings.PROXY_TYPE_IS_SOCKS);
        boolean showError = !StringUtil.isEmptyOrSpaces(settings.LAST_ERROR);
        this.myErrorLabel.setVisible(showError);
        this.myErrorLabel.setText(showError ? HttpProxySettingsUi.errorText(settings.LAST_ERROR) : null);
        String oldStyleText = CommonProxy.getMessageFromProps(CommonProxy.getOldStyleProperties());
        this.myOtherWarning.setVisible(oldStyleText != null);
        if (oldStyleText != null) {
            this.myOtherWarning.setText(oldStyleText);
            this.myOtherWarning.setIcon(Messages.getWarningIcon());
        }
    }

    private void createUIComponents() {
        this.myProxyExceptions = new RawCommandLineEditor(text2 -> {
            ArrayList<String> result2 = new ArrayList<String>();
            for (String token : text2.split(",")) {
                String trimmedToken = token.trim();
                if (trimmedToken.isEmpty()) continue;
                result2.add(trimmedToken);
            }
            return result2;
        }, strings -> StringUtil.join(strings, ", "));
    }

    @NotNull
    private static String errorText(@NotNull String s) {
        if (s == null) {
            HttpProxySettingsUi.$$$reportNull$$$0(3);
        }
        String string = "Problem with connection: " + s;
        if (string == null) {
            HttpProxySettingsUi.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private String isValid() {
        if (this.myUseHTTPProxyRb.isSelected()) {
            String host = HttpProxySettingsUi.getText(this.myProxyHostTextField);
            if (host == null) {
                return "Host name is empty";
            }
            try {
                HostAndPort parsedHost = HostAndPort.fromString((String)host);
                if (parsedHost.hasPort()) {
                    return "Invalid host value";
                }
                host = parsedHost.getHost();
                try {
                    InetAddresses.forString((String)host);
                    return null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    InternetDomainName.from((String)host);
                }
            }
            catch (IllegalArgumentException e) {
                return "Invalid host value";
            }
            if (this.myProxyAuthCheckBox.isSelected()) {
                if (StringUtil.isEmptyOrSpaces(this.myProxyLoginTextField.getText())) {
                    return "Login is empty";
                }
                if (this.myProxyPasswordTextField.getPassword().length == 0) {
                    return "Password is empty";
                }
            }
        }
        return null;
    }

    @Override
    public void apply(@NotNull HttpConfigurable settings) throws ConfigurationException {
        String error;
        if (settings == null) {
            HttpProxySettingsUi.$$$reportNull$$$0(5);
        }
        if ((error = this.isValid()) != null) {
            throw new ConfigurationException(error);
        }
        if (this.isModified(settings)) {
            settings.AUTHENTICATION_CANCELLED = false;
        }
        settings.USE_PROXY_PAC = this.myAutoDetectProxyRb.isSelected();
        settings.USE_PAC_URL = this.myPacUrlCheckBox.isSelected();
        settings.PAC_URL = HttpProxySettingsUi.getText(this.myPacUrlTextField);
        settings.USE_HTTP_PROXY = this.myUseHTTPProxyRb.isSelected();
        settings.PROXY_TYPE_IS_SOCKS = this.mySocks.isSelected();
        settings.PROXY_AUTHENTICATION = this.myProxyAuthCheckBox.isSelected();
        settings.KEEP_PROXY_PASSWORD = this.myRememberProxyPasswordCheckBox.isSelected();
        settings.setProxyLogin(HttpProxySettingsUi.getText(this.myProxyLoginTextField));
        settings.setPlainProxyPassword(new String(this.myProxyPasswordTextField.getPassword()));
        settings.PROXY_EXCEPTIONS = StringUtil.nullize(this.myProxyExceptions.getText(), true);
        settings.PROXY_PORT = this.myProxyPortTextField.getNumber();
        settings.PROXY_HOST = HttpProxySettingsUi.getText(this.myProxyHostTextField);
    }

    @Nullable
    private static String getText(@NotNull JTextField field) {
        if (field == null) {
            HttpProxySettingsUi.$$$reportNull$$$0(6);
        }
        return StringUtil.nullize(field.getText(), true);
    }

    private void enableProxy(boolean enabled) {
        this.myHostNameLabel.setEnabled(enabled);
        this.myPortNumberLabel.setEnabled(enabled);
        this.myProxyHostTextField.setEnabled(enabled);
        this.myProxyPortTextField.setEnabled(enabled);
        this.mySocks.setEnabled(enabled);
        this.myHTTP.setEnabled(enabled);
        this.myProxyExceptions.setEnabled(enabled);
        this.myProxyExceptionsLabel.setEnabled(enabled);
        this.myNoProxyForLabel.setEnabled(enabled);
        this.myProxyAuthCheckBox.setEnabled(enabled);
        this.enableProxyAuthentication(enabled && this.myProxyAuthCheckBox.isSelected());
        boolean autoDetectProxy = this.myAutoDetectProxyRb.isSelected();
        this.myPacUrlCheckBox.setEnabled(autoDetectProxy);
        this.myClearPasswordsButton.setEnabled(autoDetectProxy);
        this.myPacUrlTextField.setEnabled(autoDetectProxy && this.myPacUrlCheckBox.isSelected());
    }

    private void enableProxyAuthentication(boolean enabled) {
        this.myProxyLoginLabel.setEnabled(enabled);
        this.myProxyLoginTextField.setEnabled(enabled);
        this.myProxyPasswordLabel.setEnabled(enabled);
        this.myProxyPasswordTextField.setEnabled(enabled);
        this.myRememberProxyPasswordCheckBox.setEnabled(enabled);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            HttpProxySettingsUi.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JLabel jLabel;
        JButton jButton2;
        JLabel jLabel2;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JLabel jLabel3;
        JBRadioButton jBRadioButton4;
        JBRadioButton jBRadioButton5;
        JLabel jLabel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JCheckBox jCheckBox2;
        JLabel jLabel7;
        JLabel jLabel8;
        JCheckBox jCheckBox3;
        JTextField jTextField2;
        JLabel jLabel9;
        JPasswordField jPasswordField;
        JTextField jTextField3;
        PortField portField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(12, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myProxyPortTextField = portField = new PortField();
        jPanel2.add((Component)portField, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myProxyLoginTextField = jTextField3 = new JTextField();
        jTextField3.setText("");
        jPanel2.add((Component)jTextField3, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myProxyPasswordTextField = jPasswordField = new JPasswordField();
        jPanel2.add((Component)jPasswordField, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myProxyExceptionsLabel = jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.manual.exclude.example"));
        jPanel2.add((Component)jLabel9, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProxyHostTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myRememberProxyPasswordCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("auth.remember.cb"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(7, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHostNameLabel = jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.manual.host"));
        jPanel2.add((Component)jLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myPortNumberLabel = jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.manual.port"));
        jPanel2.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myProxyAuthCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 1, 2, 2));
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.manual.auth"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null, 2));
        this.myProxyLoginLabel = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("auth.login.label"));
        jPanel2.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 4));
        this.myProxyPasswordLabel = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("auth.password.label"));
        jPanel2.add((Component)jLabel5, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 4));
        RawCommandLineEditor rawCommandLineEditor = this.myProxyExceptions;
        rawCommandLineEditor.setDialogCaption(ResourceBundle.getBundle("messages/IdeBundle").getString("dialog.title.http.proxy.exceptions"));
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myNoProxyForLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.manual.exclude"));
        jPanel2.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(11, 0, 1, 1, 0, 2, 1, 7, null, null, null));
        this.myAutoDetectProxyRb = jBRadioButton5 = new JBRadioButton();
        this.$$$loadButtonText$$$(jBRadioButton5, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.pac.rb"));
        jBRadioButton5.setToolTipText(ResourceBundle.getBundle("messages/UIBundle").getString("proxy.pac.rb.tt"));
        jPanel.add((Component)jBRadioButton5, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseHTTPProxyRb = jBRadioButton4 = new JBRadioButton();
        this.$$$loadButtonText$$$(jBRadioButton4, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.manual.rb"));
        jPanel.add((Component)jBRadioButton4, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySystemProxyDefined = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.system.label"));
        jLabel3.setVerticalAlignment(0);
        jLabel3.setVerticalTextPosition(1);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNoProxyRb = jBRadioButton3 = new JBRadioButton();
        this.$$$loadButtonText$$$(jBRadioButton3, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.direct.rb"));
        jPanel.add((Component)jBRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(7, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myHTTP = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$(jBRadioButton2, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.manual.type.http"));
        jPanel3.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null, 2));
        this.mySocks = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$(jBRadioButton, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.manual.type.socks"));
        jPanel3.add((Component)jBRadioButton, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null, 2));
        this.myErrorLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel.add((Component)jLabel2, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCheckButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.test.button"));
        jPanel.add((Component)jButton2, new GridConstraints(9, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOtherWarning = jLabel = new JLabel();
        jLabel.setVerticalTextPosition(1);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPacUrlCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.pac.url.label"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myPacUrlTextField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myClearPasswordsButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle("messages/UIBundle", HttpProxySettingsUi.class).getString("proxy.pac.pw.clear.button"));
        jPanel.add((Component)jButton, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        jLabel8.setLabelFor(jTextField2);
        jLabel7.setLabelFor(portField);
        jLabel6.setLabelFor(jTextField3);
        jLabel5.setLabelFor(jPasswordField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/HttpProxySettingsUi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/HttpProxySettingsUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "errorText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "errorText";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

