/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.net.ssl.CertificateWrapper;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CertificateInfoPanel
extends JPanel {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    private final CertificateWrapper myCertificateWrapper;

    public CertificateInfoPanel(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateInfoPanel.$$$reportNull$$$0(0);
        }
        this.myCertificateWrapper = new CertificateWrapper(certificate);
        this.setLayout(new BorderLayout());
        FormBuilder builder2 = FormBuilder.createFormBuilder();
        CertificateInfoPanel.updateBuilderWithTitle(builder2, IdeBundle.message("section.title.issued.to", new Object[0]));
        CertificateInfoPanel.updateBuilderWithPrincipalData(builder2, this.myCertificateWrapper.getSubjectFields());
        CertificateInfoPanel.updateBuilderWithTitle(builder2, IdeBundle.message("section.title.issued.by", new Object[0]));
        CertificateInfoPanel.updateBuilderWithPrincipalData(builder2, this.myCertificateWrapper.getIssuerFields());
        CertificateInfoPanel.updateBuilderWithTitle(builder2, IdeBundle.message("section.title.validity.period", new Object[0]));
        String notBefore = DATE_FORMAT.format(this.myCertificateWrapper.getNotBefore());
        String notAfter = DATE_FORMAT.format(this.myCertificateWrapper.getNotAfter());
        builder2 = builder2.setFormLeftIndent(20).addLabeledComponent(IdeBundle.message("label.valid.from", new Object[0]), CertificateInfoPanel.createColoredComponent(notBefore, "not yet valid", this.myCertificateWrapper.isNotYetValid())).addLabeledComponent(IdeBundle.message("label.valid.until", new Object[0]), CertificateInfoPanel.createColoredComponent(notAfter, "expired", this.myCertificateWrapper.isExpired()));
        builder2.setFormLeftIndent(0);
        CertificateInfoPanel.updateBuilderWithTitle(builder2, IdeBundle.message("section.title.fingerprints", new Object[0]));
        builder2.setFormLeftIndent(20);
        builder2.addLabeledComponent("SHA-256:", CertificateInfoPanel.getTextPane(CertificateInfoPanel.formatHex(this.myCertificateWrapper.getSha256Fingerprint(), true)));
        builder2.addLabeledComponent("SHA-1:", CertificateInfoPanel.getTextPane(CertificateInfoPanel.formatHex(this.myCertificateWrapper.getSha1Fingerprint(), true)));
        this.add((Component)builder2.getPanel(), "North");
    }

    @NotNull
    public static String formatHex(@NotNull String hex, boolean split2) {
        if (hex == null) {
            CertificateInfoPanel.$$$reportNull$$$0(1);
        }
        if ("N/A".equals(hex)) {
            String string = hex;
            if (string == null) {
                CertificateInfoPanel.$$$reportNull$$$0(2);
            }
            return string;
        }
        StringBuilder builder2 = new StringBuilder();
        for (int i = 0; i < hex.length(); i += 2) {
            if (split2 && i == 32) {
                builder2.append('\n');
            }
            builder2.append(hex, i, i + 2);
            builder2.append(' ');
        }
        if (hex.length() > 0) {
            builder2.deleteCharAt(builder2.length() - 1);
        }
        String string = StringUtil.toUpperCase(builder2.toString());
        if (string == null) {
            CertificateInfoPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public X509Certificate getCertificate() {
        return this.myCertificateWrapper.getCertificate();
    }

    private static void updateBuilderWithPrincipalData(FormBuilder builder2, Map<String, String> fields) {
        builder2 = builder2.setFormLeftIndent(20);
        for (CertificateWrapper.CommonField field : CertificateWrapper.CommonField.values()) {
            String value2 = fields.get(field.getShortName());
            if (value2 == null) continue;
            String label2 = String.format("<html>%s (<b>%s</b>)</html>", field.getShortName(), field.getLongName());
            builder2 = builder2.addLabeledComponent(label2, (JComponent)new JBLabel(value2));
        }
        builder2.setFormLeftIndent(0);
    }

    private static void updateBuilderWithTitle(FormBuilder builder2, @Nls String title) {
        builder2.addComponent(new TitledSeparator(title), 7);
    }

    private static JComponent getTextPane(String text2) {
        JTextPane pane2 = new JTextPane();
        pane2.setOpaque(false);
        pane2.setEditable(false);
        pane2.setContentType("text/plain");
        pane2.setText(text2);
        return pane2;
    }

    private static JComponent createColoredComponent(String mainText, String errorText, boolean hasError) {
        SimpleColoredComponent component2 = new SimpleColoredComponent();
        if (hasError) {
            component2.append(mainText + " (" + errorText + ")", new SimpleTextAttributes(0, (Color)JBColor.RED));
        } else {
            component2.append(mainText);
        }
        return component2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hex";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/ssl/CertificateInfoPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/ssl/CertificateInfoPanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatHex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "formatHex";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

