/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.net.ssl.CertificateWrapper;
import com.intellij.util.ui.tree.TreeUtil;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CertificateTreeBuilder
extends AbstractTreeBuilder {
    private static final SimpleTextAttributes STRIKEOUT_ATTRIBUTES = new SimpleTextAttributes(4, null);
    private static final RootDescriptor ROOT_DESCRIPTOR = new RootDescriptor();
    private final MultiMap<String, CertificateWrapper> myCertificates;

    public CertificateTreeBuilder(@NotNull Tree tree) {
        if (tree == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(0);
        }
        this.myCertificates = new MultiMap();
        this.init(tree, new DefaultTreeModel(new DefaultMutableTreeNode()), new MyTreeStructure(), (o1, o2) -> {
            if (o1 instanceof OrganizationDescriptor && o2 instanceof OrganizationDescriptor) {
                return ((String)o1.getElement()).compareTo((String)o2.getElement());
            }
            if (o1 instanceof CertificateDescriptor && o2 instanceof CertificateDescriptor) {
                String cn1 = ((CertificateWrapper)((CertificateDescriptor)o1).getElement()).getSubjectField(CertificateWrapper.CommonField.COMMON_NAME);
                String cn2 = ((CertificateWrapper)((CertificateDescriptor)o2).getElement()).getSubjectField(CertificateWrapper.CommonField.COMMON_NAME);
                return cn1.compareTo(cn2);
            }
            return 0;
        }, true);
        this.initRootNode();
    }

    public void reset(@NotNull Collection<? extends X509Certificate> certificates) {
        if (certificates == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(1);
        }
        this.myCertificates.clear();
        for (X509Certificate x509Certificate : certificates) {
            this.addCertificate(x509Certificate);
        }
        this.queueUpdateFrom(RootDescriptor.ROOT, true).doWhenDone(() -> this.expandAll(null));
    }

    public void addCertificate(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(2);
        }
        CertificateWrapper wrapper2 = new CertificateWrapper(certificate);
        this.myCertificates.putValue(wrapper2.getSubjectField(CertificateWrapper.CommonField.ORGANIZATION), wrapper2);
        this.queueUpdateFrom(RootDescriptor.ROOT, true);
    }

    public void removeCertificate(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(3);
        }
        CertificateWrapper wrapper2 = new CertificateWrapper(certificate);
        this.myCertificates.remove(wrapper2.getSubjectField(CertificateWrapper.CommonField.ORGANIZATION), wrapper2);
        this.queueUpdateFrom(RootDescriptor.ROOT, true);
    }

    public List<X509Certificate> getCertificates() {
        return ContainerUtil.map(this.myCertificates.values(), wrapper2 -> wrapper2.getCertificate());
    }

    public boolean isEmpty() {
        return this.myCertificates.isEmpty();
    }

    public void selectCertificate(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(4);
        }
        this.select(new CertificateWrapper(certificate));
    }

    public void selectFirstCertificate() {
        JTree tree;
        JTree jTree = tree = this.isEmpty() ? null : this.getTree();
        if (tree != null) {
            TreeUtil.promiseSelectFirstLeaf(tree);
        }
    }

    @NotNull
    public Set<X509Certificate> getSelectedCertificates(boolean addFromOrganization) {
        Set<X509Certificate> selected2 = this.getSelectedElements(X509Certificate.class);
        if (addFromOrganization) {
            for (String s : this.getSelectedElements(String.class)) {
                selected2.addAll(this.getCertificatesByOrganization(s));
            }
        }
        Set<X509Certificate> set = selected2;
        if (set == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Nullable
    public X509Certificate getFirstSelectedCertificate(boolean addFromOrganization) {
        Set<X509Certificate> certificates = this.getSelectedCertificates(addFromOrganization);
        return certificates.isEmpty() ? null : certificates.iterator().next();
    }

    @NotNull
    public List<X509Certificate> getCertificatesByOrganization(@NotNull String organizationName) {
        if (organizationName == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(6);
        }
        Collection<CertificateWrapper> wrappers = this.myCertificates.get(organizationName);
        List<X509Certificate> list2 = CertificateTreeBuilder.extract(wrappers);
        if (list2 == null) {
            CertificateTreeBuilder.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private static List<X509Certificate> extract(Collection<CertificateWrapper> wrappers) {
        return ContainerUtil.map(wrappers, wrapper2 -> wrapper2.getCertificate());
    }

    @Override
    protected Object transformElement(Object object) {
        if (object instanceof CertificateWrapper) {
            return ((CertificateWrapper)object).getCertificate();
        }
        return object;
    }

    @Override
    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return super.isAutoExpandNode(nodeDescriptor) || nodeDescriptor instanceof OrganizationDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificates";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/ssl/CertificateTreeBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "organizationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/ssl/CertificateTreeBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedCertificates";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCertificatesByOrganization";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCertificate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeCertificate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectCertificate";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCertificatesByOrganization";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CertificateDescriptor
    extends MyNodeDescriptor<CertificateWrapper> {
        private CertificateDescriptor(@Nullable NodeDescriptor parentDescriptor, @NotNull CertificateWrapper object) {
            if (object == null) {
                CertificateDescriptor.$$$reportNull$$$0(0);
            }
            super(parentDescriptor, object);
        }

        @Override
        protected void update(@NotNull PresentationData presentation) {
            CertificateWrapper wrapper2;
            if (presentation == null) {
                CertificateDescriptor.$$$reportNull$$$0(1);
            }
            SimpleTextAttributes attr = (wrapper2 = (CertificateWrapper)this.getElement()).isValid() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : STRIKEOUT_ATTRIBUTES;
            presentation.addText(wrapper2.getSubjectField(CertificateWrapper.CommonField.COMMON_NAME), attr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/net/ssl/CertificateTreeBuilder$CertificateDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class OrganizationDescriptor
    extends MyNodeDescriptor<String> {
        private OrganizationDescriptor(@Nullable NodeDescriptor parentDescriptor, @NotNull String object) {
            if (object == null) {
                OrganizationDescriptor.$$$reportNull$$$0(0);
            }
            super(parentDescriptor, object);
        }

        @Override
        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                OrganizationDescriptor.$$$reportNull$$$0(1);
            }
            presentation.addText((String)this.getElement(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/net/ssl/CertificateTreeBuilder$OrganizationDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class RootDescriptor
    extends MyNodeDescriptor<Object> {
        public static final Object ROOT = new Object();

        private RootDescriptor() {
            super(null, ROOT);
        }

        @Override
        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                RootDescriptor.$$$reportNull$$$0(0);
            }
            presentation.addText("<root>", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/util/net/ssl/CertificateTreeBuilder$RootDescriptor", "update"));
        }
    }

    static abstract class MyNodeDescriptor<T>
    extends PresentableNodeDescriptor<T> {
        private final T myObject;

        MyNodeDescriptor(@Nullable NodeDescriptor parentDescriptor, @NotNull T object) {
            if (object == null) {
                MyNodeDescriptor.$$$reportNull$$$0(0);
            }
            super((Project)null, parentDescriptor);
            this.myObject = object;
        }

        @Override
        public T getElement() {
            return this.myObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/net/ssl/CertificateTreeBuilder$MyNodeDescriptor", "<init>"));
        }
    }

    class MyTreeStructure
    extends AbstractTreeStructure {
        MyTreeStructure() {
        }

        @Override
        @NotNull
        public Object getRootElement() {
            Object object = RootDescriptor.ROOT;
            if (object == null) {
                MyTreeStructure.$$$reportNull$$$0(0);
            }
            return object;
        }

        @Override
        public Object @NotNull [] getChildElements(@NotNull Object element2) {
            if (element2 == null) {
                MyTreeStructure.$$$reportNull$$$0(1);
            }
            if (element2 == RootDescriptor.ROOT) {
                Object[] objectArray = ArrayUtilRt.toStringArray(CertificateTreeBuilder.this.myCertificates.keySet());
                if (objectArray == null) {
                    MyTreeStructure.$$$reportNull$$$0(2);
                }
                return objectArray;
            }
            if (element2 instanceof String) {
                Object[] objectArray = ArrayUtil.toObjectArray(CertificateTreeBuilder.this.myCertificates.get((String)element2));
                if (objectArray == null) {
                    MyTreeStructure.$$$reportNull$$$0(3);
                }
                return objectArray;
            }
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                MyTreeStructure.$$$reportNull$$$0(4);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @Nullable
        public Object getParentElement(@NotNull Object element2) {
            if (element2 == null) {
                MyTreeStructure.$$$reportNull$$$0(5);
            }
            if (element2 == RootDescriptor.ROOT) {
                return null;
            }
            if (element2 instanceof String) {
                return RootDescriptor.ROOT;
            }
            return ((CertificateWrapper)element2).getSubjectField(CertificateWrapper.CommonField.ORGANIZATION);
        }

        @Override
        @NotNull
        public NodeDescriptor createDescriptor(@NotNull Object element2, NodeDescriptor parentDescriptor) {
            if (element2 == null) {
                MyTreeStructure.$$$reportNull$$$0(6);
            }
            if (element2 == RootDescriptor.ROOT) {
                RootDescriptor rootDescriptor = ROOT_DESCRIPTOR;
                if (rootDescriptor == null) {
                    MyTreeStructure.$$$reportNull$$$0(7);
                }
                return rootDescriptor;
            }
            if (element2 instanceof String) {
                return new OrganizationDescriptor(parentDescriptor, (String)element2);
            }
            return new CertificateDescriptor(parentDescriptor, (CertificateWrapper)element2);
        }

        @Override
        public void commit() {
        }

        @Override
        public boolean hasSomethingToCommit() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/net/ssl/CertificateTreeBuilder$MyTreeStructure";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootElement";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/net/ssl/CertificateTreeBuilder$MyTreeStructure";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildElements";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildElements";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getParentElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

