/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.pico.InstantiatingComponentAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.CyclicDependencyException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public final class CachingConstructorInjectionComponentAdapter
extends InstantiatingComponentAdapter {
    private static final ThreadLocal<Set<CachingConstructorInjectionComponentAdapter>> ourGuard = new ThreadLocal();
    private Object myInstance;

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses) throws AssignabilityRegistrationException {
        if (componentKey == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(0);
        }
        if (componentImplementation == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(1);
        }
        super(componentKey, componentImplementation, parameters, allowNonPublicClasses);
    }

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters) {
        if (componentKey == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(2);
        }
        if (componentImplementation == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(3);
        }
        this(componentKey, componentImplementation, parameters, false);
    }

    public CachingConstructorInjectionComponentAdapter(@NotNull Object componentKey, @NotNull Class componentImplementation) throws AssignabilityRegistrationException {
        if (componentKey == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(4);
        }
        if (componentImplementation == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(5);
        }
        this(componentKey, componentImplementation, null);
    }

    @Override
    public Object getComponentInstance(@NotNull PicoContainer container2) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException {
        Object instance2;
        if (container2 == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(6);
        }
        if ((instance2 = this.myInstance) == null) {
            this.myInstance = instance2 = this.instantiateGuarded(container2, this.getComponentImplementation());
        }
        return instance2;
    }

    @NotNull
    private Object instantiateGuarded(@NotNull PicoContainer container2, @NotNull Class<?> stackFrame) {
        Object object;
        Set<CachingConstructorInjectionComponentAdapter> currentStack;
        if (container2 == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(7);
        }
        if (stackFrame == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(8);
        }
        if ((currentStack = ourGuard.get()) == null) {
            currentStack = ContainerUtil.newIdentityTroveSet();
            ourGuard.set(currentStack);
        }
        if (currentStack.contains(this)) {
            throw new CyclicDependencyException(stackFrame);
        }
        try {
            currentStack.add(this);
            Object object2 = this.doGetComponentInstance(container2);
            object = object2;
        }
        catch (CyclicDependencyException e) {
            e.push(stackFrame);
            throw e;
        }
        finally {
            currentStack.remove(this);
        }
        if (object == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(9);
        }
        return object;
    }

    @NotNull
    private Object doGetComponentInstance(@NotNull PicoContainer guardedContainer) {
        Object object;
        Constructor<?> constructor2;
        if (guardedContainer == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(10);
        }
        try {
            constructor2 = this.getGreediestSatisfiableConstructor(guardedContainer);
        }
        catch (AmbiguousComponentResolutionException e) {
            e.setComponent(this.getComponentImplementation());
            throw e;
        }
        try {
            object = this.newInstance(constructor2, this.getConstructorArguments(guardedContainer, constructor2));
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.rethrowUnchecked(e.getTargetException());
            throw new PicoInvocationTargetInitializationException(e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new PicoInitializationException("Should never get here");
        }
        catch (IllegalAccessException e) {
            throw new PicoInitializationException(e);
        }
        if (object == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(11);
        }
        return object;
    }

    private Object @NotNull [] getConstructorArguments(PicoContainer container2, @NotNull Constructor<?> ctor) {
        if (ctor == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(12);
        }
        if (ctor.getParameterCount() == 0) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(13);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        Class<?>[] parameterTypes = ctor.getParameterTypes();
        Object[] result2 = new Object[parameterTypes.length];
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
        for (int i = 0; i < currentParameters.length; ++i) {
            result2[i] = currentParameters[i].resolveInstance(container2, this, parameterTypes[i]);
        }
        if (result2 == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(14);
        }
        return result2;
    }

    @NotNull
    private Constructor<?> getGreediestSatisfiableConstructor(@NotNull PicoContainer container2) throws PicoIntrospectionException, AssignabilityRegistrationException {
        if (container2 == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(15);
        }
        HashSet conflicts = new HashSet();
        HashSet unsatisfiableDependencyTypes = new HashSet();
        List<Constructor<?>> sortedMatchingConstructors = this.getSortedMatchingConstructors();
        Constructor<?> greediestConstructor = null;
        int lastSatisfiableConstructorSize = -1;
        Class<?> unsatisfiedDependencyType = null;
        for (Constructor<?> constructor2 : sortedMatchingConstructors) {
            if (constructor2.isSynthetic() || CachingConstructorInjectionComponentAdapter.isNonInjectable(constructor2)) continue;
            boolean failedDependency = false;
            Class<?>[] parameterTypes = constructor2.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
            for (int j = 0; j < currentParameters.length; ++j) {
                if (currentParameters[j].isResolvable(container2, this, parameterTypes[j])) continue;
                unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                unsatisfiedDependencyType = parameterTypes[j];
                failedDependency = true;
                break;
            }
            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                if (conflicts.isEmpty()) {
                    Constructor<?> constructor3 = greediestConstructor;
                    if (constructor3 == null) {
                        CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(16);
                    }
                    return constructor3;
                }
                conflicts.add(constructor2);
                continue;
            }
            if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                conflicts.add(constructor2);
                conflicts.add(greediestConstructor);
                continue;
            }
            if (failedDependency) continue;
            greediestConstructor = constructor2;
            lastSatisfiableConstructorSize = parameterTypes.length;
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(conflicts);
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new UnsatisfiableDependenciesException(this, unsatisfiedDependencyType, unsatisfiableDependencyTypes, container2);
        }
        if (greediestConstructor == null) {
            HashSet<Constructor<?>> nonMatching = ContainerUtil.newHashSet(this.getConstructors());
            throw new PicoInitializationException("Either do the specified parameters not match any of the following constructors: " + nonMatching + " or the constructors were not accessible for '" + this.getComponentImplementation() + "'");
        }
        Constructor<?> constructor4 = greediestConstructor;
        if (constructor4 == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(17);
        }
        return constructor4;
    }

    private static boolean isNonInjectable(@NotNull Constructor<?> constructor2) {
        if (constructor2 == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(18);
        }
        for (Annotation o : constructor2.getAnnotations()) {
            String name = o.annotationType().getName();
            if (!"com.intellij.serviceContainer.NonInjectable".equals(name) && !"java.lang.Deprecated".equals(name)) continue;
            return true;
        }
        return false;
    }

    private List<Constructor<?>> getSortedMatchingConstructors() {
        ArrayList matchingConstructors = new ArrayList();
        for (Constructor<?> constructor2 : this.getConstructors()) {
            if (this.parameters != null && constructor2.getParameterCount() != this.parameters.length || !this.allowNonPublicClasses && (constructor2.getModifiers() & 1) == 0) continue;
            matchingConstructors.add(constructor2);
        }
        if (this.parameters == null) {
            matchingConstructors.sort((arg0, arg1) -> arg1.getParameterCount() - arg0.getParameterCount());
        }
        return matchingConstructors;
    }

    private Constructor<?> @NotNull [] getConstructors() {
        Constructor[] constructorArray = AccessController.doPrivileged(() -> this.getComponentImplementation().getDeclaredConstructors());
        if (constructorArray == null) {
            CachingConstructorInjectionComponentAdapter.$$$reportNull$$$0(19);
        }
        return constructorArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentImplementation";
                break;
            }
            case 6: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrame";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/pico/CachingConstructorInjectionComponentAdapter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guardedContainer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/pico/CachingConstructorInjectionComponentAdapter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateGuarded";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetComponentInstance";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorArguments";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGreediestSatisfiableConstructor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstance";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "instantiateGuarded";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGetComponentInstance";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorArguments";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getGreediestSatisfiableConstructor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isNonInjectable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

