/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.defaults.AbstractComponentAdapter;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.ThreadLocalCyclicDependencyGuard;

abstract class InstantiatingComponentAdapter
extends AbstractComponentAdapter {
    protected transient Parameter[] parameters;
    protected boolean allowNonPublicClasses;

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses) {
        super(componentKey, componentImplementation);
        this.checkConcrete();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] != null) continue;
                throw new NullPointerException("Parameter " + i + " is null");
            }
        }
        this.parameters = parameters;
        this.allowNonPublicClasses = allowNonPublicClasses;
    }

    private void checkConcrete() {
        boolean isAbstract;
        Class<?> componentImplementation = this.getComponentImplementation();
        boolean bl = isAbstract = (componentImplementation.getModifiers() & 0x400) == 1024;
        if (componentImplementation.isInterface() || isAbstract) {
            throw new PicoRegistrationException("Bad Access: '" + componentImplementation.getName() + "' is not instantiable");
        }
    }

    protected Parameter[] createDefaultParameters(Class<?>[] parameters) {
        Parameter[] componentParameters = new Parameter[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            componentParameters[i] = ComponentParameter.DEFAULT;
        }
        return componentParameters;
    }

    protected Object newInstance(Constructor<?> constructor2, Object[] parameters) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.allowNonPublicClasses) {
            constructor2.setAccessible(true);
        }
        return constructor2.newInstance(parameters);
    }

    protected static abstract class Guard
    extends ThreadLocalCyclicDependencyGuard {
        protected PicoContainer guardedContainer;

        protected Guard() {
        }

        protected void setArguments(PicoContainer container2) {
            this.guardedContainer = container2;
        }
    }
}

