/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.progress;

import com.google.common.util.concurrent.AtomicDouble;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ConcurrentTasksProgressManager {
    private final ProgressIndicator myParent;
    private final int myTotalWeight;
    private final AtomicDouble myTotalFraction;
    private final Object myLock = new Object();
    private final LinkedHashMap<SubTaskProgressIndicator, String> myText2Stack = new LinkedHashMap();
    private final AtomicInteger myRemainingTotalWeight;

    public ConcurrentTasksProgressManager(ProgressIndicator parent, int totalWeight) {
        if (totalWeight <= 0) {
            throw new IllegalArgumentException("Total weight must be a positive number: " + totalWeight);
        }
        this.myParent = parent;
        this.myTotalWeight = totalWeight;
        this.myTotalFraction = new AtomicDouble();
        this.myRemainingTotalWeight = new AtomicInteger(totalWeight);
    }

    @NotNull
    public SubTaskProgressIndicator createSubTaskIndicator(int taskWeight) {
        if (taskWeight <= 0) {
            throw new IllegalArgumentException("Task weight must be a positive number: " + taskWeight);
        }
        if (this.myRemainingTotalWeight.addAndGet(-taskWeight) < 0) {
            throw new IllegalStateException("Attempted to create more task indicators than registered in constructor");
        }
        return new SubTaskProgressIndicator(this, taskWeight);
    }

    @NotNull
    ProgressIndicator getParent() {
        ProgressIndicator progressIndicator2 = this.myParent;
        if (progressIndicator2 == null) {
            ConcurrentTasksProgressManager.$$$reportNull$$$0(0);
        }
        return progressIndicator2;
    }

    void updateTaskFraction(double taskDeltaFraction, int taskWeight) {
        double newFraction = this.myTotalFraction.addAndGet(taskDeltaFraction * (double)taskWeight / (double)this.myTotalWeight);
        this.myParent.setFraction(newFraction);
    }

    public void setText(@NotNull String text2) {
        if (text2 == null) {
            ConcurrentTasksProgressManager.$$$reportNull$$$0(1);
        }
        this.myParent.setText(text2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setText2(@NotNull SubTaskProgressIndicator subTask, @Nullable String text2) {
        if (subTask == null) {
            ConcurrentTasksProgressManager.$$$reportNull$$$0(2);
        }
        if (text2 != null) {
            Object object = this.myLock;
            synchronized (object) {
                this.myText2Stack.put(subTask, text2);
            }
            this.myParent.setText2(text2);
        } else {
            String prev;
            Object object = this.myLock;
            synchronized (object) {
                this.myText2Stack.remove(subTask);
                prev = this.myText2Stack.getLastValue();
            }
            if (prev != null) {
                this.myParent.setText2(prev);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/progress/ConcurrentTasksProgressManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/progress/ConcurrentTasksProgressManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setText2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

