/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.progress;

import com.google.common.util.concurrent.AtomicDouble;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class SubTaskProgressIndicator
extends SensitiveProgressWrapper {
    private final ConcurrentTasksProgressManager myProgressManager;
    private final AtomicDouble myFraction;
    private final int myTaskWeight;

    SubTaskProgressIndicator(ConcurrentTasksProgressManager progressManager, int taskWeight) {
        super(progressManager.getParent());
        this.myProgressManager = progressManager;
        this.myTaskWeight = taskWeight;
        this.myFraction = new AtomicDouble();
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
    }

    @Override
    public void setText(String text2) {
        this.myProgressManager.setText2(this, text2);
    }

    @Override
    public void setFraction(double newValue) {
        double oldValue = this.myFraction.getAndSet(newValue);
        this.myProgressManager.updateTaskFraction(newValue - oldValue, this.myTaskWeight);
    }

    @Override
    public void setText2(String text2) {
    }

    @Override
    public double getFraction() {
        return this.myFraction.get();
    }

    public void finished() {
        this.setFraction(1.0);
        this.myProgressManager.setText2(this, null);
    }
}

