/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.Nullable;

public class TextRanges
implements Iterable<TextRange> {
    private static final Comparator<TextRange> START_COMP = (o1, o2) -> Comparing.compare(o1.getStartOffset(), o2.getStartOffset());
    private static final Comparator<TextRange> END_COMP = (o1, o2) -> Comparing.compare(o1.getEndOffset(), o2.getEndOffset());
    private final List<TextRange> myRanges = new ArrayList<TextRange>();

    public TextRanges union(@Nullable TextRange range2) {
        int endIdx;
        if (range2 == null || range2.isEmpty()) {
            return this;
        }
        int startIdx = Collections.binarySearch(this.myRanges, TextRange.from(range2.getStartOffset(), 0), END_COMP);
        if (startIdx == (endIdx = Collections.binarySearch(this.myRanges, TextRange.from(range2.getEndOffset(), 0), START_COMP))) {
            assert (startIdx < 0);
            this.myRanges.add(-startIdx - 1, range2);
            return this;
        }
        if (startIdx < 0) {
            startIdx = -startIdx - 1;
        }
        if (endIdx < 0) {
            endIdx = -endIdx - 1;
        }
        List<TextRange> covered = this.myRanges.subList(startIdx, endIdx);
        TextRange newRange = new TextRange(Math.min(range2.getStartOffset(), covered.get(0).getStartOffset()), Math.max(range2.getEndOffset(), covered.get(covered.size() - 1).getEndOffset()));
        covered.clear();
        covered.add(newRange);
        return this;
    }

    @Override
    public Iterator<TextRange> iterator() {
        return new UnmodifiableIterator<TextRange>(this.myRanges.iterator());
    }

    public Iterator<TextRange> revIterator() {
        return new Iterator<TextRange>(){
            private final ListIterator<TextRange> it;
            {
                this.it = TextRanges.this.myRanges.listIterator(TextRanges.this.myRanges.size());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasPrevious();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public TextRange next() {
                return this.it.previous();
            }
        };
    }

    public Iterator<TextRange> gapIterator() {
        return TextRanges.gapIterator(this.iterator());
    }

    public Iterator<TextRange> revGapIterator() {
        return TextRanges.gapIterator(this.revIterator());
    }

    private static Iterator<TextRange> gapIterator(final Iterator<TextRange> base) {
        return new Iterator<TextRange>(){
            private final Iterator<TextRange> myIt;
            private TextRange myPrev;
            {
                this.myIt = base;
                this.myPrev = this.myIt.hasNext() ? this.myIt.next() : null;
            }

            @Override
            public boolean hasNext() {
                return this.myPrev != null && this.myIt.hasNext();
            }

            @Override
            public TextRange next() {
                TextRange cur = this.myIt.next();
                TextRange res2 = TextRange.create(this.myPrev.getEndOffset(), cur.getStartOffset());
                this.myPrev = cur;
                return res2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isEmpty() {
        return this.myRanges.isEmpty();
    }
}

