/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlCharsetDetector {
    @NonNls
    private static final String XML_PROLOG_START = "<?xml";
    @NonNls
    private static final byte[] XML_PROLOG_START_BYTES = CharsetToolkit.getUtf8Bytes("<?xml");
    @NonNls
    private static final String ENCODING = "encoding";
    @NonNls
    private static final byte[] ENCODING_BYTES = CharsetToolkit.getUtf8Bytes("encoding");
    @NonNls
    private static final String XML_PROLOG_END = "?>";
    @NonNls
    private static final byte[] XML_PROLOG_END_BYTES = CharsetToolkit.getUtf8Bytes("?>");

    @Nullable
    public static String extractXmlEncodingFromProlog(byte @NotNull [] bytes) {
        if (bytes == null) {
            XmlCharsetDetector.$$$reportNull$$$0(0);
        }
        int index = 0;
        if (CharsetToolkit.hasUTF8Bom(bytes)) {
            index = CharsetToolkit.UTF8_BOM.length;
        }
        if (!ArrayUtil.startsWith(bytes, index = XmlCharsetDetector.skipWhiteSpace(index, bytes), XML_PROLOG_START_BYTES)) {
            return null;
        }
        index += XML_PROLOG_START_BYTES.length;
        while (index < bytes.length) {
            if (ArrayUtil.startsWith(bytes, index = XmlCharsetDetector.skipWhiteSpace(index, bytes), XML_PROLOG_END_BYTES)) {
                return null;
            }
            if (ArrayUtil.startsWith(bytes, index, ENCODING_BYTES)) {
                index += ENCODING_BYTES.length;
                if ((index = XmlCharsetDetector.skipWhiteSpace(index, bytes)) >= bytes.length || bytes[index] != 61) continue;
                ++index;
                if ((index = XmlCharsetDetector.skipWhiteSpace(index, bytes)) >= bytes.length || bytes[index] != 39 && bytes[index] != 34) continue;
                byte quote = bytes[index];
                ++index;
                StringBuilder encoding = new StringBuilder();
                while (index < bytes.length) {
                    if (bytes[index] == quote) {
                        return encoding.toString();
                    }
                    encoding.append((char)bytes[index++]);
                }
            }
            ++index;
        }
        return null;
    }

    @Nullable
    public static String extractXmlEncodingFromProlog(@NotNull CharSequence text2) {
        if (text2 == null) {
            XmlCharsetDetector.$$$reportNull$$$0(1);
        }
        int index = 0;
        if (!StringUtil.startsWith(text2, index = XmlCharsetDetector.skipWhiteSpace(index, text2), XML_PROLOG_START)) {
            return null;
        }
        index += XML_PROLOG_START.length();
        while (index < text2.length()) {
            if (StringUtil.startsWith(text2, index = XmlCharsetDetector.skipWhiteSpace(index, text2), XML_PROLOG_END)) {
                return null;
            }
            if (StringUtil.startsWith(text2, index, ENCODING)) {
                char quote;
                index += ENCODING.length();
                if ((index = XmlCharsetDetector.skipWhiteSpace(index, text2)) >= text2.length() || text2.charAt(index) != '=') continue;
                ++index;
                if ((index = XmlCharsetDetector.skipWhiteSpace(index, text2)) >= text2.length() || (quote = text2.charAt(index)) != '\'' && quote != '\"') continue;
                ++index;
                StringBuilder encoding = new StringBuilder();
                while (index < text2.length()) {
                    char c = text2.charAt(index);
                    if (c == quote) {
                        return encoding.toString();
                    }
                    encoding.append(c);
                    ++index;
                }
            }
            ++index;
        }
        return null;
    }

    private static int skipWhiteSpace(int start2, byte @NotNull [] bytes) {
        char c;
        if (bytes == null) {
            XmlCharsetDetector.$$$reportNull$$$0(2);
        }
        while (start2 < bytes.length && Character.isWhitespace(c = (char)bytes[start2])) {
            ++start2;
        }
        return start2;
    }

    private static int skipWhiteSpace(int start2, @NotNull CharSequence text2) {
        char c;
        if (text2 == null) {
            XmlCharsetDetector.$$$reportNull$$$0(3);
        }
        while (start2 < text2.length() && Character.isWhitespace(c = text2.charAt(start2))) {
            ++start2;
        }
        return start2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/text/XmlCharsetDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extractXmlEncodingFromProlog";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "skipWhiteSpace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

