/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.textCompletion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValuesCompletionProvider<T>
implements TextCompletionProvider {
    @NotNull
    protected final TextCompletionValueDescriptor<T> myDescriptor;
    @NotNull
    private final List<Character> mySeparators;
    @NotNull
    protected final Collection<? extends T> myValues;
    private final boolean myCaseSensitive;
    @NotNull
    private final InsertHandler<LookupElement> myInsertHandler;

    public ValuesCompletionProvider(@NotNull TextCompletionValueDescriptor<T> descriptor2, @NotNull List<Character> separators, @NotNull Collection<? extends T> values2, boolean caseSensitive) {
        if (descriptor2 == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(0);
        }
        if (separators == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(1);
        }
        if (values2 == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(2);
        }
        this.myInsertHandler = new CompletionCharInsertHandler();
        this.myDescriptor = descriptor2;
        this.mySeparators = separators;
        this.myValues = values2;
        this.myCaseSensitive = caseSensitive;
    }

    public ValuesCompletionProvider(@NotNull TextCompletionValueDescriptor<T> presentation, @NotNull Collection<? extends T> values2) {
        if (presentation == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(3);
        }
        if (values2 == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(4);
        }
        this(presentation, Collections.emptyList(), values2, false);
    }

    @Override
    @Nullable
    public String getAdvertisement() {
        return "";
    }

    @Override
    @Nullable
    public String getPrefix(@NotNull String text2, int offset) {
        if (text2 == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(5);
        }
        return ValuesCompletionProvider.getPrefix(text2, offset, this.mySeparators);
    }

    @NotNull
    protected static String getPrefix(@NotNull String text2, int offset, @NotNull Collection<Character> separators) {
        if (text2 == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(6);
        }
        if (separators == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(7);
        }
        int index = -1;
        for (char c : separators) {
            index = Math.max(text2.lastIndexOf(c, offset - 1), index);
        }
        String string = text2.substring(index + 1, offset);
        if (string == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        if (result2 == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(9);
        }
        if (prefix == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(10);
        }
        CompletionResultSet resultWithMatcher = result2.withPrefixMatcher(new PlainPrefixMatcher(prefix));
        if (!this.myCaseSensitive) {
            resultWithMatcher = resultWithMatcher.caseInsensitive();
        }
        CompletionResultSet completionResultSet = resultWithMatcher;
        if (completionResultSet == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(11);
        }
        return completionResultSet;
    }

    @Override
    @Nullable
    public CharFilter.Result acceptChar(char c) {
        if (!this.mySeparators.contains(Character.valueOf(c))) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        return CharFilter.Result.HIDE_LOOKUP;
    }

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(12);
        }
        if (prefix == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(14);
        }
        Collection<T> values2 = this.getValues(prefix, result2);
        values2 = ContainerUtil.sorted(values2, this.myDescriptor);
        for (T completionVariant : values2) {
            result2.addElement(this.installInsertHandler(this.myDescriptor.createLookupBuilder(completionVariant)));
        }
        result2.stopHere();
    }

    @NotNull
    protected LookupElement installInsertHandler(@NotNull LookupElementBuilder builder2) {
        InsertHandler<LookupElement> handler2;
        if (builder2 == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(15);
        }
        if ((handler2 = builder2.getInsertHandler()) == null) {
            LookupElementBuilder lookupElementBuilder = builder2.withInsertHandler(this.myInsertHandler);
            if (lookupElementBuilder == null) {
                ValuesCompletionProvider.$$$reportNull$$$0(16);
            }
            return lookupElementBuilder;
        }
        LookupElementBuilder lookupElementBuilder = builder2.withInsertHandler(new InsertHandler<LookupElement>(){

            @Override
            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                ValuesCompletionProvider.this.myInsertHandler.handleInsert(context, item);
                handler2.handleInsert(context, item);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/textCompletion/ValuesCompletionProvider$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (lookupElementBuilder == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(17);
        }
        return lookupElementBuilder;
    }

    @NotNull
    protected Collection<? extends T> getValues(@NotNull String prefix, @NotNull CompletionResultSet result2) {
        if (prefix == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(18);
        }
        if (result2 == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(19);
        }
        Collection<? extends T> collection = this.myValues;
        if (collection == null) {
            ValuesCompletionProvider.$$$reportNull$$$0(20);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/textCompletion/ValuesCompletionProvider";
                break;
            }
            case 9: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/textCompletion/ValuesCompletionProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPrefixMatcher";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "installInsertHandler";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyPrefixMatcher";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "installInsertHandler";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ValuesCompletionProviderDumbAware<T>
    extends ValuesCompletionProvider<T>
    implements DumbAware {
        public ValuesCompletionProviderDumbAware(@NotNull TextCompletionValueDescriptor<T> descriptor2, @NotNull List<Character> separators, @NotNull Collection<? extends T> values2, boolean caseSensitive) {
            if (descriptor2 == null) {
                ValuesCompletionProviderDumbAware.$$$reportNull$$$0(0);
            }
            if (separators == null) {
                ValuesCompletionProviderDumbAware.$$$reportNull$$$0(1);
            }
            if (values2 == null) {
                ValuesCompletionProviderDumbAware.$$$reportNull$$$0(2);
            }
            super(descriptor2, separators, values2, caseSensitive);
        }

        public ValuesCompletionProviderDumbAware(@NotNull TextCompletionValueDescriptor<T> presentation, @NotNull Collection<? extends T> values2) {
            if (presentation == null) {
                ValuesCompletionProviderDumbAware.$$$reportNull$$$0(3);
            }
            if (values2 == null) {
                ValuesCompletionProviderDumbAware.$$$reportNull$$$0(4);
            }
            super(presentation, values2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "separators";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "values";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "presentation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/textCompletion/ValuesCompletionProvider$ValuesCompletionProviderDumbAware";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class CompletionCharInsertHandler
    implements InsertHandler<LookupElement> {
        @Override
        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                CompletionCharInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                CompletionCharInsertHandler.$$$reportNull$$$0(1);
            }
            context.setAddCompletionChar(ValuesCompletionProvider.this.mySeparators.contains(Character.valueOf(context.getCompletionChar())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/textCompletion/ValuesCompletionProvider$CompletionCharInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

