/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.GraphicsEnvironment;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public abstract class Animator
implements Disposable {
    private final String myName;
    private final int myTotalFrames;
    private final int myCycleDuration;
    private final boolean myForward;
    private final boolean myRepeatable;
    private ScheduledFuture<?> myTicker;
    private int myCurrentFrame;
    private long myStartTime;
    private long myStartDeltaTime;
    private boolean myInitialStep;
    private volatile boolean myDisposed;

    public Animator(@NonNls String name, int totalFrames, int cycleDuration, boolean repeatable) {
        this(name, totalFrames, cycleDuration, repeatable, true);
    }

    public Animator(@NonNls String name, int totalFrames, int cycleDuration, boolean repeatable, boolean forward) {
        this.myName = name;
        this.myTotalFrames = totalFrames;
        this.myCycleDuration = cycleDuration;
        this.myRepeatable = repeatable;
        this.myForward = forward;
        this.reset();
        if (Animator.skipAnimation()) {
            this.animationDone();
        }
    }

    private void onTick() {
        if (this.isDisposed()) {
            return;
        }
        if (this.myInitialStep) {
            this.myInitialStep = false;
            this.myStartTime = System.currentTimeMillis() - this.myStartDeltaTime;
            this.paint();
            return;
        }
        double cycleTime = System.currentTimeMillis() - this.myStartTime;
        if (cycleTime < 0.0) {
            return;
        }
        long newFrame = (long)(cycleTime * (double)this.myTotalFrames / (double)this.myCycleDuration);
        if (this.myRepeatable) {
            newFrame %= (long)this.myTotalFrames;
        }
        if (newFrame == (long)this.myCurrentFrame) {
            return;
        }
        if (!this.myRepeatable && newFrame >= (long)this.myTotalFrames) {
            this.animationDone();
            return;
        }
        this.myCurrentFrame = (int)newFrame;
        this.paint();
    }

    private void paint() {
        this.paintNow(this.myForward ? this.myCurrentFrame : this.myTotalFrames - this.myCurrentFrame - 1, this.myTotalFrames, this.myCycleDuration);
    }

    private void animationDone() {
        this.stopTicker();
        if (!this.isDisposed()) {
            SwingUtilities.invokeLater(this::paintCycleEnd);
        }
    }

    private void stopTicker() {
        if (this.myTicker != null) {
            this.myTicker.cancel(false);
            this.myTicker = null;
        }
    }

    protected void paintCycleEnd() {
    }

    public void suspend() {
        this.myStartDeltaTime = System.currentTimeMillis() - this.myStartTime;
        this.myInitialStep = true;
        this.stopTicker();
    }

    public void resume() {
        if (this.isDisposed()) {
            this.stopTicker();
            return;
        }
        if (Animator.skipAnimation()) {
            this.animationDone();
            return;
        }
        if (this.myCycleDuration == 0) {
            this.myCurrentFrame = this.myTotalFrames - 1;
            this.paint();
            this.animationDone();
        } else if (this.myTicker == null) {
            this.myTicker = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    Animator.this.onTick();
                }

                public String toString() {
                    return "Scheduled " + Animator.this;
                }
            }, 0L, (long)this.myCycleDuration * 1000L / (long)this.myTotalFrames, TimeUnit.MICROSECONDS);
        }
    }

    private static boolean skipAnimation() {
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    public abstract void paintNow(int var1, int var2, int var3);

    @Override
    public void dispose() {
        this.stopTicker();
        this.myDisposed = true;
    }

    public boolean isRunning() {
        return this.myTicker != null;
    }

    public void reset() {
        this.myCurrentFrame = 0;
        this.myStartDeltaTime = 0L;
        this.myInitialStep = true;
    }

    public final boolean isForward() {
        return this.myForward;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public String toString() {
        ScheduledFuture<?> future2 = this.myTicker;
        return "Animator '" + this.myName + "' @" + System.identityHashCode(this) + (future2 == null || future2.isDone() ? " (stopped)" : " (running " + this.myCurrentFrame + "/" + this.myTotalFrames + " frame)");
    }
}

