/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NSScrollerHelper;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class ButtonlessScrollBarUI
extends BasicScrollBarUI {
    private static final Logger LOG = Logger.getInstance(ButtonlessScrollBarUI.class);
    private final AdjustmentListener myAdjustmentListener;
    private final MouseMotionAdapter myMouseMotionListener;
    private final MouseAdapter myMouseListener;
    private final HierarchyListener myHierarchyListener;
    private final AWTEventListener myAWTMouseListener;
    private final AWTEventListener myWeakListener;
    private final NSScrollerHelper.ScrollbarStyleListener myNSScrollerListener;
    private boolean myGlobalListenersAdded;
    private static final int DELAY_FRAMES = 4;
    private static final int FRAMES_COUNT = 14;
    private Animator myThumbFadeAnimator;
    private int myThumbFadeColorShift;
    private boolean myMouseIsOverThumb;
    private boolean myMouseOverScrollbar;
    private double myMouseOverScrollbarExpandLevel;
    private NSScrollerHelper.Style myMacScrollerStyle;
    private Animator myMouseOverScrollbarExpandAnimator;
    private Alarm myMacScrollbarFadeTimer;
    private Animator myMacScrollbarFadeAnimator;
    private double myMacScrollbarFadeLevel;
    private boolean myMacScrollbarHidden;
    private final RegionPainter<Float> myThumbPainter = JBScrollPane.getThumbPainter(() -> this.scrollbar);
    private ScrollbarRepaintCallback myRepaintCallback;
    private boolean myDisposed;
    private static final Method setValueFrom = ReflectionUtil.getDeclaredMethod(BasicScrollBarUI.TrackListener.class, "setValueFrom", MouseEvent.class);

    @Deprecated
    public static JBColor getTrackBackgroundDefault() {
        return new JBColor(LightColors.SLIGHTLY_GRAY, UIUtil.getListBackground());
    }

    @Deprecated
    public static JBColor getTrackBorderColorDefault() {
        return new JBColor(Gray._230, UIUtil.getListBackground());
    }

    private JBColor getTrackBackground() {
        return this.jbColor(LightColors.SLIGHTLY_GRAY, UIUtil.getListBackground());
    }

    private JBColor getTrackBorderColor() {
        return this.jbColor(Gray._230, UIUtil.getListBackground());
    }

    private JBColor jbColor(Color regular, Color dark) {
        return new JBColor(() -> this.isDark() ? dark : regular);
    }

    private int getAnimationColorShift() {
        return this.isDark() ? 20 : 40;
    }

    protected ButtonlessScrollBarUI() {
        this.myAdjustmentListener = new AdjustmentListener(){
            Point oldViewportPosition;
            Dimension oldViewportDimension;

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JViewport viewport;
                JScrollPane scrollpane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, ButtonlessScrollBarUI.this.scrollbar);
                JViewport jViewport = viewport = scrollpane == null ? null : scrollpane.getViewport();
                if (viewport == null) {
                    this.oldViewportPosition = null;
                    return;
                }
                boolean vertical = ButtonlessScrollBarUI.this.isVertical();
                Point position = viewport.getViewPosition();
                Dimension dimension = scrollpane.getSize();
                boolean scrolled = false;
                if (this.oldViewportPosition != null) {
                    int scrollH = position.x - this.oldViewportPosition.x;
                    int scrollV = position.y - this.oldViewportPosition.y;
                    scrolled = vertical && scrollH == 0 && scrollV != 0 || !vertical && scrollV == 0 && scrollH != 0;
                }
                this.oldViewportPosition = position;
                boolean resized = false;
                if (this.oldViewportDimension != null) {
                    int resizedH = dimension.width - this.oldViewportDimension.width;
                    int resizedV = dimension.height - this.oldViewportDimension.height;
                    resized = vertical ? resizedV != 0 : resizedH != 0;
                }
                this.oldViewportDimension = dimension;
                if (scrolled) {
                    ScrollBarUI otherUI;
                    JScrollBar other = vertical ? scrollpane.getHorizontalScrollBar() : scrollpane.getVerticalScrollBar();
                    ScrollBarUI scrollBarUI = otherUI = other == null ? null : other.getUI();
                    if (otherUI instanceof ButtonlessScrollBarUI) {
                        ((ButtonlessScrollBarUI)otherUI).startMacScrollbarFadeout(true);
                    }
                    ButtonlessScrollBarUI.this.restart();
                } else if (resized) {
                    ButtonlessScrollBarUI.this.startMacScrollbarFadeout();
                }
            }
        };
        this.myMouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean inside = ButtonlessScrollBarUI.this.isOverThumb(e.getPoint());
                if (inside != ButtonlessScrollBarUI.this.myMouseIsOverThumb) {
                    ButtonlessScrollBarUI.this.myMouseIsOverThumb = inside;
                    ButtonlessScrollBarUI.this.startRegularThumbAnimator();
                }
            }
        };
        this.myMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ButtonlessScrollBarUI.this.myMacScrollbarFadeLevel == 0.0) {
                    ButtonlessScrollBarUI.this.myMouseOverScrollbar = true;
                    ButtonlessScrollBarUI.this.startMacScrollbarExpandAnimator();
                    ButtonlessScrollBarUI.this.startMacScrollbarFadeout();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (ButtonlessScrollBarUI.this.myMouseIsOverThumb) {
                    ButtonlessScrollBarUI.this.myMouseIsOverThumb = false;
                    ButtonlessScrollBarUI.this.startRegularThumbAnimator();
                }
                if (ButtonlessScrollBarUI.this.myMouseOverScrollbar) {
                    ButtonlessScrollBarUI.this.myMouseOverScrollbar = false;
                    ButtonlessScrollBarUI.this.startMacScrollbarExpandAnimator();
                    ButtonlessScrollBarUI.this.startMacScrollbarFadeout();
                }
            }
        };
        this.myHierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getChanged() == ButtonlessScrollBarUI.this.scrollbar && (2L & e.getChangeFlags()) != 0L) {
                    ButtonlessScrollBarUI.this.updateGlobalListeners(false);
                }
                if (e.getChanged() == ButtonlessScrollBarUI.this.scrollbar.getParent() && (4L & e.getChangeFlags()) != 0L) {
                    ButtonlessScrollBarUI.this.restart();
                }
            }
        };
        this.myAWTMouseListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                Container scrollpane;
                if (event.getID() == 503 && !ButtonlessScrollBarUI.this.myMacScrollbarHidden && ButtonlessScrollBarUI.this.myMacScrollbarFadeLevel == 0.0 && (scrollpane = SwingUtilities.getAncestorOfClass(JScrollPane.class, ButtonlessScrollBarUI.this.scrollbar)) != null) {
                    Point loc = ((MouseEvent)event).getLocationOnScreen();
                    SwingUtilities.convertPointFromScreen(loc, scrollpane);
                    if (scrollpane.contains(loc)) {
                        ButtonlessScrollBarUI.this.startMacScrollbarFadeout();
                    }
                }
            }
        };
        this.myWeakListener = new WeakListener(this.myAWTMouseListener);
        this.myNSScrollerListener = new NSScrollerHelper.ScrollbarStyleListener(){

            @Override
            public void styleChanged() {
                ButtonlessScrollBarUI.this.updateMacScrollbarStyle();
            }
        };
    }

    @Override
    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        return new BasicScrollBarUI.ArrowButtonListener(){

            @Override
            public void mousePressed(MouseEvent event) {
            }

            @Override
            public void mouseReleased(MouseEvent event) {
            }
        };
    }

    protected boolean isMacOverlayScrollbar() {
        return this.myMacScrollerStyle == NSScrollerHelper.Style.Overlay && ButtonlessScrollBarUI.isMacOverlayScrollbarSupported();
    }

    public static boolean isMacOverlayScrollbarSupported() {
        return SystemInfo.isMac && !Registry.is("ide.mac.disableMacScrollbars");
    }

    private void updateMacScrollbarStyle() {
        NSScrollerHelper.Style style = NSScrollerHelper.getScrollerStyle();
        if (style != this.myMacScrollerStyle && this.scrollbar != null) {
            this.myMacScrollerStyle = style;
            this.updateStyleDefaults();
            this.restart();
            JScrollPane pane2 = JBScrollPane.findScrollPane(this.scrollbar);
            if (pane2 != null) {
                pane2.revalidate();
            }
        }
    }

    public boolean alwaysShowTrack() {
        return !this.isMacOverlayScrollbar();
    }

    @Override
    public void layoutContainer(Container scrollbarContainer) {
        try {
            super.layoutContainer(scrollbarContainer);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    protected void setThumbBounds(int x, int y, int width, int height) {
        int h;
        int w;
        if (width > 0 && height > 0 && UIManager.getBoolean("ScrollBar.alwaysShowThumb") && !this.alwaysShowTrack() && ((w = this.trackRect.width) > (h = this.trackRect.height) && w == width || w < h && h == height)) {
            height = 0;
            width = 0;
            y = 0;
            x = 0;
        }
        if (this.myRepaintCallback != null) {
            this.scrollbar.repaint(this.trackRect);
        }
        super.setThumbBounds(x, y, width, height);
    }

    @Override
    protected BasicScrollBarUI.ModelListener createModelListener() {
        return new BasicScrollBarUI.ModelListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    super.stateChanged(e);
                }
            }
        };
    }

    public int getDecrementButtonHeight() {
        return Math.max(0, this.decrButton.getHeight());
    }

    public int getIncrementButtonHeight() {
        return Math.max(0, this.incrButton.getHeight());
    }

    private void startRegularThumbAnimator() {
        if (this.myDisposed || this.isMacOverlayScrollbar()) {
            return;
        }
        this.myThumbFadeAnimator.reset();
        if (this.scrollbar != null && this.scrollbar.getValueIsAdjusting() || this.myMouseIsOverThumb || Registry.is("ui.no.bangs.and.whistles")) {
            this.myThumbFadeAnimator.suspend();
            this.myThumbFadeColorShift = this.getAnimationColorShift();
        } else {
            this.myThumbFadeAnimator.resume();
        }
    }

    private void startMacScrollbarExpandAnimator() {
        if (this.myDisposed || !this.isMacOverlayScrollbar()) {
            return;
        }
        if (this.myMouseOverScrollbarExpandLevel == 0.0) {
            this.myMouseOverScrollbarExpandAnimator.reset();
            this.myMouseOverScrollbarExpandAnimator.suspend();
            if (this.myMouseOverScrollbar) {
                this.myMouseOverScrollbarExpandAnimator.resume();
            }
        }
    }

    private void startMacScrollbarFadeout() {
        this.startMacScrollbarFadeout(false);
    }

    private void startMacScrollbarFadeout(boolean now) {
        if (this.myDisposed || !this.isMacOverlayScrollbar()) {
            return;
        }
        this.myMacScrollbarFadeTimer.cancelAllRequests();
        if (now) {
            if (!this.myMacScrollbarHidden && !this.myMacScrollbarFadeAnimator.isRunning()) {
                this.myMacScrollbarFadeAnimator.resume();
            }
            return;
        }
        this.myMacScrollbarFadeAnimator.suspend();
        this.myMacScrollbarFadeAnimator.reset();
        this.myMacScrollbarHidden = false;
        this.myMacScrollbarFadeLevel = 0.0;
        JScrollBar sb = this.scrollbar;
        if (sb != null) {
            sb.repaint();
            Application application = ApplicationManager.getApplication();
            if (!(this.myMouseOverScrollbar || sb.getValueIsAdjusting() || application != null && application.isUnitTestMode())) {
                this.myMacScrollbarFadeTimer.addRequest(() -> this.myMacScrollbarFadeAnimator.resume(), 700, (ModalityState)null);
            }
        }
    }

    @Deprecated
    public static BasicScrollBarUI createNormal() {
        return new ButtonlessScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        int incGap = UIManager.getInt("ScrollBar.incrementButtonGap");
        int decGap = UIManager.getInt("ScrollBar.decrementButtonGap");
        try {
            UIManager.put("ScrollBar.incrementButtonGap", 0);
            UIManager.put("ScrollBar.decrementButtonGap", 0);
            super.installDefaults();
        }
        finally {
            UIManager.put("ScrollBar.incrementButtonGap", incGap);
            UIManager.put("ScrollBar.decrementButtonGap", decGap);
        }
        this.myMacScrollerStyle = NSScrollerHelper.getScrollerStyle();
        this.scrollbar.setFocusable(false);
        this.updateStyleDefaults();
    }

    private void updateStyleDefaults() {
        this.scrollbar.setOpaque(this.alwaysShowTrack());
    }

    @Override
    protected void installListeners() {
        this.myDisposed = false;
        this.initRegularThumbAnimator();
        this.initMacScrollbarAnimators();
        super.installListeners();
        this.scrollbar.addAdjustmentListener(this.myAdjustmentListener);
        this.scrollbar.addMouseListener(this.myMouseListener);
        this.scrollbar.addMouseMotionListener(this.myMouseMotionListener);
        this.scrollbar.addHierarchyListener(this.myHierarchyListener);
        this.updateGlobalListeners(false);
        this.restart();
    }

    private void restart() {
        this.startRegularThumbAnimator();
        this.startMacScrollbarFadeout();
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new BasicScrollBarUI.TrackListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ButtonlessScrollBarUI.this.scrollbar.isEnabled() && SwingUtilities.isLeftMouseButton(e) && !ButtonlessScrollBarUI.this.getThumbBounds().contains(e.getPoint()) && NSScrollerHelper.getClickBehavior() == NSScrollerHelper.ClickBehavior.JumpToSpot && setValueFrom != null) {
                    switch (ButtonlessScrollBarUI.this.scrollbar.getOrientation()) {
                        case 1: {
                            this.offset = ButtonlessScrollBarUI.this.getThumbBounds().height / 2;
                            break;
                        }
                        case 0: {
                            this.offset = ButtonlessScrollBarUI.this.getThumbBounds().width / 2;
                        }
                    }
                    ButtonlessScrollBarUI.this.isDragging = true;
                    try {
                        setValueFrom.invoke((Object)this, e);
                    }
                    catch (Exception ex) {
                        LOG.error(ex);
                    }
                    return;
                }
                super.mousePressed(e);
            }
        };
    }

    private void updateGlobalListeners(boolean forceRemove) {
        boolean shouldAdd = this.scrollbar.isDisplayable();
        if (this.myGlobalListenersAdded && (!shouldAdd || forceRemove)) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.myWeakListener);
            NSScrollerHelper.removeScrollbarStyleListener(this.myNSScrollerListener);
            this.myGlobalListenersAdded = false;
        }
        if (!this.myGlobalListenersAdded && shouldAdd && !forceRemove) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.myWeakListener, 32L);
            NSScrollerHelper.addScrollbarStyleListener(this.myNSScrollerListener);
            this.myGlobalListenersAdded = true;
        }
    }

    private void initRegularThumbAnimator() {
        if (!this.myDisposed) {
            this.myThumbFadeAnimator = new Animator("Regular scrollbar thumb animator", 14, 700, false){

                @Override
                public void paintNow(int frame, int totalFrames, int cycle) {
                    ButtonlessScrollBarUI.this.myThumbFadeColorShift = ButtonlessScrollBarUI.this.getAnimationColorShift();
                    if (frame > 4) {
                        ButtonlessScrollBarUI.this.myThumbFadeColorShift = (int)((double)ButtonlessScrollBarUI.this.myThumbFadeColorShift * (1.0 - (double)(frame - 4) / (double)(totalFrames - 4)));
                    }
                    if (ButtonlessScrollBarUI.this.scrollbar != null) {
                        ButtonlessScrollBarUI.this.scrollbar.repaint(((ButtonlessScrollBarUI)ButtonlessScrollBarUI.this.scrollbar.getUI()).getThumbBounds());
                    }
                }
            };
        }
    }

    private void initMacScrollbarAnimators() {
        if (!this.myDisposed) {
            this.myMouseOverScrollbarExpandAnimator = new Animator("Mac scrollbar mouse over animator", 10, 200, false){

                @Override
                protected void paintCycleEnd() {
                    ButtonlessScrollBarUI.this.myMouseOverScrollbarExpandLevel = 1.0;
                    if (ButtonlessScrollBarUI.this.scrollbar != null) {
                        ButtonlessScrollBarUI.this.scrollbar.repaint();
                    }
                }

                @Override
                public void paintNow(int frame, int totalFrames, int cycle) {
                    int delay = totalFrames / 2;
                    int frameAfterDelay = frame - delay;
                    if (frameAfterDelay > 0) {
                        ButtonlessScrollBarUI.this.myMouseOverScrollbarExpandLevel = (float)frameAfterDelay / (float)(totalFrames - delay);
                        if (ButtonlessScrollBarUI.this.scrollbar != null) {
                            ButtonlessScrollBarUI.this.scrollbar.repaint();
                        }
                    }
                }
            };
            this.myMacScrollbarFadeTimer = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            this.myMacScrollbarFadeAnimator = new Animator("Mac scrollbar fade animator", 30, 300, false){

                @Override
                protected void paintCycleEnd() {
                    ButtonlessScrollBarUI.this.myMacScrollbarHidden = true;
                    ButtonlessScrollBarUI.this.myMouseOverScrollbar = false;
                    ButtonlessScrollBarUI.this.myMouseOverScrollbarExpandLevel = 0.0;
                    if (ButtonlessScrollBarUI.this.scrollbar != null) {
                        ButtonlessScrollBarUI.this.scrollbar.repaint();
                    }
                }

                @Override
                public void paintNow(int frame, int totalFrames, int cycle) {
                    ButtonlessScrollBarUI.this.myMacScrollbarFadeLevel = (float)frame / (float)totalFrames;
                    if (ButtonlessScrollBarUI.this.scrollbar != null) {
                        ButtonlessScrollBarUI.this.scrollbar.repaint();
                    }
                }
            };
        }
    }

    private boolean isOverThumb(Point p) {
        Rectangle bounds2 = this.getThumbBounds();
        return bounds2 != null && bounds2.contains(p);
    }

    @Override
    public Rectangle getThumbBounds() {
        return super.getThumbBounds();
    }

    @Override
    protected void uninstallListeners() {
        if (this.scrollTimer != null) {
            super.uninstallListeners();
        }
        this.scrollbar.removeAdjustmentListener(this.myAdjustmentListener);
        this.scrollbar.removeMouseListener(this.myMouseListener);
        this.scrollbar.removeMouseMotionListener(this.myMouseMotionListener);
        this.scrollbar.removeHierarchyListener(this.myHierarchyListener);
        this.updateGlobalListeners(true);
        if (this.myThumbFadeAnimator != null) {
            Disposer.dispose(this.myThumbFadeAnimator);
            this.myThumbFadeAnimator = null;
        }
        if (this.myMouseOverScrollbarExpandAnimator != null) {
            Disposer.dispose(this.myMouseOverScrollbarExpandAnimator);
        }
        if (this.myMacScrollbarFadeTimer != null) {
            Disposer.dispose(this.myMacScrollbarFadeTimer);
        }
        if (this.myMacScrollbarFadeAnimator != null) {
            Disposer.dispose(this.myMacScrollbarFadeAnimator);
        }
        this.myDisposed = true;
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        int thickness = this.getThickness();
        return this.isVertical() ? new Dimension(thickness, thickness * 2) : new Dimension(thickness * 2, thickness);
    }

    protected int getThickness() {
        int i = this.isMacOverlayScrollbar() ? 15 : 13;
        return JBUIScale.scale(i);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        int thickness = this.getThickness();
        return new Dimension(thickness, thickness);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (this.isMacOverlayScrollbar() && !this.alwaysShowTrack() && !this.alwaysPaintThumb() && this.myMacScrollbarHidden) {
            return false;
        }
        return super.contains(c, x, y);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        RegionPainter<Object> painter;
        if (this.alwaysShowTrack() || this.myMouseOverScrollbarExpandLevel > 0.0) {
            this.doPaintTrack(g, c, trackBounds);
        }
        if ((painter = ComponentUtil.getClientProperty(c, JBScrollBar.TRACK)) != null) {
            painter.paint((Graphics2D)g, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, null);
        }
    }

    protected void doPaintTrack(Graphics g, JComponent c, Rectangle bounds2) {
        if (this.isMacOverlayScrollbar() && !this.alwaysShowTrack()) {
            bounds2 = this.getMacScrollBarBounds(bounds2, false);
            boolean vertical = this.isVertical();
            Color start2 = this.adjustColor(ColorUtil.darker(this.getTrackBackground(), 1));
            Color end = this.adjustColor(this.getTrackBackground().brighter());
            Paint paint2 = vertical ? UIUtil.getGradientPaint(bounds2.x + 1, bounds2.y, start2, bounds2.width + 1, bounds2.y, end) : UIUtil.getGradientPaint(bounds2.x, bounds2.y + 1, start2, bounds2.x, bounds2.height + 1, end);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(paint2);
            g2d.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
            g.setColor(this.adjustColor(start2.darker()));
        } else {
            g.setColor(this.getTrackBackground());
            g.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
            g.setColor(this.getTrackBorderColor());
        }
        if (this.isVertical()) {
            int x = this.scrollbar.getComponentOrientation().isLeftToRight() ? bounds2.x : bounds2.x + bounds2.width - 1;
            g.drawLine(x, bounds2.y, x, bounds2.y + bounds2.height);
        } else {
            g.drawLine(bounds2.x, bounds2.y, bounds2.x + bounds2.width, bounds2.y);
        }
        if (this.myRepaintCallback != null) {
            this.myRepaintCallback.call(g);
        }
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        this.doPaintThumb(g, thumbBounds);
    }

    private void doPaintThumb(Graphics g, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        if (this.isMacOverlayScrollbar()) {
            this.paintMacThumb(g, thumbBounds);
        } else {
            Rectangle bounds2 = new Rectangle(thumbBounds);
            if (this.isThumbTranslucent()) {
                int offset;
                JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(this.scrollbar);
                if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
                    offset = this.getThumbOffset(bounds2.width);
                    if (offset > 0) {
                        bounds2.width -= offset;
                        if (alignment == JBScrollPane.Alignment.RIGHT) {
                            bounds2.x += offset;
                        }
                    }
                } else {
                    offset = this.getThumbOffset(bounds2.height);
                    if (offset > 0) {
                        bounds2.height -= offset;
                        if (alignment == JBScrollPane.Alignment.BOTTOM) {
                            bounds2.y += offset;
                        }
                    }
                }
            } else if (SystemInfo.isMac) {
                boolean vertical = this.scrollbar == null || 1 == this.scrollbar.getOrientation();
                bounds2.x = bounds2.x + (vertical ? 1 : 0);
                bounds2.y = bounds2.y + (vertical ? 0 : 1);
                bounds2.width = bounds2.width - (vertical ? 1 : 0);
                bounds2.height = bounds2.height - (vertical ? 0 : 1);
            } else {
                ++bounds2.x;
                ++bounds2.y;
                bounds2.width -= 2;
                bounds2.height -= 2;
            }
            if (SystemInfo.isMac) {
                int max = JBUIScale.scale(12);
                if (max < bounds2.width && bounds2.width < bounds2.height) {
                    bounds2.x += (bounds2.width - max) / 2;
                    bounds2.width = max;
                } else if (max < bounds2.height && bounds2.height < bounds2.width) {
                    bounds2.y += (bounds2.height - max) / 2;
                    bounds2.height = max;
                }
                float value2 = ButtonlessScrollBarUI.fixAnimationValue((float)this.myThumbFadeColorShift / (float)this.getAnimationColorShift());
                this.myThumbPainter.paint((Graphics2D)g, bounds2.x, bounds2.y, bounds2.width, bounds2.height, Float.valueOf(value2));
            } else {
                float value3 = ButtonlessScrollBarUI.fixAnimationValue((float)this.myThumbFadeColorShift / (float)this.getAnimationColorShift());
                this.myThumbPainter.paint((Graphics2D)g, bounds2.x, bounds2.y, bounds2.width, bounds2.height, Float.valueOf(value3));
            }
        }
    }

    private static float fixAnimationValue(float value2) {
        if (value2 < 0.0f || Double.isNaN(value2)) {
            LOG.debug("unexpected animation value: ", Float.valueOf(value2));
            return 0.0f;
        }
        if (value2 > 1.0f) {
            LOG.debug("animation value is too big: ", Float.valueOf(value2));
            return 1.0f;
        }
        return value2;
    }

    @Deprecated
    protected boolean isThumbTranslucent() {
        return this.scrollbar == null || !this.scrollbar.isOpaque();
    }

    @Deprecated
    protected int getThumbOffset(int value2) {
        float scale = JBUIScale.scale(10);
        switch (UIUtil.getComponentStyle(this.scrollbar)) {
            case LARGE: {
                scale *= 1.15f;
                break;
            }
            case SMALL: {
                scale *= 0.857f;
                break;
            }
            case MINI: {
                scale *= 0.714f;
            }
        }
        return value2 - (int)scale;
    }

    private void paintMacThumb(Graphics g, Rectangle thumbBounds) {
        if (this.isMacScrollbarHiddenAndXcodeLikeScrollbar()) {
            return;
        }
        if (!this.myMacScrollbarHidden || this.alwaysPaintThumb()) {
            thumbBounds = this.getMacScrollBarBounds(thumbBounds, true);
            Graphics2D g2d = (Graphics2D)g;
            float value2 = ButtonlessScrollBarUI.fixAnimationValue((float)(1.0 - this.myMacScrollbarFadeLevel));
            this.myThumbPainter.paint(g2d, thumbBounds.x - 2, thumbBounds.y - 2, thumbBounds.width + 4, thumbBounds.height + 4, Float.valueOf(value2));
        }
    }

    protected boolean isDark() {
        return StartupUiUtil.isUnderDarcula();
    }

    protected boolean alwaysPaintThumb() {
        return this.alwaysShowTrack();
    }

    protected Rectangle getMacScrollBarBounds(Rectangle baseBounds, boolean thumb) {
        int height;
        int width;
        boolean vertical = this.isVertical();
        int borderSize = 2;
        int baseSize = vertical ? baseBounds.width : baseBounds.height;
        int maxSize2 = baseSize - (thumb ? borderSize * 2 : 0);
        int minSize = Math.min(baseSize / 2, JBUIScale.scale(7)) + (thumb ? 0 : borderSize * 2);
        int currentSize = minSize + (int)(this.myMouseOverScrollbarExpandLevel * (double)(maxSize2 - minSize));
        int currentBolderSize = thumb ? borderSize : 0;
        int x = baseBounds.x;
        int y = baseBounds.y;
        if (vertical) {
            x += baseBounds.width - currentSize - currentBolderSize;
            y += currentBolderSize;
            width = currentSize;
            height = baseBounds.height - currentBolderSize * 2;
        } else {
            x += currentBolderSize;
            y += baseBounds.height - currentSize - currentBolderSize;
            width = baseBounds.width - currentBolderSize * 2;
            height = currentSize;
        }
        width = Math.max(width, currentSize);
        height = Math.max(height, currentSize);
        return new Rectangle(x, y, width, height);
    }

    @Override
    public boolean getSupportsAbsolutePositioning() {
        return true;
    }

    protected Color adjustColor(Color c) {
        if (this.isMacOverlayScrollbar()) {
            int alpha = (int)((120.0 + this.myMouseOverScrollbarExpandLevel * 20.0) * (1.0 - this.myMacScrollbarFadeLevel));
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        if (this.myThumbFadeColorShift == 0) {
            return c;
        }
        int sign = this.isDark() ? -1 : 1;
        return Gray.get(Math.max(0, Math.min(255, c.getRed() - sign * this.myThumbFadeColorShift)));
    }

    protected boolean isVertical() {
        return this.scrollbar.getOrientation() == 1;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new EmptyButton();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new EmptyButton();
    }

    protected boolean isMacScrollbarHiddenAndXcodeLikeScrollbar() {
        return this.myMacScrollbarHidden && ButtonlessScrollBarUI.isMacOverlayScrollbarSupported() && ButtonlessScrollBarUI.xcodeLikeScrollbar();
    }

    protected static boolean xcodeLikeScrollbar() {
        return Registry.is("editor.xcode.like.scrollbar");
    }

    public void registerRepaintCallback(ScrollbarRepaintCallback callback2) {
        this.myRepaintCallback = callback2;
    }

    static {
        LOG.assertTrue(setValueFrom != null, "Cannot get TrackListener.setValueFrom method");
    }

    private static final class WeakListener
    implements AWTEventListener {
        private final WeakReference<AWTEventListener> myReference;

        private WeakListener(AWTEventListener listener2) {
            this.myReference = new WeakReference<AWTEventListener>(listener2);
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            AWTEventListener listener2 = (AWTEventListener)this.myReference.get();
            if (listener2 != null) {
                listener2.eventDispatched(event);
            } else {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            }
        }
    }

    public static class Transparent
    extends ButtonlessScrollBarUI {
        @Override
        public boolean alwaysShowTrack() {
            return false;
        }
    }

    public static interface ScrollbarRepaintCallback {
        public void call(Graphics var1);
    }

    private static class EmptyButton
    extends JButton {
        private EmptyButton() {
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
        }

        @Override
        public Dimension getMaximumSize() {
            return JBUI.emptySize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMaximumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getMaximumSize();
        }
    }
}

