/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;

public abstract class ChangesTrackingTableView<T>
extends TableView<T> {
    private Disposable myEditorListenerDisposable;

    protected abstract void onCellValueChanged(int var1, int var2, Object var3);

    protected abstract void onEditingStopped();

    @Override
    public boolean editCellAt(final int row, final int column, EventObject e) {
        if (super.editCellAt(row, column, e)) {
            assert (this.myEditorListenerDisposable == null);
            this.myEditorListenerDisposable = Disposer.newDisposable();
            ChangesTrackingTableView.addChangeListener(this.getEditorComponent(), new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ChangesTrackingTableView.this.onCellValueChanged(row, column, ChangesTrackingTableView.getValue(ChangesTrackingTableView.this.getEditorComponent()));
                }
            }, this.myEditorListenerDisposable);
            return true;
        }
        return false;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor = super.getCellEditor(row, column);
        if (column != 0 || editor instanceof DefaultCellEditor) {
            // empty if block
        }
        return editor;
    }

    @Override
    public void removeEditor() {
        if (this.myEditorListenerDisposable != null) {
            Disposer.dispose(this.myEditorListenerDisposable);
            this.myEditorListenerDisposable = null;
        }
        this.onEditingStopped();
        super.removeEditor();
    }

    public static Object getValue(Component component2) {
        if (component2 instanceof CellEditorComponentWithBrowseButton) {
            JTextField textField2 = (JTextField)((CellEditorComponentWithBrowseButton)component2).getChildComponent();
            return textField2.getText();
        }
        if (component2 instanceof JTextField) {
            return ((JTextField)component2).getText();
        }
        if (component2 instanceof JComboBox) {
            return ((JComboBox)component2).getSelectedItem();
        }
        if (component2 instanceof JCheckBox) {
            return ((JCheckBox)component2).isSelected();
        }
        throw new UnsupportedOperationException("editor control of type " + component2.getClass().getName() + " is not supported");
    }

    private static void addChangeListener(final Component component2, final ChangeListener listener2, Disposable parentDisposable) {
        if (component2 instanceof CellEditorComponentWithBrowseButton) {
            ChangesTrackingTableView.addChangeListener(((CellEditorComponentWithBrowseButton)component2).getChildComponent(), listener2, parentDisposable);
        } else if (component2 instanceof JTextField) {
            final DocumentAdapter documentListener = new DocumentAdapter(){

                @Override
                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    listener2.stateChanged(new ChangeEvent(component2));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/ChangesTrackingTableView$2", "textChanged"));
                }
            };
            final Document document = ((JTextField)component2).getDocument();
            document.addDocumentListener(documentListener);
            Disposer.register(parentDisposable, new Disposable(){

                @Override
                public void dispose() {
                    document.removeDocumentListener(documentListener);
                }
            });
        } else if (component2 instanceof JComboBox) {
            final ActionListener comboListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    listener2.stateChanged(new ChangeEvent(component2));
                }
            };
            ((JComboBox)component2).addActionListener(comboListener);
            Disposer.register(parentDisposable, new Disposable(){

                @Override
                public void dispose() {
                    ((JComboBox)component2).removeActionListener(comboListener);
                }
            });
        } else if (component2 instanceof JCheckBox) {
            final ActionListener checkBoxListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    listener2.stateChanged(new ChangeEvent(component2));
                }
            };
            ((JCheckBox)component2).addActionListener(checkBoxListener);
            Disposer.register(parentDisposable, new Disposable(){

                @Override
                public void dispose() {
                    ((JCheckBox)component2).removeActionListener(checkBoxListener);
                }
            });
        } else {
            throw new UnsupportedOperationException("editor control of type " + component2.getClass().getName() + " is not supported");
        }
    }
}

