/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Comparing;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;

public abstract class ComboBoxCellEditor
extends DefaultCellEditor {
    public ComboBoxCellEditor() {
        super(new JComboBox());
        this.setClickCountToStart(2);
    }

    protected abstract List<String> getComboBoxItems();

    protected boolean isComboboxEditable() {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        JComboBox comboBox2 = (JComboBox)this.editorComponent;
        comboBox2.removeActionListener(this.delegate);
        boolean result2 = super.stopCellEditing();
        comboBox2.addActionListener(this.delegate);
        return result2;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
        String currentValue = (String)value2;
        JComboBox component2 = (JComboBox)super.getTableCellEditorComponent(table, value2, isSelected, row, column);
        component2.removeActionListener(this.delegate);
        component2.setBorder(null);
        component2.removeAllItems();
        List<String> items = this.getComboBoxItems();
        int selected2 = -1;
        for (int i = 0; i < items.size(); ++i) {
            String item = items.get(i);
            component2.addItem(item);
            if (!Comparing.equal(item, currentValue)) continue;
            selected2 = i;
        }
        if (selected2 == -1) {
            component2.setEditable(true);
            component2.setSelectedItem(currentValue);
            component2.setEditable(false);
        } else {
            component2.setSelectedIndex(selected2);
        }
        component2.setEditable(this.isComboboxEditable());
        component2.addActionListener(this.delegate);
        return component2;
    }
}

