/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ui.Line;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class EditorAdapter {
    private static final Logger LOG = Logger.getInstance(EditorAdapter.class);
    private final Editor myEditor;
    private final Alarm myFlushAlarm;
    private final Collection<Line> myLines;
    private final Project myProject;
    private final boolean myScrollToTheEndOnAppend;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flushStoredLines() {
        ArrayList<Line> lines;
        Collection<Line> collection = this.myLines;
        synchronized (collection) {
            lines = new ArrayList<Line>(this.myLines);
            this.myLines.clear();
        }
        if (this.myEditor.isDisposed() || this.myProject != null && this.myProject.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(this.writingCommand(lines));
    }

    public EditorAdapter(@NotNull Editor editor, Project project2, boolean scrollToTheEndOnAppend) {
        if (editor == null) {
            EditorAdapter.$$$reportNull$$$0(0);
        }
        this.myFlushAlarm = new Alarm();
        this.myLines = new ArrayList<Line>();
        this.myEditor = editor;
        this.myProject = project2;
        this.myScrollToTheEndOnAppend = scrollToTheEndOnAppend;
        LOG.assertTrue(this.myEditor.isViewer());
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            EditorAdapter.$$$reportNull$$$0(1);
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(String string, TextAttributes attrs) {
        Collection<Line> collection = this.myLines;
        synchronized (collection) {
            this.myLines.add(new Line(string, attrs));
        }
        if (this.myFlushAlarm.isEmpty()) {
            this.myFlushAlarm.addRequest(this::flushStoredLines, 200, ModalityState.NON_MODAL);
        }
    }

    @NotNull
    private Runnable writingCommand(@NotNull Collection<? extends Line> lines) {
        if (lines == null) {
            EditorAdapter.$$$reportNull$$$0(2);
        }
        Runnable command = () -> {
            Document document = this.myEditor.getDocument();
            StringBuilder buffer = new StringBuilder();
            for (Line line : lines) {
                buffer.append(line.getValue());
            }
            int endBefore = document.getTextLength();
            document.insertString(endBefore, buffer.toString());
            int endBeforeLine = endBefore;
            for (Line line : lines) {
                this.myEditor.getMarkupModel().addRangeHighlighter(endBeforeLine, Math.min(document.getTextLength(), endBeforeLine + line.getValue().length()), 3000, line.getAttributes(), HighlighterTargetArea.EXACT_RANGE);
                if ((endBeforeLine += line.getValue().length()) <= document.getTextLength()) continue;
                break;
            }
            this.shiftCursorToTheEndOfDocument();
        };
        Runnable runnable2 = () -> CommandProcessor.getInstance().executeCommand(this.myProject, command, "", null, UndoConfirmationPolicy.DEFAULT, this.myEditor.getDocument());
        if (runnable2 == null) {
            EditorAdapter.$$$reportNull$$$0(3);
        }
        return runnable2;
    }

    private void shiftCursorToTheEndOfDocument() {
        if (this.myScrollToTheEndOnAppend) {
            this.myEditor.getCaretModel().moveToOffset(this.myEditor.getDocument().getTextLength());
            this.myEditor.getSelectionModel().removeSelection();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/EditorAdapter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/EditorAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "writingCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writingCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

