/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.awt.Dimension;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;

public class FileLabel
extends JLabel {
    protected File myFile;
    private boolean myShowIcon = true;
    private static final int PREFERRED_TEXT_LENGTH = 50;
    private final FilePathSplittingPolicy myPolicy = FilePathSplittingPolicy.SPLIT_BY_SEPARATOR;

    public FileLabel() {
    }

    public FileLabel(File file2) {
        this.myFile = file2;
    }

    public void setShowIcon(boolean showIcon) {
        this.myShowIcon = showIcon;
    }

    public static String getFilePath(File file2) {
        return file2.getPath();
    }

    public void setFile(File ioFile) {
        this.myFile = ioFile;
        if (this.myShowIcon) {
            this.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(this.myFile.getName()).getIcon());
        } else {
            this.setIcon(null);
        }
    }

    @Override
    public String getText() {
        if (this.myFile == null) {
            return "";
        }
        int width = this.getWidth();
        if (this.getIcon() != null) {
            width -= this.getIconWidth();
        }
        return this.myPolicy.getOptimalTextForComponent(this.myFile, this, width);
    }

    public void pack() {
        this.setPreferredSize(new Dimension(this.getPreferredWidth(), this.getPreferredSize().height));
    }

    protected int getPreferredWidth() {
        return this.getIconWidth() + this.getFontMetrics(this.getFont()).stringWidth(this.myPolicy.getPresentableName(this.myFile, 50));
    }

    public int getIconWidth() {
        Icon icon2 = this.getIcon();
        if (icon2 == null) {
            return 0;
        }
        return icon2.getIconWidth() + this.getIconTextGap();
    }
}

