/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public final class FocusUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.FocusUtil");

    public static Component findFocusableComponentIn(Container searchIn, Component toSkip) {
        List components = UIUtil.uiTraverser(searchIn).toList();
        for (Component component2 : components) {
            if (component2.equals(toSkip) || !component2.isFocusable()) continue;
            return component2;
        }
        return searchIn;
    }

    @Nullable
    public static Component getMostRecentComponent(Component component2, Window ancestor) {
        if (ancestor != null) {
            try {
                Component mostRecentFocusOwner = (Component)Objects.requireNonNull(ReflectionUtil.getDeclaredMethod(KeyboardFocusManager.class, "getMostRecentFocusOwner", Window.class)).invoke(null, ancestor);
                if (mostRecentFocusOwner != null && SwingUtilities.isDescendingFrom(mostRecentFocusOwner, component2) && mostRecentFocusOwner.isShowing()) {
                    return mostRecentFocusOwner;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.debug(e);
            }
        }
        return null;
    }

    public static Component getDefaultComponentInPanel(Component component2) {
        if (component2 instanceof JPanel) {
            JPanel container2 = (JPanel)component2;
            FocusTraversalPolicy policy = container2.getFocusTraversalPolicy();
            if (policy == null) {
                return container2;
            }
            Component defaultComponent = policy.getDefaultComponent(container2);
            if (defaultComponent == null) {
                return container2;
            }
            return policy.getDefaultComponent(container2);
        }
        return null;
    }
}

