/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormBuilder {
    private boolean myAlignLabelOnRight = false;
    private int myLineCount = 0;
    private final JPanel myPanel = new JPanel(new GridBagLayout());
    private boolean myVertical = false;
    private int myVerticalGap = 4;
    private int myHorizontalGap = 10;
    private int myFormLeftIndent = 0;

    public static FormBuilder createFormBuilder() {
        return new FormBuilder();
    }

    public FormBuilder addLabeledComponent(@Nullable JComponent label2, @NotNull JComponent component2) {
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(0);
        }
        return this.addLabeledComponent(label2, component2, this.myVerticalGap, false);
    }

    public FormBuilder addLabeledComponent(@Nullable JComponent label2, @NotNull JComponent component2, int topInset) {
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(1);
        }
        return this.addLabeledComponent(label2, component2, topInset, false);
    }

    public FormBuilder addLabeledComponent(@Nullable JComponent label2, @NotNull JComponent component2, boolean labelOnTop) {
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(2);
        }
        return this.addLabeledComponent(label2, component2, this.myVerticalGap, labelOnTop);
    }

    public FormBuilder addLabeledComponent(@NotNull @Nls String labelText, @NotNull JComponent component2) {
        if (labelText == null) {
            FormBuilder.$$$reportNull$$$0(3);
        }
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(4);
        }
        return this.addLabeledComponent(labelText, component2, this.myVerticalGap, false);
    }

    public FormBuilder addLabeledComponent(@NotNull @Nls String labelText, @NotNull JComponent component2, int topInset) {
        if (labelText == null) {
            FormBuilder.$$$reportNull$$$0(5);
        }
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(6);
        }
        return this.addLabeledComponent(labelText, component2, topInset, false);
    }

    public FormBuilder addLabeledComponent(@NotNull @Nls String labelText, @NotNull JComponent component2, boolean labelOnTop) {
        if (labelText == null) {
            FormBuilder.$$$reportNull$$$0(7);
        }
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(8);
        }
        return this.addLabeledComponent(labelText, component2, this.myVerticalGap, labelOnTop);
    }

    public FormBuilder addLabeledComponent(@NotNull @Nls String labelText, @NotNull JComponent component2, int topInset, boolean labelOnTop) {
        if (labelText == null) {
            FormBuilder.$$$reportNull$$$0(9);
        }
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(10);
        }
        JLabel label2 = FormBuilder.createLabelForComponent(labelText, component2);
        return this.addLabeledComponent(label2, component2, topInset, labelOnTop);
    }

    @NotNull
    private static JLabel createLabelForComponent(@NotNull @Nls String labelText, @NotNull JComponent component2) {
        if (labelText == null) {
            FormBuilder.$$$reportNull$$$0(11);
        }
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(12);
        }
        JLabel label2 = new JLabel(UIUtil.removeMnemonic(labelText));
        int index = UIUtil.getDisplayMnemonicIndex(labelText);
        if (index != -1) {
            label2.setDisplayedMnemonic(labelText.charAt(index + 1));
            label2.setDisplayedMnemonicIndex(index);
        }
        label2.setLabelFor(component2);
        JLabel jLabel = label2;
        if (jLabel == null) {
            FormBuilder.$$$reportNull$$$0(13);
        }
        return jLabel;
    }

    public FormBuilder addComponent(@NotNull JComponent component2) {
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(14);
        }
        return this.addLabeledComponent((JComponent)null, component2, this.myVerticalGap, false);
    }

    public FormBuilder addComponent(@NotNull JComponent component2, int topInset) {
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(15);
        }
        return this.addLabeledComponent((JComponent)null, component2, topInset, false);
    }

    @NotNull
    public FormBuilder addComponentFillVertically(@NotNull JComponent component2, int topInset) {
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(16);
        }
        FormBuilder formBuilder = this.addLabeledComponent(null, component2, topInset, false, true);
        if (formBuilder == null) {
            FormBuilder.$$$reportNull$$$0(17);
        }
        return formBuilder;
    }

    public FormBuilder addSeparator(int topInset) {
        return this.addComponent(new JSeparator(), topInset);
    }

    public FormBuilder addSeparator() {
        return this.addSeparator(this.myVerticalGap);
    }

    public FormBuilder addVerticalGap(int height) {
        if (height == -1) {
            this.myPanel.add((Component)new JLabel(), new GridBagConstraints(0, this.myLineCount++, 2, 1, 0.0, 1.0, 10, 0, JBUI.emptyInsets(), 0, 0));
            return this;
        }
        return this.addLabeledComponent((JComponent)null, (JComponent)new Box.Filler(new JBDimension(0, height), new JBDimension(0, height), new JBDimension(Short.MAX_VALUE, height)));
    }

    public FormBuilder addTooltip(String text2) {
        JBLabel label2 = new JBLabel(text2, UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER);
        label2.setBorder(JBUI.Borders.emptyLeft(10));
        return this.addComponentToRightColumn(label2, 1);
    }

    public FormBuilder addComponentToRightColumn(@NotNull JComponent component2) {
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(18);
        }
        return this.addComponentToRightColumn(component2, this.myVerticalGap);
    }

    public FormBuilder addComponentToRightColumn(@NotNull JComponent component2, int topInset) {
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(19);
        }
        return this.addLabeledComponent((JComponent)new JLabel(), component2, topInset);
    }

    public FormBuilder addLabeledComponent(@Nullable JComponent label2, @NotNull JComponent component2, int topInset, boolean labelOnTop) {
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(20);
        }
        boolean fillVertically = component2 instanceof JScrollPane;
        return this.addLabeledComponent(label2, component2, topInset, labelOnTop, fillVertically);
    }

    public FormBuilder addLabeledComponentFillVertically(@NotNull @Nls String labelText, @NotNull JComponent component2) {
        if (labelText == null) {
            FormBuilder.$$$reportNull$$$0(21);
        }
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(22);
        }
        JLabel label2 = FormBuilder.createLabelForComponent(labelText, component2);
        return this.addLabeledComponent(label2, component2, this.myVerticalGap, true, true);
    }

    private FormBuilder addLabeledComponent(@Nullable JComponent label2, @NotNull JComponent component2, int topInset, boolean labelOnTop, boolean fillVertically) {
        if (component2 == null) {
            FormBuilder.$$$reportNull$$$0(23);
        }
        GridBagConstraints c = new GridBagConstraints();
        int n = topInset = this.myLineCount > 0 ? topInset : 0;
        if (this.myVertical || labelOnTop || label2 == null) {
            c.gridwidth = 2;
            c.gridx = 0;
            c.gridy = this.myLineCount;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.anchor = this.getLabelAnchor(false, fillVertically);
            c.insets = JBUI.insets(topInset, this.myFormLeftIndent, 4, 0);
            if (label2 != null) {
                this.myPanel.add((Component)label2, c);
            }
            c.gridx = 0;
            c.gridy = this.myLineCount + 1;
            c.weightx = 1.0;
            c.weighty = FormBuilder.getWeightY(fillVertically);
            c.fill = this.getFill(component2, fillVertically);
            c.anchor = 17;
            c.insets = JBUI.insets(label2 == null ? topInset : 0, this.myFormLeftIndent, 0, 0);
            this.myPanel.add((Component)component2, c);
            this.myLineCount += 2;
        } else {
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = this.myLineCount++;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.anchor = this.getLabelAnchor(true, fillVertically);
            c.insets = JBUI.insets(topInset, this.myFormLeftIndent, 0, this.myHorizontalGap);
            this.myPanel.add((Component)label2, c);
            c.gridx = 1;
            c.weightx = 1.0;
            c.weighty = FormBuilder.getWeightY(fillVertically);
            c.fill = this.getFill(component2, fillVertically);
            c.anchor = 17;
            c.insets = JBUI.insets(topInset, 0, 0, 0);
            this.myPanel.add((Component)component2, c);
        }
        return this;
    }

    private int getLabelAnchor(boolean honorAlignment, boolean fillVertically) {
        if (fillVertically) {
            return honorAlignment && this.myAlignLabelOnRight ? 12 : 18;
        }
        return honorAlignment && this.myAlignLabelOnRight ? 13 : 17;
    }

    protected int getFill(JComponent component2) {
        if (component2 instanceof JComboBox || component2 instanceof JSpinner || component2 instanceof JButton || component2 instanceof JTextField && ((JTextField)component2).getColumns() != 0) {
            return 0;
        }
        return 2;
    }

    private int getFill(JComponent component2, boolean fillVertically) {
        if (fillVertically) {
            return 1;
        }
        return this.getFill(component2);
    }

    private static int getWeightY(boolean fillVertically) {
        return fillVertically ? 1 : 0;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public int getLineCount() {
        return this.myLineCount;
    }

    public FormBuilder setAlignLabelOnRight(boolean alignLabelOnRight) {
        this.myAlignLabelOnRight = alignLabelOnRight;
        return this;
    }

    public FormBuilder setVertical(boolean vertical) {
        this.myVertical = vertical;
        return this;
    }

    public FormBuilder setVerticalGap(int verticalGap) {
        this.myVerticalGap = verticalGap;
        return this;
    }

    public FormBuilder setHorizontalGap(int horizontalGap) {
        this.myHorizontalGap = horizontalGap;
        return this;
    }

    public FormBuilder setFormLeftIndent(int formLeftIndent) {
        this.myFormLeftIndent = formLeftIndent;
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/FormBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/FormBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabelForComponent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addComponentFillVertically";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLabeledComponent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createLabelForComponent";
                break;
            }
            case 13: 
            case 17: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addComponentFillVertically";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addComponentToRightColumn";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addLabeledComponentFillVertically";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

