/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.MethodInvocator;
import com.intellij.util.ui.AATextInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphicsUtil {
    private static final MethodInvocator ourSafelyGetGraphicsMethod = new MethodInvocator(JComponent.class, "safelyGetGraphics", Component.class);
    private static final Graphics2D ourGraphics = new BufferedImage(1, 1, 2).createGraphics();

    public static void applyRenderingHints(@NotNull Graphics2D g) {
        Toolkit tk;
        Map map2;
        if (g == null) {
            GraphicsUtil.$$$reportNull$$$0(0);
        }
        if ((map2 = (Map)(tk = Toolkit.getDefaultToolkit()).getDesktopProperty("awt.font.desktophints")) != null) {
            g.addRenderingHints(map2);
        }
    }

    public static void setupFractionalMetrics(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public static void setupAntialiasing(@NotNull Graphics g2) {
        if (g2 == null) {
            GraphicsUtil.$$$reportNull$$$0(1);
        }
        GraphicsUtil.setupAntialiasing(g2, true, false);
    }

    public static int stringWidth(@NotNull String text2, Font font) {
        if (text2 == null) {
            GraphicsUtil.$$$reportNull$$$0(2);
        }
        GraphicsUtil.setupAntialiasing(ourGraphics, true, true);
        return ourGraphics.getFontMetrics(font).stringWidth(text2);
    }

    public static int charWidth(char ch, Font font) {
        return ourGraphics.getFontMetrics(font).charWidth(ch);
    }

    public static int charWidth(int ch, Font font) {
        return ourGraphics.getFontMetrics(font).charWidth(ch);
    }

    public static void setupAntialiasing(Graphics g2, boolean enableAA, boolean ignoreSystemSettings) {
        if (g2 instanceof Graphics2D) {
            Graphics2D g = (Graphics2D)g2;
            Toolkit tk = Toolkit.getDefaultToolkit();
            Map map2 = (Map)tk.getDesktopProperty("awt.font.desktophints");
            if (map2 != null && !ignoreSystemSettings) {
                g.addRenderingHints(map2);
            } else {
                Object hint = enableAA ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, hint);
            }
        }
    }

    public static GraphicsConfig setupRoundedBorderAntialiasing(Graphics g) {
        return new GraphicsConfig(g).setupRoundedBorderAntialiasing();
    }

    public static GraphicsConfig setupAAPainting(Graphics g) {
        return new GraphicsConfig(g).setupAAPainting();
    }

    public static GraphicsConfig disableAAPainting(Graphics g) {
        return new GraphicsConfig(g).disableAAPainting();
    }

    public static GraphicsConfig paintWithAlpha(Graphics g, float alpha) {
        return new GraphicsConfig(g).paintWithAlpha(alpha);
    }

    public static Graphics safelyGetGraphics(Component c) {
        return ourSafelyGetGraphicsMethod.isAvailable() ? (Graphics)ourSafelyGetGraphicsMethod.invoke(null, c) : c.getGraphics();
    }

    public static Object getAntialiasingType(@NotNull JComponent component2) {
        if (component2 == null) {
            GraphicsUtil.$$$reportNull$$$0(3);
        }
        return AATextInfo.getClientProperty(component2);
    }

    public static void setAntialiasingType(@NotNull JComponent component2, @Nullable Object type) {
        if (component2 == null) {
            GraphicsUtil.$$$reportNull$$$0(4);
        }
        AATextInfo.putClientProperty(type, component2);
    }

    public static Object createAATextInfo(@NotNull Object hint) {
        if (hint == null) {
            GraphicsUtil.$$$reportNull$$$0(5);
        }
        return AATextInfo.create(hint, UIUtil.getLcdContrastValue());
    }

    static {
        GraphicsUtil.setupFractionalMetrics(ourGraphics);
        GraphicsUtil.setupAntialiasing(ourGraphics, true, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/GraphicsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyRenderingHints";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setupAntialiasing";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "stringWidth";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAntialiasingType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setAntialiasingType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createAATextInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

