/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalPathCellEditor
extends AbstractTableCellEditor {
    private final String myTitle;
    private final Project myProject;
    private FileChooserDescriptor myFileChooserDescriptor;
    private boolean myNormalizePath;
    protected CellEditorComponentWithBrowseButton<JTextField> myComponent;

    public LocalPathCellEditor(@Nullable String title, @Nullable Project project2) {
        this.myTitle = title;
        this.myProject = project2;
    }

    public LocalPathCellEditor(@Nullable Project project2) {
        this(null, project2);
    }

    public LocalPathCellEditor() {
        this(null, null);
    }

    public LocalPathCellEditor fileChooserDescriptor(@NotNull FileChooserDescriptor value2) {
        if (value2 == null) {
            LocalPathCellEditor.$$$reportNull$$$0(0);
        }
        this.myFileChooserDescriptor = value2;
        return this;
    }

    public LocalPathCellEditor normalizePath(boolean value2) {
        this.myNormalizePath = value2;
        return this;
    }

    @Override
    public Object getCellEditorValue() {
        String value2 = this.myComponent.getChildComponent().getText();
        return this.myNormalizePath ? PathUtil.toSystemDependentName(StringUtil.nullize(value2)) : value2;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
        this.myComponent = new CellEditorComponentWithBrowseButton<JTextField>(new TextFieldWithBrowseButton(this.createActionListener(table)), this);
        this.myComponent.getChildComponent().setText((String)value2);
        return this.myComponent;
    }

    protected ActionListener createActionListener(final JTable table) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String initial = (String)LocalPathCellEditor.this.getCellEditorValue();
                VirtualFile initialFile = StringUtil.isNotEmpty(initial) ? LocalFileSystem.getInstance().findFileByPath(initial) : null;
                FileChooser.chooseFile(LocalPathCellEditor.this.getFileChooserDescriptor(), LocalPathCellEditor.this.myProject, table, initialFile, file2 -> {
                    String path2 = file2.getPresentableUrl();
                    if (SystemInfo.isWindows && path2.length() == 2 && Character.isLetter(path2.charAt(0)) && path2.charAt(1) == ':') {
                        path2 = path2 + "\\";
                    }
                    LocalPathCellEditor.this.myComponent.getChildComponent().setText(path2);
                });
            }
        };
    }

    public FileChooserDescriptor getFileChooserDescriptor() {
        if (this.myFileChooserDescriptor == null) {
            this.myFileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            if (this.myTitle != null) {
                this.myFileChooserDescriptor.setTitle(this.myTitle);
            }
            this.myFileChooserDescriptor.setShowFileSystemRoots(true);
        }
        return this.myFileChooserDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/ui/LocalPathCellEditor", "fileChooserDescriptor"));
    }
}

