/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NSScrollerHelper {
    private static final Callback APPEARANCE_CALLBACK = new Callback(){

        public void callback(ID self, Pointer selector, ID event) {
            UIUtil.invokeLaterIfNeeded(() -> NSScrollerHelper.fireStyleChanged());
        }
    };
    private static final Callback BEHAVIOR_CALLBACK = new Callback(){

        public void callback(ID self, Pointer selector, ID event) {
            UIUtil.invokeLaterIfNeeded(() -> NSScrollerHelper.updateBehaviorPreferences());
        }
    };
    private static ClickBehavior ourClickBehavior = null;
    private static final List<Reference<ScrollbarStyleListener>> ourStyleListeners = new ArrayList<Reference<ScrollbarStyleListener>>();

    NSScrollerHelper() {
    }

    private static boolean isOverlayScrollbarSupported() {
        return SystemInfo.isMac && SystemInfo.isMacOSMountainLion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initNotificationObserver() {
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        ID delegateClass = Foundation.allocateObjcClassPair(Foundation.getObjcClass("NSObject"), "NSScrollerChangesObserver");
        if (!ID.NIL.equals((Object)delegateClass)) {
            if (!Foundation.addMethod(delegateClass, Foundation.createSelector("handleScrollerStyleChanged:"), APPEARANCE_CALLBACK, "v@")) {
                throw new RuntimeException("Cannot add observer method");
            }
            if (!Foundation.addMethod(delegateClass, Foundation.createSelector("handleBehaviorChanged:"), BEHAVIOR_CALLBACK, "v@")) {
                throw new RuntimeException("Cannot add observer method");
            }
            Foundation.registerObjcClassPair(delegateClass);
        }
        ID delegate = Foundation.invoke("NSScrollerChangesObserver", "new", new Object[0]);
        try {
            ID center = Foundation.invoke("NSNotificationCenter", "defaultCenter", new Object[0]);
            Foundation.invoke(center, "addObserver:selector:name:object:", new Object[]{delegate, Foundation.createSelector("handleScrollerStyleChanged:"), Foundation.nsString("NSPreferredScrollerStyleDidChangeNotification"), ID.NIL});
            center = Foundation.invoke("NSDistributedNotificationCenter", "defaultCenter", new Object[0]);
            Foundation.invoke(center, "addObserver:selector:name:object:", new Object[]{delegate, Foundation.createSelector("handleBehaviorChanged:"), Foundation.nsString("AppleNoRedisplayAppearancePreferenceChanged"), ID.NIL, 2});
        }
        finally {
            pool.drain();
        }
    }

    @Nullable
    public static ClickBehavior getClickBehavior() {
        if (!SystemInfo.isMac) {
            return null;
        }
        return ourClickBehavior;
    }

    private static void updateBehaviorPreferences() {
        if (!SystemInfo.isMac) {
            return;
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            ID defaults = Foundation.invoke("NSUserDefaults", "standardUserDefaults", new Object[0]);
            Foundation.invoke(defaults, "synchronize", new Object[0]);
            ourClickBehavior = Foundation.invoke(defaults, "boolForKey:", new Object[]{Foundation.nsString("AppleScrollerPagingBehavior")}).intValue() == 1 ? ClickBehavior.JumpToSpot : ClickBehavior.NextPage;
        }
        finally {
            pool.drain();
        }
    }

    @Nullable
    public static Style getScrollerStyle() {
        if (!NSScrollerHelper.isOverlayScrollbarSupported()) {
            return null;
        }
        Foundation.NSAutoreleasePool pool = new Foundation.NSAutoreleasePool();
        try {
            if (Foundation.invoke(Foundation.getObjcClass("NSScroller"), "preferredScrollerStyle", new Object[0]).intValue() == 1) {
                Style style = Style.Overlay;
                return style;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            pool.drain();
        }
        return Style.Legacy;
    }

    public static void addScrollbarStyleListener(@NotNull ScrollbarStyleListener listener2) {
        if (listener2 == null) {
            NSScrollerHelper.$$$reportNull$$$0(0);
        }
        NSScrollerHelper.processReferences(listener2, null, null);
    }

    public static void removeScrollbarStyleListener(@NotNull ScrollbarStyleListener listener2) {
        if (listener2 == null) {
            NSScrollerHelper.$$$reportNull$$$0(1);
        }
        NSScrollerHelper.processReferences(null, listener2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processReferences(ScrollbarStyleListener toAdd, ScrollbarStyleListener toRemove2, List<? super ScrollbarStyleListener> list2) {
        List<Reference<ScrollbarStyleListener>> list3 = ourStyleListeners;
        synchronized (list3) {
            Iterator<Reference<ScrollbarStyleListener>> iterator2 = ourStyleListeners.iterator();
            while (iterator2.hasNext()) {
                Reference<ScrollbarStyleListener> reference2 = iterator2.next();
                ScrollbarStyleListener ui = reference2.get();
                if (ui == null || ui == toRemove2) {
                    iterator2.remove();
                    continue;
                }
                if (list2 == null) continue;
                list2.add(ui);
            }
            if (toAdd != null) {
                ourStyleListeners.add(new WeakReference<ScrollbarStyleListener>(toAdd));
            }
        }
    }

    private static void fireStyleChanged() {
        ArrayList list2 = new ArrayList();
        NSScrollerHelper.processReferences(null, null, list2);
        for (ScrollbarStyleListener listener2 : list2) {
            listener2.styleChanged();
        }
    }

    static {
        if (SystemInfo.isMac) {
            NSScrollerHelper.initNotificationObserver();
            NSScrollerHelper.updateBehaviorPreferences();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "listener";
        objectArray2[1] = "com/intellij/util/ui/NSScrollerHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addScrollbarStyleListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeScrollbarStyleListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ScrollbarStyleListener
    extends EventListener {
        public void styleChanged();
    }

    public static enum Style {
        Legacy,
        Overlay;

    }

    public static enum ClickBehavior {
        NextPage,
        JumpToSpot;

    }
}

