/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.FilePathSplittingPolicy;
import java.io.File;

public class SplitByLetterPolicy
extends FilePathSplittingPolicy {
    protected SplitByLetterPolicy() {
    }

    @Override
    public String getPresentableName(File file2, int count) {
        String filePath2 = file2.getPath();
        if (count >= filePath2.length()) {
            return filePath2;
        }
        int nameLength = file2.getName().length();
        if (count <= nameLength) {
            return filePath2.substring(filePath2.length() - count);
        }
        int dotsCount = Math.min(3, count - nameLength);
        int shownCount = count - dotsCount;
        int leftCount = (shownCount - nameLength) / 2 + (shownCount - nameLength) % 2;
        int rightCount = shownCount - leftCount;
        return filePath2.substring(0, leftCount) + SplitByLetterPolicy.dots(dotsCount) + filePath2.substring(filePath2.length() - rightCount);
    }

    private static String dots(int count) {
        switch (count) {
            case 1: {
                return ".";
            }
            case 2: {
                return "..";
            }
        }
        return "...";
    }
}

